/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import panels.TableSorter;
import panels.TimeSlotTableModel;
import resources.CRTime;
import resources.CRTimeException;
import resources.TimeSlot;

public class TimeSlotsPanel
extends JPanel
implements Observer {
    private JButton addButton;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox cbFriday;
    private JCheckBox cbMonday;
    private JCheckBox cbSaturday;
    private JCheckBox cbSunday;
    private JCheckBox cbThursday;
    private JCheckBox cbTuesday;
    private JCheckBox cbWednesday;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel21;
    private JPanel jPanel3;
    private JPanel jPanel31;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel51;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JRadioButton rbStartAM;
    private JRadioButton rbStartPM;
    private JRadioButton rbStopAM;
    private JRadioButton rbStopPM;
    private JTextField tfStartHours;
    private JTextField tfStartMinutes;
    private JTextField tfStopHours;
    private JTextField tfStopMinutes;
    private TimeSlotsPanelListener timeSlotsPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private TimeSlotTableModel ptm;
    private TableSorter sorter;
    private TableColumn daysColumn;
    private TableColumn startColumn;
    private TableColumn endColumn;
    private JTextField editDays = new JTextField();
    private JTextField editStart = new JTextField();
    private JTextField editStop = new JTextField();
    private Component parent;

    public TimeSlotsPanel(Component parent) {
        this.initComponents();
        this.parent = parent;
        this.ptm = new TimeSlotTableModel();
        this.sorter = new TableSorter(this.ptm);
        this.sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.jTable1.setModel(this.sorter);
        this.addListeners();
        this.setColumnSizes();
    }

    private void setColumnSizes() {
        TableColumn column = null;
        column = this.jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = this.jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(25);
        column = this.jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(25);
        this.daysColumn = this.jTable1.getColumnModel().getColumn(0);
        this.startColumn = this.jTable1.getColumnModel().getColumn(1);
        this.endColumn = this.jTable1.getColumnModel().getColumn(2);
    }

    private void addListeners() {
        TimeSlotsPanelListener timeSlotsPanelListener = new TimeSlotsPanelListener();
        this.addButton.addActionListener(timeSlotsPanelListener);
        this.deleteButton.addActionListener(timeSlotsPanelListener);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.deleteButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel11 = new JPanel();
        this.cbSunday = new JCheckBox();
        this.cbMonday = new JCheckBox();
        this.cbTuesday = new JCheckBox();
        this.cbWednesday = new JCheckBox();
        this.cbThursday = new JCheckBox();
        this.cbFriday = new JCheckBox();
        this.cbSaturday = new JCheckBox();
        this.jPanel21 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfStartHours = new JTextField();
        this.jLabel2 = new JLabel();
        this.tfStartMinutes = new JTextField();
        this.jPanel5 = new JPanel();
        this.rbStartAM = new JRadioButton();
        this.rbStartPM = new JRadioButton();
        this.jPanel31 = new JPanel();
        this.jLabel11 = new JLabel();
        this.tfStopHours = new JTextField();
        this.jLabel21 = new JLabel();
        this.tfStopMinutes = new JTextField();
        this.jPanel51 = new JPanel();
        this.rbStopAM = new JRadioButton();
        this.rbStopPM = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.addButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setToolTipText("Hour (use 12 hour clock)");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setToolTipText("Double click on header to sort");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.deleteButton.setText("Delete Selected Time Slot(s)");
        this.deleteButton.setToolTipText("Delete time slots no longer needed");
        this.deleteButton.setMaximumSize(new Dimension(225, 26));
        this.deleteButton.setMinimumSize(new Dimension(250, 26));
        this.deleteButton.setPreferredSize(new Dimension(210, 26));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSlotsPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.deleteButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(17, 17, 17, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.jPanel11.setLayout(new GridBagLayout());
        this.cbSunday.setText("Sunday");
        this.cbSunday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbSunday, gridBagConstraints);
        this.cbMonday.setText("Monday");
        this.cbMonday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbMonday, gridBagConstraints);
        this.cbTuesday.setText("Tuesday");
        this.cbTuesday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbTuesday, gridBagConstraints);
        this.cbWednesday.setText("Wednesday");
        this.cbWednesday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbWednesday, gridBagConstraints);
        this.cbThursday.setText("Thursday (R)");
        this.cbThursday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbThursday, gridBagConstraints);
        this.cbFriday.setText("Friday");
        this.cbFriday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbFriday, gridBagConstraints);
        this.cbSaturday.setText("Saturday");
        this.cbSaturday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.cbSaturday, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 17;
        gridBagConstraints.insets = new Insets(17, 20, 0, 0);
        this.jPanel2.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel21.setLayout(new GridBagLayout());
        this.jLabel1.setText("Start Time:  ");
        this.jPanel21.add((Component)this.jLabel1, new GridBagConstraints());
        this.tfStartHours.setToolTipText("Hour (use 12 hour clock)");
        this.tfStartHours.setPreferredSize(new Dimension(25, 20));
        this.jPanel21.add((Component)this.tfStartHours, new GridBagConstraints());
        this.jLabel2.setText(":");
        this.jPanel21.add((Component)this.jLabel2, new GridBagConstraints());
        this.tfStartMinutes.setToolTipText("Minute");
        this.tfStartMinutes.setPreferredSize(new Dimension(25, 20));
        this.jPanel21.add((Component)this.tfStartMinutes, new GridBagConstraints());
        this.jPanel5.setLayout(new GridBagLayout());
        this.rbStartAM.setText("AM");
        this.rbStartAM.setToolTipText("Must select one of AM/PM");
        this.buttonGroup1.add(this.rbStartAM);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel5.add((Component)this.rbStartAM, gridBagConstraints);
        this.rbStartPM.setText("PM");
        this.rbStartPM.setToolTipText("Must select one of AM/PM");
        this.buttonGroup1.add(this.rbStartPM);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel5.add((Component)this.rbStartPM, gridBagConstraints);
        this.jPanel21.add((Component)this.jPanel5, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 26;
        gridBagConstraints.ipady = 22;
        gridBagConstraints.insets = new Insets(50, 10, 0, 0);
        this.jPanel2.add((Component)this.jPanel21, gridBagConstraints);
        this.jPanel31.setLayout(new GridBagLayout());
        this.jLabel11.setText("Stop Time:  ");
        this.jPanel31.add((Component)this.jLabel11, new GridBagConstraints());
        this.tfStopHours.setToolTipText("Hour (use 12 hour clock)");
        this.tfStopHours.setPreferredSize(new Dimension(25, 20));
        this.jPanel31.add((Component)this.tfStopHours, new GridBagConstraints());
        this.jLabel21.setText(":");
        this.jPanel31.add((Component)this.jLabel21, new GridBagConstraints());
        this.tfStopMinutes.setToolTipText("Minute");
        this.tfStopMinutes.setPreferredSize(new Dimension(25, 20));
        this.jPanel31.add((Component)this.tfStopMinutes, new GridBagConstraints());
        this.jPanel51.setLayout(new GridBagLayout());
        this.rbStopAM.setText("AM");
        this.rbStopAM.setToolTipText("Must select one of AM/PM");
        this.buttonGroup2.add(this.rbStopAM);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel51.add((Component)this.rbStopAM, gridBagConstraints);
        this.rbStopPM.setText("PM");
        this.rbStopPM.setToolTipText("Must select one of AM/PM");
        this.buttonGroup2.add(this.rbStopPM);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel51.add((Component)this.rbStopPM, gridBagConstraints);
        this.jPanel31.add((Component)this.jPanel51, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 28;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jPanel31, gridBagConstraints);
        this.addButton.setText("Add Time Slot");
        this.addButton.setToolTipText("Add this timeslot to the list");
        this.jPanel4.add(this.addButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 31;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 30, 17, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 17, 0, 17);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
    }

    public void update(Observable observable, Object obj) {
        this.ptm.fireTableDataChanged();
    }

    private boolean setDayFlags(boolean[] tempdays) {
        boolean result = false;
        if (this.cbSunday.isSelected()) {
            result = true;
            tempdays[1] = true;
        }
        if (this.cbMonday.isSelected()) {
            result = true;
            tempdays[2] = true;
        }
        if (this.cbTuesday.isSelected()) {
            result = true;
            tempdays[3] = true;
        }
        if (this.cbWednesday.isSelected()) {
            result = true;
            tempdays[4] = true;
        }
        if (this.cbThursday.isSelected()) {
            result = true;
            tempdays[5] = true;
        }
        if (this.cbFriday.isSelected()) {
            result = true;
            tempdays[6] = true;
        }
        if (this.cbSaturday.isSelected()) {
            result = true;
            tempdays[7] = true;
        }
        return result;
    }

    class TimeSlotsPanelListener
    implements ActionListener {
        TimeSlotsPanelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear |" + e.getActionCommand() + "|");
            if (e.getActionCommand().equals("Add Time Slot")) {
                CRTime tempStop;
                CRTime tempStart;
                boolean anyDaySet = false;
                boolean[] tempDays = new boolean[8];
                anyDaySet = TimeSlotsPanel.this.setDayFlags(tempDays);
                if (!anyDaySet) {
                    JOptionPane.showMessageDialog(TimeSlotsPanel.this.parent, "You must pick at least one day of the week");
                    return;
                }
                try {
                    tempStart = new CRTime(Integer.parseInt(TimeSlotsPanel.this.tfStartHours.getText().trim()), Integer.parseInt(TimeSlotsPanel.this.tfStartMinutes.getText().trim()), TimeSlotsPanel.this.rbStartAM.isSelected());
                    tempStop = new CRTime(Integer.parseInt(TimeSlotsPanel.this.tfStopHours.getText().trim()), Integer.parseInt(TimeSlotsPanel.this.tfStopMinutes.getText().trim()), TimeSlotsPanel.this.rbStopAM.isSelected());
                }
                catch (CRTimeException crte) {
                    JOptionPane.showMessageDialog(TimeSlotsPanel.this.parent, crte.getMessage());
                    return;
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(TimeSlotsPanel.this.parent, "You must enter a valid number (1-12) in the hour and minute fields");
                    return;
                }
                TimeSlotsPanel.this.schedule.addTimeSlot(new TimeSlot(tempDays, tempStart, tempStop));
                TimeSlotsPanel.this.cbSunday.setSelected(false);
                TimeSlotsPanel.this.cbMonday.setSelected(false);
                TimeSlotsPanel.this.cbTuesday.setSelected(false);
                TimeSlotsPanel.this.cbWednesday.setSelected(false);
                TimeSlotsPanel.this.cbThursday.setSelected(false);
                TimeSlotsPanel.this.cbFriday.setSelected(false);
                TimeSlotsPanel.this.cbSaturday.setSelected(false);
                TimeSlotsPanel.this.rbStartAM.setSelected(false);
                TimeSlotsPanel.this.rbStopAM.setSelected(false);
                TimeSlotsPanel.this.rbStartPM.setSelected(false);
                TimeSlotsPanel.this.rbStopPM.setSelected(false);
                TimeSlotsPanel.this.tfStartHours.setText("");
                TimeSlotsPanel.this.tfStartMinutes.setText("");
                TimeSlotsPanel.this.tfStopHours.setText("");
                TimeSlotsPanel.this.tfStopMinutes.setText("");
            } else if (e.getActionCommand().equals("Delete Selected Time Slot(s)")) {
                System.out.println("I'm deleting a time slot over here");
                int[] selected = TimeSlotsPanel.this.jTable1.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    int realIndex = TimeSlotsPanel.this.sorter.map(selected[i]);
                    TimeSlotsPanel.this.schedule.removeTimeSlot((TimeSlot)TimeSlotsPanel.this.schedule.getTimeSlots().get(realIndex));
                }
            }
        }
    }
}

