/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.Serializable;
import resources.Constants;

public class Course
implements Constants,
Comparable,
Serializable {
    static final long serialVersionUID = 911L;
    private String field;
    private String courseNumber;
    private String courseName;
    private String sectionPrefix;
    private int sectionNumber;
    private int creditHours;
    private float contactHours = 3.0f;
    private boolean isScheduled = false;

    public Course(String field, String courseNumber, String courseName, String sectionPrefix, int sectionNumber, int creditHours) {
        this.field = field;
        this.courseNumber = courseNumber;
        this.courseName = courseName;
        this.sectionPrefix = sectionPrefix;
        this.sectionNumber = sectionNumber;
        this.creditHours = creditHours;
    }

    public String getField() {
        return this.field;
    }

    public String getCourseNumber() {
        return this.courseNumber;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getSectionPrefix() {
        return this.sectionPrefix;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public String getSectionString() {
        return this.sectionPrefix + "-" + this.sectionNumber;
    }

    public int getCreditHours() {
        return this.creditHours;
    }

    public void setScheduled(boolean isScheduled) {
        this.isScheduled = isScheduled;
    }

    public boolean getIsScheduled() {
        return this.isScheduled;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setCourseNumber(String courseNumber) {
        this.courseNumber = courseNumber;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public void setSectionPrefix(String sectionPrefix) {
        this.sectionPrefix = sectionPrefix;
    }

    public void setSectionNumber(int sectionNumber) {
        this.sectionNumber = sectionNumber;
    }

    public void setCreditHours(int creditHours) {
        this.creditHours = creditHours;
    }

    public String toString() {
        return this.field + this.courseNumber + " " + this.sectionPrefix + this.sectionNumber + "  " + this.courseName;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Course)) {
            return 0;
        }
        Course course2 = (Course)obj;
        if (!this.field.equals(course2.field)) {
            return this.field.compareTo(course2.field);
        }
        if (!this.courseNumber.equals(course2.courseNumber)) {
            return this.courseNumber.compareTo(course2.courseNumber);
        }
        if (!this.courseName.equals(course2.courseName)) {
            return this.courseName.compareTo(course2.courseName);
        }
        if (!this.sectionPrefix.equals(course2.sectionPrefix)) {
            return this.sectionPrefix.compareTo(course2.sectionPrefix);
        }
        if (this.sectionNumber != course2.sectionNumber) {
            return this.sectionNumber - course2.sectionNumber;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Course)) {
            return false;
        }
        Course course2 = (Course)obj;
        return this.courseName.equals(course2.courseName) && this.sectionNumber == course2.sectionNumber && this.field.equals(course2.field) && this.courseNumber.equals(course2.courseNumber) && this.sectionPrefix.equals(course2.sectionPrefix) && this.creditHours == course2.creditHours && this.contactHours == course2.contactHours;
    }
}

