
/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package application;

import java.awt.*;
import java.awt.event.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.event.*;
import panels.*;
/**
 * The JFrame for the entire application
 */

public class ClassroomSchedulerFrame extends JFrame {
    private HandlerMenu handlerMenu;
    private JTabbedPane tabPane;
    
    public ClassroomSchedulerFrame(String title) {
        super(title);
        handlerMenu = new HandlerMenu(this);
        
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        changeTheIcon();
        
        //Image thing = Toolkit.getDefaultToolkit().createImage("./schedulerIcon.gif");
        //if (thing == null)
        //    System.out.println("I got back null!!!");
        //setIconImage(thing);
        setupJFrame();		// initial placement of the JFrame
        
        addMenusToFrame();
        addPanelsToFrame();
        
        setVisible(true);	// Display the JFrame
        requestFocus();		// Request the focus
        

        // prevent JFrame from becomming too small
        addComponentListener(new ComponentAdapter() {
            public void componentResized(ComponentEvent evt) {
                Dimension d = getSize();
                if (d.getWidth() < 700 || d.getHeight() < 540)  // min size for GUI
                    setSize(new Dimension(700, 540));
            }
        } );
    }
    /**
     * This method for changing the icon for the application is from halepringle.com
     *
     */
    private void changeTheIcon(){
        java.net.URL imgPath1;
        String imgPath2, imgPath3,iniPath;
        imgPath1 =  ClassroomSchedulerFrame.class.getProtectionDomain().getCodeSource().getLocation();
        imgPath2 = imgPath1.toString();
        System.out.println("Path to base class: "+imgPath2);
        imgPath2 = imgPath2.substring(5);
        System.out.println("Path after removing 'file:\': "+imgPath2);
        // *** RIGHT HERE imgPath2 contains the path your program is running from.
        //     Note:  If you are running a class that is in a package, the path shown
        //            will be to the base class.  For example: my program GPLCms.class
        //            has many of its classes in a package called com.halepringle.cmsprc.
        //            IF the program is in c:\gplcms\, then the classes in the package will
        //            be in c:\gplcms\com\haleprimgle\cmsprc\.   Classes in the package
        //            will report that they are running in c;|gplcms\.
        
        //     Note 2: You need to strip the "file://" off the beginning of the path.
        //            Make sure you leave one backslash.  Windows is okay with "/c:/gplcms/".
        //            The same line run on a Linux box needs to be "/usr/gplcms/".  If you
        //            strip off the second backslash, it sill be "usr/gplcms/" and that
        //            is an invalid path.
        
        imgPath3 = imgPath2+"images/schedulerIcon.gif";
        
        javax.swing.ImageIcon img ;
        //System.out.println(iniPath);
        if (imgPath2.indexOf(".jar")>0){
            // in this case, the images folder and its images should be in the jar.
            ClassLoader cl = this.getClass().getClassLoader();
            img = new ImageIcon(cl.getResource("images/schedulerIcon.gif"));
        }   else{
            img = new ImageIcon(imgPath3);
        }
        //xxxx This is the name of the frame in your class
        //this replaces the coffee cup on the title bar with your own image.
        setIconImage(img.getImage());
        
    }
    
    /**
     * Positions the initial JFrame whe the application runs
     */    
    private void setupJFrame() {
        Toolkit theKit = getToolkit();	       // Get the window toolkit
        Dimension wndSize = theKit.getScreenSize();    // Get screen size
        
        setSize(new Dimension(760, 575));
        
        setBounds((wndSize.width - 760) / 2, (wndSize.height - 575) / 2,  // Position
        760, 575); 					// Width Height  mimimum for the layouts to work
        
        addWindowListener(new WindowHandler());    // Add window listener
        setVisible(true);				   			// Display the window
    }
    
    /**
     * puts the menus on the JFrame
     */
    
    private void addMenusToFrame() {
        // Construct the pull down menus
        JMenuBar menuBar = new JMenuBar();       // Window menu bar
        
        JMenuItem item;
        JMenu fileMenu = new JMenu("File");    // The File menu bar item
        fileMenu.add(item = new JMenuItem("New"));
        item.addActionListener(handlerMenu);
        fileMenu.add(item = new JMenuItem("Open..."));
        item.addActionListener(handlerMenu);
        fileMenu.add(item = new JMenuItem("Save"));
        item.addActionListener(handlerMenu);
        fileMenu.add(item = new JMenuItem("Save As..."));
        item.addActionListener(handlerMenu);
        fileMenu.add(item = new JMenuItem("Export CSV (spreadsheet)..."));
        item.addActionListener(handlerMenu);
        fileMenu.add(item = new JMenuItem("Exit"));
        item.addActionListener(handlerMenu);
        fileMenu.setMnemonic('F');    // Create shortcut
        

        // Construct the Help pull down menu
        JMenu helpMenu = new JMenu("Help");    // The Help menu bar item
        helpMenu.add(item = new JMenuItem("How to Use"));
        item.addActionListener(handlerMenu);        
        helpMenu.add(item = new JMenuItem("Example Schedule"));
        item.addActionListener(handlerMenu);
        helpMenu.add(item = new JMenuItem("About"));
        item.addActionListener(handlerMenu);
        
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        
        getContentPane().add(menuBar,BorderLayout.NORTH);
    }
    
    /**
     * Puts the JPanels on the JFrame
     */
    
    private void addPanelsToFrame() {
        tabPane = new JTabbedPane();
        JTabbedPane resourceTabPane = new JTabbedPane(SwingConstants.LEFT);
        
        ScheduleConflicts conflictsPanel = new ScheduleConflicts();
        ProfessorsPanel professorsPanel = new ProfessorsPanel();
        RoomsPanel roomsPanel = new RoomsPanel();
        TimeSlotsPanel timeSlotsPanel = new TimeSlotsPanel(this);
        CoursesPanel coursesPanel = new CoursesPanel();
        ScheduleCoursePanel scheduleCoursePanel = new ScheduleCoursePanel(this);
        //BookPanel bookPanel = new BookPanel();
        
        resourceTabPane.addTab("Professors", professorsPanel);
        resourceTabPane.addTab("Classrooms", roomsPanel);
        resourceTabPane.addTab("Time Slots", timeSlotsPanel);
        resourceTabPane.addTab("Courses", coursesPanel);
        //resourceTabPane.addTab("Books", bookPanel);

        resourceTabPane.setToolTipTextAt(0, "Maintain the professors available to schedule"); 
        resourceTabPane.setToolTipTextAt(1, "The list of classrooms to schedule"); 
        resourceTabPane.setToolTipTextAt(2, "The timeslots for scheduling"); 
        resourceTabPane.setToolTipTextAt(3, "The list of courses and sections that can be scheduled"); 
        //resourceTabPane.setToolTipTextAt(4, "The books panel is not very useful right now. It doesn't print, or export."); 
        // new tabs for main frame
        
        ModifySchedule modifySchedule = new ModifySchedule(this);
        ViewCharts viewCharts = new ViewCharts();
        ScheduleSummary summary = new ScheduleSummary();
        
        tabPane.addTab("Modify Schedule", modifySchedule);
        tabPane.addTab("View Charts", viewCharts);
        tabPane.addTab("Conflicts", conflictsPanel);
        tabPane.addTab("Summary", summary);
        tabPane.addTab("Resources to Schedule", resourceTabPane);
        
        tabPane.setToolTipTextAt(0, "Edit the schedule here by adding sections, assigning profs, classrooms, etc.");
        tabPane.setToolTipTextAt(1, "View and print the schedule as a graphical chart You cannot edit the schedule here.");
        tabPane.setToolTipTextAt(2, "These are the conflicts in the schedule.  Fix the conflicts under the Modify Schedule tab.");
        tabPane.setToolTipTextAt(3, "This is a read only summary of the schedule.  It will be more useful as people tell us what should be here.");
        tabPane.setToolTipTextAt(4, "All of the resources, Classrooms, Professors, Timeslots, etc. are maintained here");
        
        // this uses an anon class to handle the change of state.  
        // the objective here is to calculate the summary of the schedule and display
        //  it only when the user asks to see a summary.
        
        //tabPane.addChangeListener( new MyChangeListener(summary));    
        
        getContentPane().add(tabPane,BorderLayout.CENTER);
        
        // panels are observers of the schedule
        Schedule schedule = Schedule.getSchedule();
        schedule.addObserver(professorsPanel); // resources
        schedule.addObserver(roomsPanel);
        schedule.addObserver(coursesPanel);
        schedule.addObserver(timeSlotsPanel);
        //schedule.addObserver(bookPanel);   
        
        schedule.addObserver(modifySchedule);
        schedule.addObserver(viewCharts);
        schedule.addObserver(conflictsPanel);     
        
        // should the summary panel be an observer?
        // should it have a calculate summary
        // should we hear the user ask to look at the summary and calc on the fly?  YES.
        //schedule.addObserver(summary); 
        
        //schedule.addObserver(viewSchedulePanel);
        
        schedule.addObserver(schedule); // watches itself for saving changes on
        //  exit
    }
    
    /**
     * Inner Class declaration
     *
     * Handle the window events
     */
    
    class WindowHandler extends WindowAdapter {
        
        /**
         * @param e  the event to close the JFrame, i.e., end the running of
         * the application
         */
        
        public void windowClosing(WindowEvent e) {
            if (e.getID() == WindowEvent.WINDOW_CLOSING) {
                if (handlerMenu.checkForSave()) {  // user can change mind
                    dispose();    // Release the window resources
                    System.exit(0);      // End the application
                }
            }
        }
    } // end inner class
    
    // this is an example of hearing the event that the user has switched from 
    // one tab pane to another, but it is not in use as of now.
    class MyChangeListener implements ChangeListener{
        ScheduleSummary summary;
        MyChangeListener (ScheduleSummary summary){
            this.summary = summary;
        }
        
        public void stateChanged(ChangeEvent ce){
            System.out.println("I hear the tabPane event:"
                + ce.getSource());
            if (tabPane.getSelectedComponent() == summary){
                    System.out.println("The user wants a summary");
                    
            }
                    
        }
    }
}




