/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import application.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;
import javax.swing.*;

/**
 *
 * @author  Colin
 */
public class ScheduleSummary extends javax.swing.JPanel {
    
    //int testVar = 0;
    
    /** Creates new form ScheduleSummary */
    public ScheduleSummary() {
        initComponents(); 
        printButton.addActionListener(new PrintListener());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        summaryArea = new javax.swing.JTextArea();
        jPanel2 = new javax.swing.JPanel();
        printButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        summaryArea.setFont(new java.awt.Font("Courier New", 0, 12));
        jScrollPane1.setViewportView(summaryArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(18, 12, 6, 12);
        add(jPanel1, gridBagConstraints);

        printButton.setText("Print Summary");
        jPanel2.add(printButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 12, 12);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton printButton;
    private javax.swing.JTextArea summaryArea;
    // End of variables declaration//GEN-END:variables
    
    public void paint(Graphics g){
        Schedule schedule = Schedule.getSchedule();
        summaryArea.setText(schedule.getSummary().calcSummary());
        super.paint(g);
    }
    
    /*public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return 0;  // see note below
    }*/
    // Making the summary of the schedule and having it printable is not completed.
    //  I am going to punt on this part for right now to get the system passed to 
    // Kyle
    private class PrintListener implements ActionListener{
        public void actionPerformed(ActionEvent ae){
            System.out.println("I hear the print button");
            // Need to add call to Summary.print or some such.
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(Schedule.getSchedule().getSummary());
            
            if(printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch(PrinterException pe) {
                    System.out.println(pe);
                    JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(),
                    "Error printing a summary.",
                    "Unknown Printer Error",
                    JOptionPane.ERROR_MESSAGE);                
                }
            }
        }
    }        
}
