/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;
    protected String id;
    private final Map<String, String> noTileHeaders;
    private final Map<String, String> metadataHeaders;
    protected int tileSize;
    protected OsmMercator osmMercator;

    public AbstractTMSTileSource(TileSourceInfo info) {
        this.name = info.getName();
        this.baseUrl = info.getUrl();
        if (this.baseUrl != null && this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.id = info.getUrl();
        this.noTileHeaders = info.getNoTileHeaders();
        this.metadataHeaders = info.getMetadataHeaders();
        this.tileSize = info.getTileSize();
        this.osmMercator = new OsmMercator(this.tileSize);
    }

    @Override
    public int getDefaultTileSize() {
        return 256;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxZoom() {
        return 21;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
        return "/" + zoom + "/" + tilex + "/" + tiley + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
        return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int getTileSize() {
        if (this.tileSize <= 0) {
            return this.getDefaultTileSize();
        }
        return this.tileSize;
    }

    @Override
    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        return this.osmMercator.getDistance(lat1, lon1, lat2, lon2);
    }

    @Override
    public Point latLonToXY(double lat, double lon, int zoom) {
        return new Point((int)this.osmMercator.lonToX(lon, zoom), (int)this.osmMercator.latToY(lat, zoom));
    }

    @Override
    public Point latLonToXY(ICoordinate point, int zoom) {
        return this.latLonToXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public ICoordinate xyToLatLon(Point point, int zoom) {
        return this.xyToLatLon(point.x, point.y, zoom);
    }

    @Override
    public ICoordinate xyToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator.yToLat(y, zoom), this.osmMercator.xToLon(x, zoom));
    }

    @Override
    public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        return new TileXY(this.osmMercator.lonToX(lon, zoom) / (double)this.tileSize, this.osmMercator.latToY(lat, zoom) / (double)this.tileSize);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate point, int zoom) {
        return this.latLonToTileXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY xy, int zoom) {
        return this.tileXYToLatLon(xy.getXIndex(), xy.getYIndex(), zoom);
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        return new Coordinate(this.osmMercator.yToLat(y * this.tileSize, zoom), this.osmMercator.xToLon(x * this.tileSize, zoom));
    }

    @Override
    public int getTileXMax(int zoom) {
        return AbstractTMSTileSource.getTileMax(zoom);
    }

    @Override
    public int getTileXMin(int zoom) {
        return 0;
    }

    @Override
    public int getTileYMax(int zoom) {
        return AbstractTMSTileSource.getTileMax(zoom);
    }

    @Override
    public int getTileYMin(int zoom) {
        return 0;
    }

    @Override
    public boolean isNoTileAtZoom(Map<String, List<String>> headers, int statusCode, byte[] content) {
        if (this.noTileHeaders != null && headers != null) {
            for (Map.Entry<String, String> searchEntry : this.noTileHeaders.entrySet()) {
                List<String> headerVals = headers.get(searchEntry.getKey());
                if (headerVals == null) continue;
                for (String headerValue : headerVals) {
                    if (!headerValue.matches(searchEntry.getValue())) continue;
                    return true;
                }
            }
        }
        return super.isNoTileAtZoom(headers, statusCode, content);
    }

    @Override
    public Map<String, String> getMetadata(Map<String, List<String>> headers) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.metadataHeaders != null && headers != null) {
            for (Map.Entry<String, String> searchEntry : this.metadataHeaders.entrySet()) {
                List<String> headerVals = headers.get(searchEntry.getKey());
                if (headerVals == null) continue;
                for (String headerValue : headerVals) {
                    ret.put(searchEntry.getValue(), headerValue);
                }
            }
        }
        return ret;
    }

    @Override
    public String getTileId(int zoom, int tilex, int tiley) {
        return this.baseUrl + "/" + zoom + "/" + tilex + "/" + tiley;
    }

    private static int getTileMax(int zoom) {
        return (int)Math.pow(2.0, zoom) - 1;
    }
}

