/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.macos;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.awt.EventQueue;
import java.io.File;
import java.net.URI;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.ViewController;

public class MacChanges
implements AboutHandler,
OpenFilesHandler,
PreferencesHandler,
OpenURIHandler,
QuitHandler {
    private static Application fmMacApplication;
    private final Controller controller;
    private int loadedMapCounter = 0;

    public static void apply(Controller controller) {
        new MacChanges(controller);
    }

    private MacChanges(Controller controller) {
        this.controller = controller;
        if (fmMacApplication == null) {
            fmMacApplication = Application.getApplication();
            fmMacApplication.setAboutHandler((AboutHandler)this);
            fmMacApplication.setPreferencesHandler((PreferencesHandler)this);
            fmMacApplication.setOpenFileHandler((OpenFilesHandler)this);
            fmMacApplication.setOpenURIHandler((OpenURIHandler)this);
            fmMacApplication.setQuitHandler((QuitHandler)this);
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private MModeController getModeController() {
        return (MModeController)this.controller.getModeController("MindMap");
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent event, QuitResponse response) {
        try {
            this.controller.quit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.cancelQuit();
    }

    public void openURI(AppEvent.OpenURIEvent event) {
        URI uri = event.getURI();
        try {
            ViewController viewController = this.controller.getViewController();
            if (viewController == null) {
                ++this.loadedMapCounter;
                System.setProperty("org.freeplane.param" + this.loadedMapCounter, uri.toString());
            } else {
                LinkController.getController().loadURI(uri);
            }
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
        }
    }

    public void handlePreferences(AppEvent.PreferencesEvent event) {
        this.getModeController().getAction("PropertyAction").actionPerformed(null);
    }

    public void openFiles(AppEvent.OpenFilesEvent event) {
        for (File file : event.getFiles()) {
            String filePath = file.getPath();
            this.openFile(filePath);
        }
    }

    private void openFile(String filePath) {
        try {
            ViewController viewController = this.controller.getViewController();
            if (viewController == null) {
                ++this.loadedMapCounter;
                System.setProperty("org.freeplane.param" + this.loadedMapCounter, filePath);
            } else {
                this.getModeController().getMapController().newMap(Compat.fileToUrl((File)new File(filePath)));
            }
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
        }
    }

    public void handleAbout(AppEvent.AboutEvent event) {
        this.getModeController().getController().getAction("AboutAction").actionPerformed(null);
    }
}

