/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.attribute.IAttributesListener;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class AssignAttributeDialog
extends JDialog
implements IAttributesListener,
IMapSelectionListener {
    private static final Dimension maxButtonDimension = new Dimension(1000, 1000);
    private static final long serialVersionUID = 1L;
    private final AttributeController attributeController;
    private final JComboBox attributeNames;
    private final JComboBox attributeValues;
    private IMapSelection mapSelection;
    private final JComboBox replacingAttributeNames;
    private final JComboBox replacingAttributeValues;
    private final JRadioButton selectedBtn;
    private final JCheckBox skipRootBtn;
    private final JRadioButton visibleBtn;

    public AssignAttributeDialog(AttributeController attributeController, Frame frame) {
        super(frame, TextUtils.getText((String)"attributes_assign_dialog"), false);
        this.attributeController = attributeController;
        this.mapSelection = Controller.getCurrentController().getSelection();
        CompoundBorder actionBorder = new CompoundBorder(new EmptyBorder(5, 10, 0, 10), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        EmptyBorder btnBorder = new EmptyBorder(2, 2, 2, 2);
        this.selectedBtn = new JRadioButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)this.selectedBtn, (String)TextUtils.getRawText((String)"attributes_for_selected"));
        this.selectedBtn.setSelected(true);
        this.visibleBtn = new JRadioButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)this.visibleBtn, (String)TextUtils.getRawText((String)"attributes_for_visible"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.selectedBtn);
        group.add(this.visibleBtn);
        this.skipRootBtn = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)this.skipRootBtn, (String)TextUtils.getRawText((String)"attributes_skip_root"));
        this.skipRootBtn.setSelected(true);
        Box selectionBox = Box.createHorizontalBox();
        selectionBox.setBorder(emptyBorder);
        selectionBox.add(Box.createHorizontalGlue());
        selectionBox.add(this.selectedBtn);
        selectionBox.add(Box.createHorizontalGlue());
        selectionBox.add(this.visibleBtn);
        selectionBox.add(Box.createHorizontalGlue());
        selectionBox.add(this.skipRootBtn);
        selectionBox.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)selectionBox, "North");
        JButton addBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)addBtn, (String)TextUtils.getRawText((String)"filter_add"));
        addBtn.addActionListener(new AddAction());
        addBtn.setMaximumSize(maxButtonDimension);
        JButton deleteAttributeBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)deleteAttributeBtn, (String)TextUtils.getRawText((String)"attribute_delete"));
        deleteAttributeBtn.addActionListener(new DeleteAttributeAction());
        deleteAttributeBtn.setMaximumSize(maxButtonDimension);
        JButton deleteAttributeValueBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)deleteAttributeValueBtn, (String)TextUtils.getRawText((String)"attribute_delete_value"));
        deleteAttributeValueBtn.addActionListener(new DeleteValueAction());
        deleteAttributeValueBtn.setMaximumSize(maxButtonDimension);
        JButton replaceBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)replaceBtn, (String)TextUtils.getRawText((String)"attribute_replace"));
        replaceBtn.addActionListener(new ReplaceValueAction());
        replaceBtn.setMaximumSize(maxButtonDimension);
        UITools.addEscapeActionToDialog((JDialog)this);
        String pattern = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        JLabel patternLabel = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Dimension comboBoxMaximumSize = patternLabel.getPreferredSize();
        comboBoxMaximumSize.width += 4;
        comboBoxMaximumSize.height += 10;
        this.attributeNames = new JComboBoxWithBorder();
        this.attributeNames.setMaximumSize(comboBoxMaximumSize);
        this.attributeNames.setPreferredSize(comboBoxMaximumSize);
        this.attributeNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AssignAttributeDialog.this.selectedAttributeChanged(e.getItem(), AssignAttributeDialog.this.attributeValues);
            }
        });
        this.attributeValues = new JComboBoxWithBorder();
        this.attributeValues.setRenderer(new TypedListCellRenderer());
        this.attributeValues.setMaximumSize(comboBoxMaximumSize);
        this.attributeValues.setPreferredSize(comboBoxMaximumSize);
        this.replacingAttributeNames = new JComboBoxWithBorder();
        this.replacingAttributeNames.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeNames.setPreferredSize(comboBoxMaximumSize);
        this.replacingAttributeNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AssignAttributeDialog.this.selectedAttributeChanged(e.getItem(), AssignAttributeDialog.this.replacingAttributeValues);
            }
        });
        this.replacingAttributeValues = new JComboBoxWithBorder();
        this.replacingAttributeValues.setRenderer(new TypedListCellRenderer());
        this.replacingAttributeValues.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeValues.setPreferredSize(comboBoxMaximumSize);
        Box addDeleteBtnBox = Box.createVerticalBox();
        addDeleteBtnBox.setBorder(btnBorder);
        addDeleteBtnBox.add(Box.createVerticalGlue());
        addDeleteBtnBox.add(addBtn);
        addDeleteBtnBox.add(deleteAttributeBtn);
        addDeleteBtnBox.add(deleteAttributeValueBtn);
        addDeleteBtnBox.add(Box.createVerticalGlue());
        Box addDeleteBox = Box.createHorizontalBox();
        addDeleteBox.setBorder(actionBorder);
        addDeleteBox.add(Box.createHorizontalGlue());
        addDeleteBox.add(addDeleteBtnBox);
        addDeleteBox.add(Box.createHorizontalStrut(5));
        addDeleteBox.add(this.attributeNames);
        addDeleteBox.add(Box.createHorizontalStrut(5));
        addDeleteBox.add(this.attributeValues);
        addDeleteBox.add(Box.createHorizontalStrut(5));
        Box outerReplaceBox = Box.createVerticalBox();
        outerReplaceBox.setBorder(actionBorder);
        Box replaceBox = Box.createHorizontalBox();
        replaceBox.setBorder(btnBorder);
        replaceBox.add(Box.createHorizontalGlue());
        replaceBox.add(replaceBtn);
        replaceBox.add(Box.createHorizontalStrut(5));
        replaceBox.add(this.replacingAttributeNames);
        replaceBox.add(Box.createHorizontalStrut(5));
        replaceBox.add(this.replacingAttributeValues);
        replaceBox.add(Box.createHorizontalStrut(5));
        outerReplaceBox.add(Box.createVerticalGlue());
        outerReplaceBox.add(replaceBox);
        outerReplaceBox.add(Box.createVerticalGlue());
        Box actionBox = Box.createVerticalBox();
        actionBox.add(Box.createVerticalGlue());
        actionBox.add(addDeleteBox);
        actionBox.add(Box.createVerticalStrut(5));
        actionBox.add(outerReplaceBox);
        actionBox.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)actionBox, "Center");
        JButton closeBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)closeBtn, (String)TextUtils.getRawText((String)"simplyhtml.closeBtnName"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignAttributeDialog.this.dispose();
            }
        });
        Box bottomBox = Box.createHorizontalBox();
        bottomBox.setBorder(emptyBorder);
        bottomBox.add(Box.createHorizontalGlue());
        bottomBox.add(closeBtn);
        bottomBox.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)bottomBox, "South");
        this.pack();
        comboBoxMaximumSize.width = 1000;
        this.attributeNames.setMaximumSize(comboBoxMaximumSize);
        this.attributeValues.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeNames.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeValues.setMaximumSize(comboBoxMaximumSize);
        this.afterMapChange(null, Controller.getCurrentController().getMap());
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this);
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        AttributeRegistry attributes;
        if (oldMap != null && (attributes = AttributeRegistry.getRegistry((MapModel)oldMap)) != null) {
            attributes.removeAttributesListener((IAttributesListener)this);
        }
        if (newMap == null) {
            this.setVisible(false);
            return;
        }
        this.mapSelection = Controller.getCurrentController().getSelection();
        attributes = AttributeRegistry.getRegistry((MapModel)newMap);
        if (attributes == null) {
            this.setVisible(false);
            return;
        }
        attributes.addAttributesListener((IAttributesListener)this);
        this.attributesChanged();
    }

    private void attributesChanged() {
        MapModel map = Controller.getCurrentController().getMap();
        AttributeRegistry attributes = AttributeRegistry.getRegistry((MapModel)map);
        ComboBoxModel names = attributes.getComboBoxModel();
        this.attributeNames.setModel(new ClonedComboBoxModel(names));
        this.attributeNames.setEditable(!attributes.isRestricted());
        this.replacingAttributeNames.setModel(new ClonedComboBoxModel(names));
        this.replacingAttributeNames.setEditable(!attributes.isRestricted());
        if (attributes.size() > 0) {
            Object first = names.getElementAt(0);
            this.attributeNames.setSelectedItem(first);
            this.replacingAttributeNames.setSelectedItem(first);
            this.selectedAttributeChanged(this.attributeNames.getSelectedItem(), this.attributeValues);
            this.selectedAttributeChanged(this.replacingAttributeNames.getSelectedItem(), this.replacingAttributeValues);
        } else {
            this.attributeValues.setModel(new DefaultComboBoxModel());
            this.attributeValues.setEditable(false);
            this.replacingAttributeValues.setModel(new DefaultComboBoxModel());
            this.replacingAttributeValues.setEditable(false);
        }
    }

    public void attributesChanged(ChangeEvent e) {
        this.attributesChanged();
    }

    public void beforeMapChange(MapModel oldMap, MapModel newMap) {
    }

    private void selectedAttributeChanged(Object selectedAttributeName, JComboBox values) {
        MapModel map = Controller.getCurrentController().getMap();
        AttributeRegistry attributes = AttributeRegistry.getRegistry((MapModel)map);
        try {
            AttributeRegistryElement element = attributes.getElement((Comparable)((Object)selectedAttributeName.toString()));
            SortedComboBoxModel selectedValues = element.getValues();
            values.setModel(new ClonedComboBoxModel((ComboBoxModel)selectedValues));
            try {
                Object firstValue = selectedValues.getElementAt(0);
                values.setSelectedItem(firstValue);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            values.setEditable(!element.isRestricted());
        }
        catch (NoSuchElementException ex) {
            values.setEditable(!selectedAttributeName.toString().equals(""));
        }
    }

    private class ReplaceValueAction
    extends IteratingAction {
        private String name;
        private String replacingName;
        private String replacingValue;
        private String value;

        private ReplaceValueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AssignAttributeDialog.this.attributeNames.getSelectedItem() == null) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            if (AssignAttributeDialog.this.replacingAttributeNames.getSelectedItem() == null) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            this.name = AssignAttributeDialog.this.attributeNames.getSelectedItem().toString();
            if (this.name.equals("")) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            this.replacingName = AssignAttributeDialog.this.replacingAttributeNames.getSelectedItem().toString();
            if (this.replacingName.equals("")) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = AssignAttributeDialog.this.attributeValues.getSelectedItem();
            this.value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            Object replacingValueSelectedItem = AssignAttributeDialog.this.replacingAttributeValues.getSelectedItem();
            this.replacingValue = replacingValueSelectedItem != null ? replacingValueSelectedItem.toString() : "";
            super.actionPerformed(e);
        }

        @Override
        protected void performAction(NodeModel model) {
            NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)model);
            for (int i = attributes.getRowCount() - 1; i >= 0; --i) {
                Attribute attribute = attributes.getAttribute(i);
                if (!attribute.getName().equals(this.name) || !attribute.getValue().equals(this.value)) continue;
                AssignAttributeDialog.this.attributeController.performRemoveRow(attributes, i);
                AssignAttributeDialog.this.attributeController.performInsertRow(attributes, i, this.replacingName, (Object)this.replacingValue);
            }
        }
    }

    private abstract class IteratingAction
    implements ActionListener {
        private IteratingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (AssignAttributeDialog.this.selectedBtn.getModel().isSelected()) {
                    Set selecteds = AssignAttributeDialog.this.mapSelection.getSelection();
                    for (NodeModel selectedNodeView : selecteds) {
                        this.performAction(selectedNodeView);
                    }
                    return;
                }
                NodeModel nodeView = Controller.getCurrentController().getMap().getRootNode();
                this.iterate(nodeView);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private void iterate(NodeModel node) {
            if (!(!node.hasVisibleContent() || node.isRoot() && AssignAttributeDialog.this.skipRootBtn.isSelected())) {
                this.performAction(node);
            }
            if (node.isFolded()) {
                return;
            }
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                this.iterate((NodeModel)iterator.next());
            }
        }

        protected abstract void performAction(NodeModel var1);
    }

    private class DeleteValueAction
    extends IteratingAction {
        private String name;
        private String value;

        private DeleteValueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AssignAttributeDialog.this.attributeNames.getSelectedItem() == null) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            this.name = AssignAttributeDialog.this.attributeNames.getSelectedItem().toString();
            if (this.name.equals("")) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = AssignAttributeDialog.this.attributeValues.getSelectedItem();
            this.value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            super.actionPerformed(e);
        }

        @Override
        protected void performAction(NodeModel model) {
            NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)model);
            for (int i = attributes.getRowCount() - 1; i >= 0; --i) {
                Attribute attribute = attributes.getAttribute(i);
                if (!attribute.getName().equals(this.name) || !attribute.getValue().equals(this.value)) continue;
                AssignAttributeDialog.this.attributeController.performRemoveRow(attributes, i);
            }
        }
    }

    private class DeleteAttributeAction
    extends IteratingAction {
        private String name;

        private DeleteAttributeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedItem = AssignAttributeDialog.this.attributeNames.getSelectedItem();
            if (selectedItem == null) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            this.name = selectedItem.toString();
            if (this.name.equals("")) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            super.actionPerformed(e);
        }

        @Override
        protected void performAction(NodeModel model) {
            NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)model);
            for (int i = attributes.getRowCount() - 1; i >= 0; --i) {
                if (!attributes.getAttribute(i).getName().equals(this.name)) continue;
                AssignAttributeDialog.this.attributeController.performRemoveRow(attributes, i);
            }
        }
    }

    protected static class ClonedComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private Object selectedItem;
        private final AbstractListModel sharedListModel;

        public ClonedComboBoxModel(ComboBoxModel sharedListModel) {
            this.sharedListModel = (AbstractListModel)((Object)sharedListModel);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            super.addListDataListener(l);
            this.sharedListModel.addListDataListener(l);
        }

        @Override
        public Object getElementAt(int index) {
            return this.sharedListModel.getElementAt(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.sharedListModel.getSize();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            super.removeListDataListener(l);
            this.sharedListModel.removeListDataListener(l);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class AddAction
    extends IteratingAction {
        private String name;
        private String value;

        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AssignAttributeDialog.this.attributeNames.getSelectedItem() == null) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            this.name = AssignAttributeDialog.this.attributeNames.getSelectedItem().toString();
            if (this.name.equals("")) {
                UITools.showAttributeEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = AssignAttributeDialog.this.attributeValues.getSelectedItem();
            this.value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            super.actionPerformed(e);
            if (valueSelectedItem == null) {
                AssignAttributeDialog.this.selectedAttributeChanged(this.name, AssignAttributeDialog.this.attributeValues);
            }
        }

        @Override
        protected void performAction(NodeModel model) {
            AssignAttributeDialog.this.attributeController.createAttributeTableModel(model);
            NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)model);
            AssignAttributeDialog.this.attributeController.performInsertRow(attributes, attributes.getRowCount(), this.name, (Object)this.value);
        }
    }
}

