/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

@EnabledAction(checkOnNodeChange=true)
public class MakeLinkFromAnchorAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public MakeLinkFromAnchorAction() {
        super("MakeLinkFromAnchorAction");
    }

    public void actionPerformed(ActionEvent e) {
        ModeController modeControllerForSelectedMap = Controller.getCurrentModeController();
        NodeModel targetNode = modeControllerForSelectedMap.getMapController().getSelectedNode();
        File targetMapFile = targetNode.getMap().getFile();
        if (targetMapFile == null) {
            UITools.errorMessage((Object)TextUtils.getRawText((String)"map_not_saved"));
            return;
        }
        String targetMapFileNameURI = targetMapFile.toURI().toString();
        String targetMapFileName = targetMapFileNameURI.substring(targetMapFileNameURI.indexOf("/") + 1);
        String targetID = targetMapFile.toURI().toString() + '#' + targetNode.createID();
        String sourceID = ((MLinkController)LinkController.getController()).getAnchorID();
        if (sourceID == null) {
            return;
        }
        String sourceMapFileName = sourceID.substring(sourceID.indexOf("/") + 1, sourceID.indexOf("#"));
        if (targetMapFileName.equals(sourceMapFileName)) {
            MLinkController linkController = (MLinkController)MLinkController.getController();
            String sourceNodeID = sourceID.substring(sourceID.indexOf("#") + 1);
            NodeModel sourceNode = modeControllerForSelectedMap.getMapController().getNodeFromID(sourceNodeID);
            linkController.setLink(sourceNode, targetID.substring(targetID.indexOf("#")), 0);
        } else {
            MLinkController linkController_selected = (MLinkController)MLinkController.getController();
            try {
                URI linkToAnchorNode = LinkController.createURI((String)sourceID.trim());
                linkController_selected.loadURI(linkToAnchorNode);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn((Throwable)e1);
                return;
            }
            NodeModel sourceNode = modeControllerForSelectedMap.getMapController().getSelectedNode();
            MLinkController linkController_anchored = (MLinkController)MLinkController.getController();
            try {
                URI linkToCurrentNode = LinkController.createURI((String)targetID.trim());
                linkController_anchored.setLink(sourceNode, linkToCurrentNode, 0);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn((Throwable)e1);
                return;
            }
            try {
                URI linkBackToSelectedNode = LinkController.createURI((String)targetID.trim());
                linkController_anchored.loadURI(linkBackToSelectedNode);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn((Throwable)e1);
                return;
            }
        }
    }

    public void setEnabled() {
        boolean isAnchored = ((MLinkController)LinkController.getController()).isAnchored();
        this.setEnabled(isAnchored);
    }
}

