/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.SetBooleanMapPropertyAction;
import org.freeplane.features.styles.mindmapmode.AssignStyleAction;
import org.freeplane.features.styles.mindmapmode.CopyMapStylesAction;
import org.freeplane.features.styles.mindmapmode.CopyStyleExtensionsAction;
import org.freeplane.features.styles.mindmapmode.FilterComposerDialog;
import org.freeplane.features.styles.mindmapmode.ManageMapConditionalStylesAction;
import org.freeplane.features.styles.mindmapmode.ManageNodeConditionalStylesAction;
import org.freeplane.features.styles.mindmapmode.MapBackgroundColorAction;
import org.freeplane.features.styles.mindmapmode.NewUserStyleAction;
import org.freeplane.features.styles.mindmapmode.RedefineStyleAction;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.features.filepreview.MapBackgroundClearAction;
import org.freeplane.view.swing.features.filepreview.MapBackgroundImageAction;

public class MLogicalStyleController
extends LogicalStyleController {
    private static final String STYLE_ACTIONS = "styleActions";
    private final List<AssignStyleAction> actions = new LinkedList<AssignStyleAction>();
    private FilterComposerDialog filterComposerDialog;

    public MLogicalStyleController(ModeController modeController) {
        super(modeController);
    }

    public void initS() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new ManageNodeConditionalStylesAction());
    }

    public void initM() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.getMapController().addNodeChangeListener((INodeChangeListener)new StyleRemover());
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier());
        modeController.addAction((AFreeplaneAction)new RedefineStyleAction());
        modeController.addAction((AFreeplaneAction)new NewUserStyleAction());
        modeController.addAction((AFreeplaneAction)new ManageMapConditionalStylesAction());
        modeController.addAction((AFreeplaneAction)new ManageNodeConditionalStylesAction());
        modeController.addAction((AFreeplaneAction)new CopyStyleExtensionsAction());
        if (modeController.getModeName().equals("MindMap")) {
            modeController.addAction((AFreeplaneAction)new MapBackgroundColorAction());
            modeController.addAction((AFreeplaneAction)new MapBackgroundImageAction());
            modeController.addAction((AFreeplaneAction)new MapBackgroundClearAction());
            modeController.addAction((AFreeplaneAction)new SetBooleanMapPropertyAction("fit_to_viewport"));
            modeController.addAction((AFreeplaneAction)new CopyMapStylesAction());
        }
        if (!modeController.getController().getViewController().isHeadless()) {
            modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "style_actions", (EntryVisitor)new StyleMenuBuilder(modeController), (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)modeController));
            final IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            Controller.getCurrentController().getMapViewManager().addMapSelectionListener(new IMapSelectionListener(){

                public void beforeMapChange(MapModel oldMap, MapModel newMap) {
                }

                public void afterMapChange(MapModel oldMap, MapModel newMap) {
                    userInputListenerFactory.rebuildMenus(MLogicalStyleController.STYLE_ACTIONS);
                }
            });
            MapController mapController = modeController.getMapController();
            mapController.addMapChangeListener(new IMapChangeListener(){

                public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
                }

                public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
                }

                public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
                }

                public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
                }

                public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
                }

                public void mapChanged(MapChangeEvent event) {
                    if (event.getProperty().equals("MAP_STYLES")) {
                        userInputListenerFactory.rebuildMenus(MLogicalStyleController.STYLE_ACTIONS);
                    }
                }
            });
            mapController.addNodeSelectionListener(new INodeSelectionListener(){

                public void onSelect(NodeModel node) {
                    MLogicalStyleController.this.selectActions();
                }

                public void onDeselect(NodeModel node) {
                }
            });
        }
    }

    public void setStyle(final NodeModel node, final IStyle style) {
        final ModeController modeController = Controller.getCurrentModeController();
        final IStyle oldStyle = LogicalStyleModel.getStyle((NodeModel)node);
        if (oldStyle != null && oldStyle.equals(style) || oldStyle == style) {
            modeController.getMapController().nodeChanged(node, LogicalStyleModel.class, (Object)oldStyle, (Object)style);
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setStyle";
            }

            public void act() {
                this.changeStyle(modeController, node, oldStyle, style);
            }

            public void undo() {
                this.changeStyle(modeController, node, style, oldStyle);
            }

            private void changeStyle(ModeController modeController2, NodeModel node2, IStyle oldStyle2, IStyle style2) {
                if (style2 != null) {
                    LogicalStyleModel model = LogicalStyleModel.createExtension((NodeModel)node2);
                    model.setStyle(style2);
                } else {
                    node2.removeExtension(LogicalStyleModel.class);
                }
                modeController2.getMapController().nodeChanged(node2, LogicalStyleModel.class, (Object)oldStyle2, (Object)style2);
                MLogicalStyleController.this.selectActions();
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void copyStyleExtensions(IStyle style, NodeModel target) {
        MTextController textController = MTextController.getController();
        MapStyleModel extension = MapStyleModel.getExtension((MapModel)target.getMap());
        NodeModel styleNode = extension.getStyleNode(style);
        if (styleNode != null) {
            String noteText;
            MAttributeController attributeController = MAttributeController.getController();
            attributeController.copyAttributesToNode(styleNode, target);
            String detailTextText = DetailTextModel.getDetailTextText((NodeModel)styleNode);
            if (detailTextText != null) {
                textController.setDetails(target, detailTextText);
            }
            if ((noteText = NoteModel.getNoteText((NodeModel)styleNode)) != null) {
                MNoteController noteController = (MNoteController)NoteController.getController();
                noteController.setNoteText(target, noteText);
            }
        }
    }

    void selectActions() {
        for (AssignStyleAction action : this.actions) {
            action.setSelected();
        }
    }

    public void setStyle(IStyle style) {
        ModeController modeController = Controller.getCurrentModeController();
        Collection selectedNodes = modeController.getMapController().getSelectedNodes();
        for (NodeModel selected : selectedNodes) {
            this.setStyle(selected, style);
        }
    }

    public void moveConditionalStyleDown(MapModel map, final ConditionalStyleModel conditionalStyleModel, final int index) {
        int maxIndex = conditionalStyleModel.getStyleCount() - 1;
        if (index < 0 || index >= maxIndex) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveConditionalStyleDown";
            }

            public void act() {
                MLogicalStyleController.super.moveConditionalStyleDown(conditionalStyleModel, index);
            }

            public void undo() {
                MLogicalStyleController.super.moveConditionalStyleUp(conditionalStyleModel, index + 1);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public void moveConditionalStyleUp(MapModel map, final ConditionalStyleModel conditionalStyleModel, final int index) {
        int maxIndex = conditionalStyleModel.getStyleCount() - 1;
        if (index <= 0 || index > maxIndex) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveConditionalStyleUp";
            }

            public void act() {
                MLogicalStyleController.super.moveConditionalStyleUp(conditionalStyleModel, index);
            }

            public void undo() {
                MLogicalStyleController.super.moveConditionalStyleDown(conditionalStyleModel, index - 1);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public static MLogicalStyleController getController() {
        return (MLogicalStyleController)LogicalStyleController.getController();
    }

    public void addConditionalStyle(MapModel map, ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        AddConditionalStyleActor actor = new AddConditionalStyleActor(conditionalStyleModel, isActive, condition, style, isLast);
        Controller.getCurrentModeController().execute((IActor)actor, map);
    }

    public ConditionalStyleModel.Item removeConditionalStyle(MapModel map, ConditionalStyleModel conditionalStyleModel, int index) {
        RemoveConditionalStyleActor actor = new RemoveConditionalStyleActor(conditionalStyleModel, index);
        Controller.getCurrentModeController().execute((IActor)actor, map);
        return actor.item;
    }

    public TableModel getConditionalStyleModelAsTableModel(final MapModel map, final ConditionalStyleModel conditionalStyleModel) {
        return new TableModel(){
            private final TableModel tableModel;
            {
                this.tableModel = conditionalStyleModel.asTableModel();
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
                this.tableModel.addTableModelListener(l);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.tableModel.getColumnClass(columnIndex);
            }

            @Override
            public int getColumnCount() {
                return this.tableModel.getColumnCount();
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.tableModel.getColumnName(columnIndex);
            }

            @Override
            public int getRowCount() {
                return this.tableModel.getRowCount();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return this.tableModel.getValueAt(rowIndex, columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.tableModel.isCellEditable(rowIndex, columnIndex);
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
                this.tableModel.removeTableModelListener(l);
            }

            @Override
            public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
                final Object oldValue = this.tableModel.getValueAt(rowIndex, columnIndex);
                if (aValue == oldValue || aValue != null && aValue.equals(oldValue)) {
                    return;
                }
                IActor actor = new IActor(){

                    public String getDescription() {
                        return "set conditional style table cell value";
                    }

                    public void act() {
                        tableModel.setValueAt(aValue, rowIndex, columnIndex);
                    }

                    public void undo() {
                        tableModel.setValueAt(oldValue, rowIndex, columnIndex);
                    }
                };
                Controller.getCurrentModeController().execute(actor, map);
            }
        };
    }

    public FilterComposerDialog getFilterComposerDialog() {
        if (this.filterComposerDialog == null) {
            this.filterComposerDialog = new FilterComposerDialog();
            Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.filterComposerDialog);
        }
        return this.filterComposerDialog;
    }

    public ASelectableCondition editCondition(ASelectableCondition value) {
        FilterComposerDialog filterComposerDialog = this.getFilterComposerDialog();
        filterComposerDialog.acceptMultipleConditions(true);
        if (value != null) {
            filterComposerDialog.addCondition(value);
        }
        filterComposerDialog.show();
        List<ASelectableCondition> conditions = filterComposerDialog.getConditions();
        if (filterComposerDialog.isSuccess()) {
            return conditions.isEmpty() ? null : conditions.get(0);
        }
        return value;
    }

    class StyleMenuBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        public StyleMenuBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        public void visit(Entry target) {
            this.addStyleMenu(target);
        }

        public boolean shouldSkipChildren(Entry entry) {
            return true;
        }

        private void addStyleMenu(Entry target) {
            MapModel map = Controller.getCurrentController().getMap();
            if (map == null) {
                return;
            }
            MapStyleModel extension = MapStyleModel.getExtension((MapModel)map);
            if (extension == null) {
                return;
            }
            MLogicalStyleController.this.actions.clear();
            NodeModel rootNode = extension.getStyleMap().getRootNode();
            AssignStyleAction resetAction = new AssignStyleAction(null);
            this.modeController.addActionIfNotAlreadySet((AFreeplaneAction)resetAction);
            MLogicalStyleController.this.actions.add(resetAction);
            new EntryAccessor().addChildAction(target, (AFreeplaneAction)resetAction);
            this.addStyleMenu(target, rootNode, extension);
        }

        private void addStyleMenu(Entry target, NodeModel styleMapNode, MapStyleModel extension) {
            List children = styleMapNode.getChildren();
            EntryAccessor entryAccessor = new EntryAccessor();
            for (NodeModel child : children) {
                if (child.hasChildren()) {
                    this.addStyleMenu(target, child, extension);
                    continue;
                }
                Object userObject = child.getUserObject();
                if (userObject instanceof IStyle) {
                    IStyle style = (IStyle)userObject;
                    if (null == extension.getStyleNode(style)) continue;
                    AssignStyleAction action = new AssignStyleAction(style);
                    this.modeController.addActionIfNotAlreadySet((AFreeplaneAction)action);
                    MLogicalStyleController.this.actions.add(action);
                    entryAccessor.addChildAction(target, (AFreeplaneAction)action);
                    continue;
                }
                LogUtils.severe((String)("unexpected user object on style map: " + userObject));
            }
        }
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            LogicalStyleModel fromStyle = (LogicalStyleModel)from.getExtension(LogicalStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            LogicalStyleModel toStyle = LogicalStyleModel.createExtension((NodeModel)to);
            toStyle.setStyle(fromStyle.getStyle());
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            from.removeExtension(LogicalStyleModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.LOGICAL_STYLE)) {
                return;
            }
            LogicalStyleModel whichStyle = (LogicalStyleModel)which.getExtension(LogicalStyleModel.class);
            if (whichStyle == null) {
                return;
            }
            LogicalStyleModel fromStyle = (LogicalStyleModel)from.getExtension(LogicalStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension((IExtension)fromStyle);
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
        }
    }

    private static class StyleRemover
    implements INodeChangeListener {
        public void nodeChanged(NodeChangeEvent event) {
            ModeController modeController = Controller.getCurrentModeController();
            if (modeController == null || modeController.isUndoAction()) {
                return;
            }
            if (!event.getProperty().equals(LogicalStyleModel.class)) {
                return;
            }
            NodeModel node = event.getNode();
            MapModel map = node.getMap();
            IStyle styleKey = (IStyle)event.getNewValue();
            MapStyleModel mapStyles = MapStyleModel.getExtension((MapModel)map);
            NodeModel styleNode = mapStyles.getStyleNode(styleKey);
            if (styleNode == null) {
                return;
            }
            modeController.undoableRemoveExtensions((Object)LogicalStyleKeys.NODE_STYLE, node, styleNode);
        }
    }

    private final class AddConditionalStyleActor
    implements IActor {
        private final ConditionalStyleModel conditionalStyleModel;
        private final boolean isActive;
        private final ASelectableCondition condition;
        private final IStyle style;
        private boolean isLast;

        public AddConditionalStyleActor(ConditionalStyleModel conditionalStyleModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
            this.conditionalStyleModel = conditionalStyleModel;
            this.isActive = isActive;
            this.condition = condition;
            this.style = style;
            this.isLast = isLast;
        }

        public void undo() {
            int index = this.conditionalStyleModel.getStyleCount() - 1;
            MLogicalStyleController.super.removeConditionalStyle(this.conditionalStyleModel, index);
        }

        public String getDescription() {
            return "AddConditionalStyle";
        }

        public void act() {
            MLogicalStyleController.super.addConditionalStyle(this.conditionalStyleModel, this.isActive, this.condition, this.style, this.isLast);
        }
    }

    private final class RemoveConditionalStyleActor
    implements IActor {
        private final int index;
        private final ConditionalStyleModel conditionalStyleModel;
        ConditionalStyleModel.Item item = null;

        private RemoveConditionalStyleActor(ConditionalStyleModel conditionalStyleModel, int index) {
            this.index = index;
            this.conditionalStyleModel = conditionalStyleModel;
        }

        public void undo() {
            MLogicalStyleController.super.insertConditionalStyle(this.conditionalStyleModel, this.index, this.item.isActive(), this.item.getCondition(), this.item.getStyle(), this.item.isLast());
        }

        public String getDescription() {
            return "RemoveConditionalStyle";
        }

        public void act() {
            this.item = MLogicalStyleController.super.removeConditionalStyle(this.conditionalStyleModel, this.index);
        }
    }
}

