/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.MTextController;

public abstract class EditNodeBase {
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_SPLIT = 2;
    private final IEditControl editControl;
    protected NodeModel node;
    protected String text;
    private Color background;
    protected FocusListener textFieldListener = null;

    protected JPopupMenu createPopupMenu(Component component) {
        JPopupMenu menu = new JPopupMenu();
        if (!(component instanceof JTextComponent)) {
            return menu;
        }
        ActionMap actionMap = ((JTextComponent)component).getActionMap();
        Action copyAction = actionMap.get("copy-to-clipboard");
        this.addAction(menu, copyAction, "CopyAction.text");
        Action cutAction = actionMap.get("cut-to-clipboard");
        this.addAction(menu, cutAction, "CutAction.text");
        Action pasteAction = actionMap.get("paste-from-clipboard");
        this.addAction(menu, pasteAction, "PasteAction.text");
        SpellCheckerController.getController().addSpellCheckerMenu(menu);
        return menu;
    }

    protected void addAction(JPopupMenu menu, Action action, String label) {
        if (action == null) {
            return;
        }
        String text = TextUtils.getRawText((String)label);
        JMenuItem item = menu.add(new JMenuItem());
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)item, (String)text);
        item.addActionListener(action);
    }

    protected Color getBackground() {
        return this.background;
    }

    protected EditNodeBase(NodeModel node, String text, IEditControl editControl) {
        this.editControl = editControl;
        this.node = node;
        this.text = text;
    }

    public void closeEdit() {
        if (this.textFieldListener != null) {
            this.textFieldListener.focusLost(null);
        }
    }

    public IEditControl getEditControl() {
        return this.editControl;
    }

    public NodeModel getNode() {
        return this.node;
    }

    protected String getText() {
        return this.text;
    }

    public FocusListener getTextFieldListener() {
        return this.textFieldListener;
    }

    protected void redispatchKeyEvents(JTextComponent textComponent, KeyEvent firstKeyEvent) {
        EventBuffer keyEventDispatcher = MTextController.getController().getEventQueue();
        if (textComponent.hasFocus()) {
            keyEventDispatcher.deactivate();
            return;
        }
        keyEventDispatcher.activate();
        keyEventDispatcher.setTextComponent(textComponent);
        if (firstKeyEvent == null) {
            return;
        }
        if (firstKeyEvent.getKeyChar() == '\uffff') {
            switch (firstKeyEvent.getKeyCode()) {
                case 36: {
                    int modelIdx = textComponent.viewToModel(new Point(0, 0));
                    if (modelIdx < 0) break;
                    textComponent.setCaretPosition(modelIdx);
                    break;
                }
                case 35: {
                    textComponent.setCaretPosition(textComponent.getDocument().getLength());
                }
            }
        } else {
            textComponent.selectAll();
        }
    }

    public void setTextFieldListener(FocusListener listener) {
        this.textFieldListener = listener;
    }

    public abstract void show(RootPaneContainer var1);

    public void setBackground(Color background) {
        this.background = background;
    }

    public static interface IEditControl {
        public void cancel();

        public void ok(String var1);

        public void split(String var1, int var2);

        public boolean canSplit();

        public EditedComponent getEditType();
    }

    static abstract class EditDialog {
        private final JDialog dialog;
        private EditNodeBase base;

        protected JDialog getDialog() {
            return this.dialog;
        }

        protected EditDialog(EditNodeBase base, String title, RootPaneContainer frame) {
            this.dialog = frame instanceof Frame ? new JDialog((Frame)((Object)frame), title, true) : new JDialog((JDialog)frame, title, true);
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.setDefaultCloseOperation(0);
            DialogWindowListener dfl = new DialogWindowListener();
            this.dialog.addWindowListener(dfl);
            this.base = base;
        }

        protected void cancel() {
            this.dialog.setVisible(false);
        }

        protected void confirmedCancel() {
            int action;
            if (this.isChanged() && (action = JOptionPane.showConfirmDialog(this.dialog, TextUtils.getText((String)"long_node_changed_cancel"), "", 2)) == 2) {
                return;
            }
            this.cancel();
        }

        protected void confirmedSubmit() {
            if (this.isChanged()) {
                int action = JOptionPane.showConfirmDialog(this.dialog, TextUtils.getText((String)"long_node_changed_submit"), "", 1);
                if (action == 2) {
                    return;
                }
                if (action == 0) {
                    this.submit();
                    return;
                }
            }
            this.cancel();
        }

        EditNodeBase getBase() {
            return this.base;
        }

        protected abstract boolean isChanged();

        void setBase(EditNodeBase base) {
            this.base = base;
        }

        protected void split() {
            this.dialog.setVisible(false);
        }

        protected void submit() {
            this.dialog.setVisible(false);
        }

        public void show() {
            this.dialog.show();
        }

        public void dispose() {
            this.dialog.dispose();
        }

        public Container getContentPane() {
            return this.dialog.getContentPane();
        }

        public Component getFocusOwner() {
            return this.dialog.getFocusOwner();
        }

        public Component getMostRecentFocusOwner() {
            return this.dialog.getMostRecentFocusOwner();
        }

        class SubmitAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            SubmitAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog.this.submit();
            }
        }

        class SplitAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            SplitAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog.this.split();
            }
        }

        class DialogWindowListener
        extends WindowAdapter {
            DialogWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (EditDialog.this.dialog.isVisible()) {
                    EditDialog.this.confirmedSubmit();
                }
            }
        }

        class CancelAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            CancelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog.this.confirmedCancel();
            }
        }
    }

    public static enum EditedComponent {
        TEXT,
        DETAIL,
        NOTE;

    }
}

