/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import com.lightdev.app.shtm.SHTMLAction;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class SHTMLEditLinkAction
extends AFreeplaneAction
implements SHTMLAction {
    private final SHTMLPanelImpl panel;

    public SHTMLEditLinkAction(SHTMLPanelImpl panel) {
        super("SetLinkByTextFieldAction");
        this.panel = panel;
        SHTMLPanelImpl.getActionProperties((Action)((Object)this), (String)"setLinkByTextField");
    }

    public void actionPerformed(ActionEvent ae) {
        AttributeSet elemAttrs;
        Object linkAttr;
        Object href;
        boolean foundLink;
        SHTMLEditorPane editorPane = this.panel.getSHTMLEditorPane();
        Element linkElement = editorPane.getCurrentLinkElement();
        boolean bl = foundLink = linkElement != null;
        String linkAsString = foundLink ? ((href = ((AttributeSet)(linkAttr = (elemAttrs = linkElement.getAttributes()).getAttribute(HTML.Tag.A))).getAttribute(HTML.Attribute.HREF)) != null ? href.toString() : "http://") : "http://";
        String inputValue = UITools.showInputDialog((NodeModel)Controller.getCurrentController().getSelection().getSelected(), (String)TextUtils.getText((String)"edit_link_manually"), (String)linkAsString);
        if (inputValue != null && !inputValue.matches("\\w+://")) {
            SHTMLEditorPane editor = this.panel.getSHTMLEditorPane();
            if (inputValue.equals("")) {
                editor.setLink(null, null, null);
                return;
            }
            try {
                URI link = LinkController.createURI((String)inputValue.trim());
                editor.setLink(null, link.toString(), null);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn((Throwable)e1);
                UITools.errorMessage((Object)TextUtils.format((String)"invalid_uri", (Object[])new Object[]{inputValue}));
                return;
            }
        }
        this.panel.updateActions();
    }

    public void update() {
        if (this.panel.isHtmlEditorActive()) {
            this.setEnabled(false);
            return;
        }
        if (this.panel.getSHTMLEditorPane() != null) {
            if (this.panel.getSHTMLEditorPane().getSelectionEnd() > this.panel.getSHTMLEditorPane().getSelectionStart() || this.panel.getSHTMLEditorPane().getCurrentLinkElement() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

