/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.SysUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.features.time.mindmapmode.ClockState;
import org.freeplane.view.swing.features.time.mindmapmode.PeriodUnit;
import org.freeplane.view.swing.features.time.mindmapmode.TimerBlinkTask;

public class ReminderExtension
implements IExtension,
IMapChangeListener {
    static final int BLINKING_PERIOD = 1000;
    private final NodeModel node;
    private long remindUserAt = 0L;
    private PeriodUnit periodUnit;
    private int period;
    private Timer timer;
    private String script;
    private TimerBlinkTask task;

    public static ReminderExtension getExtension(NodeModel node) {
        return (ReminderExtension)node.getExtension(ReminderExtension.class);
    }

    public ReminderExtension(NodeModel node) {
        this.node = node;
    }

    public NodeModel getNode() {
        return this.node;
    }

    public long getRemindUserAt() {
        return this.remindUserAt;
    }

    public void setRemindUserAt(long remindUserAt) {
        this.remindUserAt = remindUserAt;
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(PeriodUnit periodUnit) {
        this.periodUnit = periodUnit;
    }

    public String getPeriodUnitAsString() {
        return this.periodUnit == null ? null : this.periodUnit.name();
    }

    public void setPeriodUnitAsString(String periodUnit) {
        this.periodUnit = PeriodUnit.valueOf(periodUnit);
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void scheduleTimer(TimerBlinkTask task, Date date) {
        if (this.timer == null) {
            this.timer = SysUtils.createTimer((String)this.getClass().getSimpleName());
        }
        this.timer.schedule((TimerTask)task, date, 1000L);
        this.task = task;
    }

    public void deactivateTimer() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
        this.task = null;
    }

    private void displayStateIcon(NodeModel parent, ClockState state) {
        if (this.task != null && !this.task.alreadyExecuted() || !this.isAncestorNode(parent)) {
            return;
        }
        this.displayState(state, parent, true);
    }

    private boolean isAncestorNode(NodeModel parent) {
        for (NodeModel n = this.node; n != null; n = n.getParentNode()) {
            if (!n.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        this.displayStateIcon(parent, ClockState.CLOCK_VISIBLE);
    }

    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
        this.displayStateIcon(nodeMoveEvent.newParent, ClockState.CLOCK_VISIBLE);
    }

    public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
        this.displayStateIcon(nodeDeletionEvent.parent, null);
    }

    public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        this.displayStateIcon(nodeMoveEvent.oldParent, null);
    }

    public void mapChanged(MapChangeEvent event) {
    }

    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
    }

    public void displayState(ClockState stateAdded, NodeModel pNode, boolean recurse) {
        if (stateAdded != null) {
            pNode.putExtension((IExtension)stateAdded);
        } else {
            pNode.removeExtension(ClockState.class);
        }
        Controller.getCurrentModeController().getMapController().nodeRefresh(pNode);
        if (!recurse) {
            return;
        }
        NodeModel parentNode = pNode.getParentNode();
        if (parentNode == null) {
            return;
        }
        this.displayState(stateAdded, parentNode, recurse);
    }
}

