/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Vector;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReferenceImpl<S>
implements ServiceReference<S> {
    private final ServiceRegistrationImpl<S> registration;

    ServiceReferenceImpl(ServiceRegistrationImpl<S> reg) {
        this.registration = reg;
    }

    @Override
    public Object getProperty(String key) {
        return this.cloneObject(this.registration.getProperty(key));
    }

    @Override
    public String[] getPropertyKeys() {
        return this.registration.getProperties().keyArray();
    }

    @Override
    public Bundle getBundle() {
        return this.registration.bundle;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceReferenceImpl) {
            ServiceReferenceImpl that = (ServiceReferenceImpl)o;
            return this.registration == that.registration;
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        int r2;
        ServiceReference that = (ServiceReference)obj;
        boolean sameFw = false;
        if (that instanceof ServiceReferenceImpl) {
            ServiceReferenceImpl thatImpl = (ServiceReferenceImpl)that;
            boolean bl = sameFw = this.registration.fwCtx == thatImpl.registration.fwCtx;
        }
        if (!sameFw) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Can not compare service references belonging to different framework instances (this=").append(this).append(", other=").append(that).append(").")).toString());
        }
        Object ro1 = this.getProperty("service.ranking");
        Object ro2 = that.getProperty("service.ranking");
        int r1 = ro1 instanceof Integer ? (Integer)ro1 : 0;
        int n = r2 = ro2 instanceof Integer ? (Integer)ro2 : 0;
        if (r1 != r2) {
            return r1 < r2 ? -1 : 1;
        }
        Long id1 = (Long)this.getProperty("service.id");
        Long id2 = (Long)that.getProperty("service.id");
        return id2.compareTo(id1);
    }

    public int hashCode() {
        return this.registration.hashCode();
    }

    @Override
    public Bundle[] getUsingBundles() {
        return this.registration.getUsingBundles();
    }

    S getService(BundleImpl bundle) {
        bundle.fwCtx.perm.checkGetServicePerms(this);
        return this.registration.getService(bundle);
    }

    boolean ungetService(BundleImpl bundle) {
        return this.registration.ungetService(bundle, true);
    }

    PropertiesDictionary getProperties() {
        return this.registration.getProperties();
    }

    Object cloneObject(Object val) {
        if (val instanceof Object[]) {
            int len = Array.getLength(val = ((Object[])val).clone());
            if (len > 0 && Array.get(val, 0).getClass().isArray()) {
                for (int i = 0; i < len; ++i) {
                    Array.set(val, i, this.cloneObject(Array.get(val, i)));
                }
            }
        } else if (val instanceof boolean[]) {
            val = ((boolean[])val).clone();
        } else if (val instanceof byte[]) {
            val = ((byte[])val).clone();
        } else if (val instanceof char[]) {
            val = ((char[])val).clone();
        } else if (val instanceof double[]) {
            val = ((double[])val).clone();
        } else if (val instanceof float[]) {
            val = ((float[])val).clone();
        } else if (val instanceof int[]) {
            val = ((int[])val).clone();
        } else if (val instanceof long[]) {
            val = ((long[])val).clone();
        } else if (val instanceof short[]) {
            val = ((short[])val).clone();
        } else if (val instanceof Vector) {
            Vector c = (Vector)((Vector)val).clone();
            for (int i = 0; i < c.size(); ++i) {
                c.setElementAt(this.cloneObject(c.elementAt(i)), i);
            }
            val = c;
        }
        return val;
    }

    @Override
    public boolean isAssignableTo(Bundle bundle, String className) {
        BundleImpl sBundle = this.registration.bundle;
        if (sBundle == null) {
            throw new IllegalStateException("Service is unregistered");
        }
        FrameworkContext fwCtx = sBundle.fwCtx;
        if (((BundleImpl)bundle).fwCtx != fwCtx) {
            throw new IllegalArgumentException("Bundle is not from same framework as service");
        }
        if (fwCtx.isBootDelegated(className)) {
            return true;
        }
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            String name = className.substring(0, pos);
            Pkg p = fwCtx.resolver.getPkg(name);
            if (p != null) {
                ArrayList<BundleGeneration> pkgConsumer;
                ArrayList<BundleGeneration> pkgProvider;
                BundlePackages rbp = sBundle.current().bpkgs;
                BundlePackages pkgExporter = rbp.getProviderBundlePackages(name);
                if (pkgExporter == null) {
                    pkgProvider = rbp.getRequiredBundleGenerations(name);
                } else {
                    pkgProvider = new ArrayList(1);
                    pkgProvider.add(pkgExporter.bg);
                }
                BundlePackages bb = ((BundleImpl)bundle).current().bpkgs;
                BundlePackages bbp = bb.getProviderBundlePackages(name);
                if (bbp == null) {
                    pkgConsumer = bb.getRequiredBundleGenerations(name);
                } else {
                    pkgConsumer = new ArrayList(1);
                    pkgConsumer.add(bbp.bg);
                }
                if (pkgConsumer == null) {
                    if (bb.isExported(name)) {
                        return pkgProvider != null ? pkgProvider.contains(bb.bg) : true;
                    }
                    return true;
                }
                if (pkgProvider == null) {
                    Object sService = this.registration.service;
                    if (sService == null) {
                        throw new IllegalStateException("Service is unregistered");
                    }
                    if (p.providers.size() == 1) {
                        return true;
                    }
                    if (sService instanceof ServiceFactory) {
                        return true;
                    }
                    ClassLoader bCL = bb.getClassLoader();
                    if (bCL != null) {
                        try {
                            Class<?> bCls = bCL.loadClass(className);
                            return bCls.isAssignableFrom(sService.getClass());
                        }
                        catch (Exception e) {
                            return true;
                        }
                    }
                } else {
                    for (BundleGeneration element : pkgProvider) {
                        if (!pkgConsumer.contains(element)) continue;
                        return true;
                    }
                }
            } else {
                if (name.startsWith("java.") || sBundle == bundle) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }
}

