/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.core.ui.menubuilders.generic.AttributeAlreadySetException;

public class Entry {
    private String name = "";
    private Entry parent;
    private List<String> builders;
    private final Map<Object, Object> attributes;
    private final ArrayList<Entry> childEntries = new ArrayList();

    public Entry() {
        this.attributes = new HashMap<Object, Object>();
        this.builders = Collections.emptyList();
    }

    public void setAttribute(String key, Object value) {
        this.setAttributeObject(key, value);
    }

    public void setAttribute(Class<?> valueClass, Object value) {
        this.setAttributeObject(valueClass, value);
    }

    private void setAttributeObject(Object key, Object value) {
        if (this.attributes.containsKey(key)) {
            if (value != this.attributes.get(key)) {
                throw new AttributeAlreadySetException(this, key, this.attributes.get(key));
            }
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public <T> T getAttribute(Class<T> key) {
        return (T)this.attributes.get(key);
    }

    public void addChild(Entry entry) {
        this.childEntries.add(entry);
        entry.setParent(this);
    }

    private void setParent(Entry parent) {
        this.parent = parent;
    }

    public Entry setBuilders(List<String> builders) {
        this.builders = builders;
        return this;
    }

    public Entry setBuilders(String ... builders) {
        return this.setBuilders(Arrays.asList(builders));
    }

    public Entry getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return (this.parent != null ? this.parent.getPath() : "") + "/" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public Entry getChild(int index) {
        return this.childEntries.get(index);
    }

    public Entry getChild(int ... indices) {
        Entry entry = this;
        for (int index : indices) {
            entry = entry.getChild(index);
        }
        return entry;
    }

    public List<Entry> children() {
        return this.childEntries;
    }

    public Collection<String> builders() {
        return this.builders;
    }

    public void removeChildren() {
        this.childEntries.clear();
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public <T> T removeAttribute(Class<T> valueClass) {
        return (T)this.attributes.remove(valueClass);
    }

    public boolean hasChildren() {
        return !this.childEntries.isEmpty();
    }

    public int getChildCount() {
        return this.childEntries.size();
    }

    public Entry getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public String toString() {
        return "Entry [name=" + this.name + ", builders=" + this.builders + ", attributes=" + this.attributes + ", childEntries=" + this.childEntries + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.builders == null ? 0 : this.builders.hashCode());
        result = 31 * result + (this.childEntries == null ? 0 : this.childEntries.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.builders == null ? other.builders != null : !this.builders.equals(other.builders)) {
            return false;
        }
        if (this.childEntries == null ? other.childEntries != null : !this.childEntries.equals(other.childEntries)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Entry getChild(String name) {
        for (Entry child : this.children()) {
            Entry deepChild;
            String childName = child.getName();
            if (childName.isEmpty() && (deepChild = child.getChild(name)) != null) {
                return deepChild;
            }
            if (!name.equals(childName)) continue;
            return child;
        }
        return null;
    }

    public Entry findEntry(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        for (Entry child : this.children()) {
            Entry entry = child.findEntry(name);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public List<Entry> findEntries(String name) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (this.name.equals(name)) {
            entries.add(this);
        }
        for (Entry child : this.children()) {
            entries.addAll(child.findEntries(name));
        }
        return entries;
    }

    public boolean isLeaf() {
        return this.childEntries.isEmpty();
    }

    public Entry getChildByPath(String ... names) {
        Entry entry = this;
        for (String name : names) {
            if (!name.isEmpty()) {
                entry = entry.getChild(name);
            }
            if (entry == null) break;
        }
        return entry;
    }

    public void remove(Entry entry) {
        this.childEntries.remove(entry);
    }
}

