/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import org.freeplane.core.util.Convertible;

public class Quantity<U extends Enum<U>> {
    public final double value;
    public final U unit;

    public static <U extends Enum<U>> Quantity<U> fromString(String valueString, U defaultUnit) {
        U unit;
        String numberString;
        if (valueString == null) {
            return null;
        }
        int separatorPosition = valueString.lastIndexOf(32);
        if (separatorPosition >= 0) {
            numberString = valueString.substring(0, separatorPosition);
            String unitString = valueString.substring(separatorPosition + 1);
            Class<U> unitClass = defaultUnit.getDeclaringClass();
            unit = Enum.valueOf(unitClass, unitString);
        } else {
            numberString = valueString;
            unit = defaultUnit;
        }
        double doubleValue = Double.parseDouble(numberString);
        return new Quantity<U>(doubleValue, unit);
    }

    public Quantity(double value, U unit) {
        this.value = value;
        this.unit = unit;
    }

    public double toBaseUnits() {
        return this.value * ((Convertible)this.unit).factor();
    }

    public int toBaseUnitsRounded() {
        return (int)(this.toBaseUnits() + 0.5);
    }

    public String toString() {
        return this.value + " " + this.unit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Enum)this.unit).hashCode();
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantity other = (Quantity)obj;
        if (!((Enum)this.unit).equals(other.unit)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public Quantity<U> in(U unit) {
        return new Quantity<U>(this.value * (((Convertible)this.unit).factor() / ((Convertible)unit).factor()), unit);
    }

    public void assertNonNegative() {
        if (this.value < 0.0) {
            throw new IllegalStateException("non negative value required");
        }
    }

    public static <U extends Enum<U>> void assertNonNegativeOrNull(Quantity<U> quantity) {
        if (quantity != null) {
            quantity.assertNonNegative();
        }
    }

    public Quantity<U> add(Quantity<U> second) {
        if (this.unit == second.unit) {
            return new Quantity<U>(this.value + second.value, this.unit);
        }
        double sum = this.value + second.in(this.unit).value;
        return new Quantity<U>(sum, this.unit);
    }

    public Quantity<U> add(double value, U unit) {
        return this.add(new Quantity<U>(value, unit));
    }
}

