/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import javax.swing.event.EventListenerList;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.attribute.ColumnWidthChangeEvent;
import org.freeplane.features.attribute.IColumnWidthChangeListener;

public class AttributeTableLayoutModel {
    public static final String HIDE_ALL = "hide";
    public static final String SHOW_ALL = "extended";
    public static final String SHOW_SELECTED = "selected";
    ColumnWidthChangeEvent[] layoutChangeEvent = new ColumnWidthChangeEvent[]{null, null};
    private EventListenerList listenerList = null;
    private final Quantity<?>[] width = new Quantity[]{ResourceController.getResourceController().getLengthQuantityProperty("default_attribute_key_column_width").in(LengthUnits.pt), ResourceController.getResourceController().getLengthQuantityProperty("default_attribute_value_column_width").in(LengthUnits.pt)};

    public void addColumnWidthChangeListener(IColumnWidthChangeListener l) {
        this.getListenerList().add(IColumnWidthChangeListener.class, l);
    }

    protected void fireColumnWidthChanged(int col) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IColumnWidthChangeListener.class) continue;
            if (this.layoutChangeEvent[col] == null) {
                this.layoutChangeEvent[col] = new ColumnWidthChangeEvent(this, col);
            }
            ((IColumnWidthChangeListener)listeners[i + 1]).columnWidthChanged(this.layoutChangeEvent[col]);
        }
    }

    public Quantity<LengthUnits> getColumnWidth(int col) {
        return this.width[col];
    }

    private EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void removeColumnWidthChangeListener(IColumnWidthChangeListener l) {
        this.getListenerList().remove(IColumnWidthChangeListener.class, l);
    }

    public void setColumnWidth(int col, Quantity<LengthUnits> width) {
        if (!this.width[col].equals(width)) {
            this.width[col] = width;
            this.fireColumnWidthChanged(col);
        }
    }
}

