/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.AFilterComposerDialog;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.mode.Controller;

class EditFilterAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterController filterController;
    private AFilterComposerDialog filterDialog = null;

    EditFilterAction(FilterController filterController) {
        super("EditFilterAction");
        this.filterController = filterController;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object selectedItem = this.filterController.getFilterConditions().getSelectedItem();
        if (selectedItem != null) {
            this.getFilterDialog().setSelectedItem(selectedItem);
        }
        this.getFilterDialog().show();
    }

    private AFilterComposerDialog getFilterDialog() {
        if (this.filterDialog == null) {
            this.filterDialog = new FilterComposerDialog();
            this.getFilterDialog().setLocationRelativeTo(this.filterController.getFilterToolbar());
            Controller.getCurrentController().getMapViewManager().addMapSelectionListener(this.filterDialog);
        }
        return this.filterDialog;
    }

    private class FilterComposerDialog
    extends AFilterComposerDialog {
        private static final long serialVersionUID = 1L;

        public FilterComposerDialog() {
            super(TextUtils.getText("filter_dialog"), false);
        }

        @Override
        protected DefaultComboBoxModel createModel() {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            DefaultComboBoxModel externalConditionsModel = EditFilterAction.this.filterController.getFilterConditions();
            for (int i = 3; i < externalConditionsModel.getSize(); ++i) {
                Object element = externalConditionsModel.getElementAt(i);
                model.addElement(element);
            }
            Object selectedItem = externalConditionsModel.getSelectedItem();
            if (model.getIndexOf(selectedItem) != -1) {
                model.setSelectedItem(selectedItem);
            } else {
                model.setSelectedItem(null);
            }
            return model;
        }

        @Override
        protected boolean applyModel(DefaultComboBoxModel model, int[] selectedIndices) {
            EditFilterAction.this.filterController.setFilterConditions(model);
            return true;
        }
    }
}

