/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICombinedCondition;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public class ConditionNotSatisfiedDecorator
extends ASelectableCondition
implements ICombinedCondition {
    static final String NAME = "negate_condition";
    private final ASelectableCondition originalCondition;

    static ASelectableCondition load(ConditionFactory conditionFactory, XMLElement element) {
        Vector<XMLElement> children = element.getChildren();
        ASelectableCondition cond = conditionFactory.loadCondition(children.get(0));
        if (cond == null) {
            return null;
        }
        return new ConditionNotSatisfiedDecorator(cond);
    }

    public ConditionNotSatisfiedDecorator(ASelectableCondition originalCondition) {
        assert (originalCondition != null);
        this.originalCondition = originalCondition;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        return !this.originalCondition.checkNode(node);
    }

    @Override
    protected JComponent createRendererComponent() {
        JCondition component = new JCondition();
        String not = TextUtils.getText("filter_not");
        String text = not + ' ';
        component.add(ConditionFactory.createConditionLabel(text));
        this.originalCondition.getUserName();
        JComponent renderer = this.originalCondition.createShortRendererComponent();
        component.add(renderer);
        return component;
    }

    @Override
    public void fillXML(XMLElement child) {
        this.originalCondition.toXml(child);
    }

    @Override
    protected String createDescription() {
        return NAME;
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public Collection<ASelectableCondition> split() {
        return Arrays.asList(this.originalCondition);
    }
}

