/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.MindIconFactory;

public class IconStore {
    private final Map<String, IconGroup> groups = new LinkedHashMap<String, IconGroup>();
    private final Map<String, MindIcon> mindIcons = new HashMap<String, MindIcon>();
    private final Map<String, UIIcon> uiIcons = new HashMap<String, UIIcon>();

    public void addGroup(IconGroup group) {
        this.groups.put(group.getName(), group);
        for (MindIcon icon : group.getIcons()) {
            this.mindIcons.put(icon.getName(), icon);
        }
    }

    public void addMindIcon(String groupName, MindIcon icon) {
        if (!this.groups.containsKey(groupName)) {
            IconGroup group = new IconGroup(groupName, icon);
            this.groups.put(groupName, group);
        }
        this.groups.get(groupName).addIcon(icon);
        this.mindIcons.put(icon.getName(), icon);
    }

    public void addUIIcon(UIIcon uiIcon) {
        this.uiIcons.put(uiIcon.getFileName(), uiIcon);
    }

    public Collection<IconGroup> getGroups() {
        return this.groups.values();
    }

    public Collection<MindIcon> getMindIcons() {
        ArrayList<MindIcon> icons = new ArrayList<MindIcon>();
        for (IconGroup group : this.groups.values()) {
            icons.addAll(group.getIcons());
        }
        return icons;
    }

    public Collection<MindIcon> getUserIcons() {
        return this.groups.get("user").getIcons();
    }

    public MindIcon getMindIcon(String name) {
        if (name == null) {
            return new IconNotFound(name);
        }
        if (this.mindIcons.containsKey(name)) {
            return this.mindIcons.get(name);
        }
        MindIcon mindIcon = MindIconFactory.create(name);
        if (ResourceController.getResourceController().getResource(mindIcon.getPath()) != null) {
            return mindIcon;
        }
        return new IconNotFound(name);
    }

    public UIIcon getUIIcon(String name) {
        UIIcon result;
        if (this.mindIcons.containsKey(name)) {
            result = this.mindIcons.get(name);
        } else if (this.uiIcons.containsKey(name)) {
            result = this.uiIcons.get(name);
        } else {
            result = new UIIcon(name, name);
            this.uiIcons.put(name, result);
        }
        return result;
    }
}

