/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.factory;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.UserIcon;
import org.freeplane.features.icon.factory.MindIconFactory;

public class IconStoreFactory {
    private static final String SEPARATOR = ";";
    private static final ResourceController RESOURCE_CONTROLLER = ResourceController.getResourceController();
    private static final String GROUP_NAMES_KEY = "icons.groups";
    private static final String GROUP_KEY = "icons.group.%s";
    private static final String GROUP_ICON_KEY = "IconGroupPopupAction.%s.icon";
    private static final String GROUP_DESC_KEY = "IconGroupPopupAction.%s.text";
    private static IconStore groups;

    public static IconStore create() {
        if (groups != null) {
            return groups;
        }
        groups = new IconStore();
        IconStoreFactory.setIconGroups(groups);
        return groups;
    }

    private static void setIconGroups(IconStore iconStore) {
        String[] groupNames;
        for (String groupName : groupNames = RESOURCE_CONTROLLER.getProperty(GROUP_NAMES_KEY).split(SEPARATOR)) {
            List<MindIcon> icons;
            String description = TextUtils.getText(String.format(GROUP_DESC_KEY, groupName));
            UIIcon groupIcon = null;
            if ("user".equals(groupName)) {
                icons = IconStoreFactory.getUserIcons();
                groupIcon = MindIconFactory.create("user_icon");
            } else {
                String groupIconName = RESOURCE_CONTROLLER.getProperty(String.format(GROUP_ICON_KEY, groupName));
                Map<String, MindIcon> iconMap = IconStoreFactory.getIcons(groupName);
                groupIcon = iconMap.get(groupIconName);
                icons = new ArrayList<MindIcon>(iconMap.values());
            }
            if (groupIcon == null) {
                groupIcon = icons.size() > 0 ? icons.get(0) : new IconNotFound("?");
            }
            iconStore.addGroup(new IconGroup(groupName, groupIcon, description, icons));
        }
    }

    private static Map<String, MindIcon> getIcons(String groupName) {
        String[] iconNames = RESOURCE_CONTROLLER.getProperty(String.format(GROUP_KEY, groupName)).split(SEPARATOR);
        LinkedHashMap<String, MindIcon> icons = new LinkedHashMap<String, MindIcon>(iconNames.length);
        for (String iconName : iconNames) {
            MindIcon icon = MindIconFactory.create(iconName);
            icons.put(iconName, icon);
        }
        return icons;
    }

    private static List<MindIcon> getUserIcons() {
        ResourceController resourceController = ResourceController.getResourceController();
        if (resourceController.isApplet()) {
            return Collections.emptyList();
        }
        File iconDir = new File(resourceController.getFreeplaneUserDirectory(), "icons");
        if (!iconDir.exists()) {
            LogUtils.info("creating user icons directory " + iconDir);
            iconDir.mkdirs();
            return Collections.emptyList();
        }
        return IconStoreFactory.getUserIcons(iconDir, "");
    }

    private static List<MindIcon> getUserIcons(File iconDir, String dir) {
        String fullName;
        File childDir;
        String[] userIconArray = iconDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int nameLength = name.length();
                return nameLength > 4 && name.substring(nameLength - 4).equalsIgnoreCase(".png") || new File(dir, name).isDirectory();
            }
        });
        if (userIconArray == null) {
            return Collections.emptyList();
        }
        ArrayList<MindIcon> icons = new ArrayList<MindIcon>(userIconArray.length);
        for (String fileName : userIconArray) {
            childDir = new File(iconDir, fileName);
            if (!childDir.isDirectory()) continue;
            fullName = dir + fileName;
            List<MindIcon> childUserIcons = IconStoreFactory.getUserIcons(childDir, fullName + '/');
            icons.addAll(childUserIcons);
        }
        for (String fileName : userIconArray) {
            childDir = new File(iconDir, fileName);
            fullName = dir + fileName;
            if (childDir.isDirectory()) continue;
            String iconName = fullName.substring(0, fullName.length() - 4);
            String iconDescription = fileName.substring(0, fileName.length() - 4);
            if (iconName.equals("")) continue;
            UserIcon icon = new UserIcon(iconName, fullName, iconDescription);
            icons.add(icon);
        }
        return icons;
    }
}

