/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Point;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorProperties;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;

public class ConnectorModel
extends NodeLinkModel {
    private final ConnectorProperties connectorProperties;

    public ConnectorModel(NodeModel source, String targetID, Color color, int alpha, Shape shape, int width, String labelFontFamily, int labelFontSize) {
        this(source, targetID, new ConnectorProperties(color, alpha, shape, width, labelFontFamily, labelFontSize));
    }

    private ConnectorModel(NodeModel source, String targetID, ConnectorProperties connectorProperties) {
        super(source, targetID);
        assert (source != null);
        this.connectorProperties = connectorProperties;
    }

    public Shape getShape() {
        return this.connectorProperties.getShape();
    }

    public void setShape(Shape shape) {
        this.connectorProperties.setShape(shape);
    }

    public int[] getDash() {
        return this.connectorProperties.getDash();
    }

    public void setDash(int[] dash) {
        this.connectorProperties.setDash(dash);
    }

    public Color getColor() {
        return this.connectorProperties.getColor();
    }

    public ArrowType getEndArrow() {
        return this.connectorProperties.getEndArrow();
    }

    public Point getEndInclination() {
        return this.connectorProperties.getEndInclination();
    }

    public String getMiddleLabel() {
        return this.connectorProperties.getMiddleLabel();
    }

    public String getSourceLabel() {
        return this.connectorProperties.getSourceLabel();
    }

    public ArrowType getStartArrow() {
        return this.connectorProperties.getStartArrow();
    }

    public Point getStartInclination() {
        return this.connectorProperties.getStartInclination();
    }

    public String getTargetLabel() {
        return this.connectorProperties.getTargetLabel();
    }

    public int getWidth() {
        return this.connectorProperties.getWidth();
    }

    public void setColor(Color color) {
        this.connectorProperties.setColor(color);
    }

    public void setEndArrow(ArrowType endArrow) {
        this.connectorProperties.setEndArrow(endArrow);
    }

    public void setEndInclination(Point endInclination) {
        this.connectorProperties.setEndInclination(endInclination);
    }

    public void setMiddleLabel(String middleLabel) {
        this.connectorProperties.setMiddleLabel(middleLabel);
    }

    public boolean getShowControlPointsFlag() {
        return this.connectorProperties.getShowControlPointsFlag();
    }

    public void setShowControlPoints(boolean bShowControlPointsFlag) {
        this.connectorProperties.setShowControlPoints(bShowControlPointsFlag);
    }

    public void setSourceLabel(String label) {
        this.connectorProperties.setSourceLabel(label);
    }

    public void setStartArrow(ArrowType startArrow) {
        this.connectorProperties.setStartArrow(startArrow);
    }

    public void setStartInclination(Point startInclination) {
        this.connectorProperties.setStartInclination(startInclination);
    }

    public void setTargetLabel(String targetLabel) {
        this.connectorProperties.setTargetLabel(targetLabel);
    }

    public void setWidth(int width) {
        this.connectorProperties.setWidth(width);
    }

    public void setAlpha(int alpha) {
        this.connectorProperties.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.connectorProperties.getAlpha();
    }

    public String getLabelFontFamily() {
        return this.connectorProperties.getLabelFontFamily();
    }

    public void setLabelFontFamily(String labelFontFamily) {
        this.connectorProperties.setLabelFontFamily(labelFontFamily);
    }

    public int getLabelFontSize() {
        return this.connectorProperties.getLabelFontSize();
    }

    public void setLabelFontSize(int labelFontSize) {
        this.connectorProperties.setLabelFontSize(labelFontSize);
    }

    public void changeInclination(int deltaX, int deltaY, NodeModel linkedNodeView, Point changedInclination) {
        this.connectorProperties.changeInclination(deltaX, deltaY, linkedNodeView, changedInclination);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectorProperties.hashCode();
        result = 31 * result + this.getSource().hashCode();
        String targetID = this.getTargetID();
        if (targetID == null) {
            return result;
        }
        result = 31 * result + targetID.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorModel other = (ConnectorModel)obj;
        if (!this.connectorProperties.equals(other.connectorProperties) || !this.getSource().equals(other.getSource())) {
            return false;
        }
        String targetID = this.getTargetID();
        if (targetID == null) {
            return other.getTargetID() == null;
        }
        return targetID.equals(other.getTargetID());
    }

    @Override
    public NodeLinkModel cloneForSource(NodeModel sourceClone, String targetId) {
        return new ConnectorModel(sourceClone, targetId, this.connectorProperties);
    }

    @Override
    public NodeLinkModel cloneForSource(NodeModel sourceClone) {
        NodeRelativePath clonePath;
        NodeRelativePath pathAncestorToSource;
        NodeModel ancestorClone;
        NodeRelativePath nodeRelativePath;
        NodeModel commonAncestor;
        NodeModel source = this.getSource();
        if (sourceClone == source) {
            return this;
        }
        NodeModel target = this.getTarget();
        if (target != null && target.getParentNode() != null && source.getParentNode() != null && (commonAncestor = (nodeRelativePath = new NodeRelativePath(source, target)).commonAncestor()).isSubtreeCloneOf(ancestorClone = nodeRelativePath.ancestorForBegin(sourceClone)) && (pathAncestorToSource = new NodeRelativePath(commonAncestor, source)).equalPathsTo(clonePath = new NodeRelativePath(ancestorClone, sourceClone))) {
            NodeModel targetClone = nodeRelativePath.pathEnd(ancestorClone);
            String targetID = targetClone.createID();
            return this.cloneForSource(sourceClone, targetID);
        }
        return null;
    }

    public static enum Shape {
        LINE,
        LINEAR_PATH,
        CUBIC_CURVE,
        EDGE_LIKE;

    }
}

