/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.FollowLinkAction;
import org.freeplane.features.link.GotoLinkNodeAction;
import org.freeplane.features.link.LinkBuilder;
import org.freeplane.features.link.LinkConditionController;
import org.freeplane.features.link.LinkTransformer;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.SelectionController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.url.UrlManager;

public class LinkController
extends SelectionController
implements IExtension {
    public static final String MENUITEM_SCHEME = "menuitem";
    public static final String EXECUTE_APP_SCHEME = "execute";
    public static final String LINK_ICON = ResourceController.getResourceController().getProperty("link_icon");
    private static final String MAIL_ICON = ResourceController.getResourceController().getProperty("mail_icon");
    public static final String LINK_LOCAL_ICON = ResourceController.getResourceController().getProperty("link_local_icon");
    protected final ModeController modeController;
    protected static final String CANCEL = "CANCEL";
    protected static final String CLOSE = "CLOSE";
    public static final String RESOURCES_LINK_COLOR = "standardlinkcolor";
    private static final String RESOURCES_CONNECTOR_SHAPE = "connector_shape";
    private static final String RESOURCES_CONNECTOR_COLOR_ALPHA = "connector_alpha";
    private static final String RESOURCES_CONNECTOR_WIDTH = "connector_width";
    public static final int LINK_ABSOLUTE = 0;
    public static final int LINK_RELATIVE_TO_MINDMAP = 1;
    static Pattern patSMB = Pattern.compile("(?:\\\\\\\\([^\\\\]+)\\\\)(.*?)(?:#([^#]*))?");
    static Pattern patFile = Pattern.compile("((?:\\p{Alpha}:)?([/\\\\])?(?:[^:#?]*))?(?:#([^#]*))?");
    static Pattern patURI = Pattern.compile("(?:(\\p{Alpha}[\\p{Alnum}+.-]+):)?(.*?)(?:#([^#]*))?");
    private static final Pattern urlPattern = Pattern.compile("file://[^\\s\"'<>]+|(:?https?|ftp)://[^\\s\"|<>{}]+");
    private static final Pattern mailPattern = Pattern.compile("([!+\\-/=~.\\w#]+@[\\w.\\-+?&=%]+)");
    private static final HashMap<String, Icon> menuItemCache = new HashMap();
    private static final String MENUITEM_ICON = "icons/button.png";
    private static final String EXECUTABLE_ICON = ResourceController.getResourceController().getProperty("executable_icon");
    private static final IconStore ICON_STORE = IconStoreFactory.create();

    public static LinkController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return LinkController.getController(modeController);
    }

    public static LinkController getController(ModeController modeController) {
        return modeController.getExtension(LinkController.class);
    }

    public static void install() {
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(30, new LinkConditionController());
    }

    public static void install(LinkController linkController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(LinkController.class, linkController);
        linkController.init();
    }

    public LinkController(ModeController modeController) {
        this.modeController = modeController;
    }

    protected void init() {
        this.createActions();
        MapController mapController = this.modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        LinkBuilder linkBuilder = new LinkBuilder(this);
        linkBuilder.registerBy(readManager);
        LinkTransformer textTransformer = new LinkTransformer(this.modeController, 10);
        TextController.getController(this.modeController).addTextTransformer(textTransformer);
        textTransformer.registerListeners(this.modeController);
        INodeSelectionListener listener = new INodeSelectionListener(){

            @Override
            public void onDeselect(NodeModel node) {
            }

            @Override
            public void onSelect(NodeModel node) {
                String linkString;
                URI link = NodeLinks.getValidLink(node);
                String string = linkString = link != null ? link.toString() : null;
                if (linkString != null) {
                    Controller.getCurrentController().getViewController().out(linkString);
                }
            }
        };
        Controller.getCurrentModeController().getMapController().addNodeSelectionListener(listener);
    }

    private JButton addLinks(JComponent arrowLinkPopup, NodeModel source) {
        GotoLinkNodeAction gotoLinkNodeAction = new GotoLinkNodeAction(this, source);
        gotoLinkNodeAction.configureText("follow_graphical_link", source);
        return this.addAction(arrowLinkPopup, gotoLinkNodeAction);
    }

    protected void addPopupComponent(JComponent arrowLinkPopup, String label, JComponent component) {
        JComponent componentBox;
        if (label != null) {
            componentBox = Box.createHorizontalBox();
            componentBox.add(Box.createHorizontalStrut(10));
            JLabel jlabel = new JLabel(label);
            componentBox.add(jlabel);
            componentBox.add(Box.createHorizontalStrut(10));
            componentBox.add(component);
        } else {
            componentBox = component;
        }
        componentBox.setAlignmentX(0.0f);
        componentBox.setMinimumSize(new Dimension());
        componentBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        arrowLinkPopup.add(componentBox);
    }

    protected void addClosingAction(final JComponent arrowLinkPopup, Action action) {
        JButton comp = this.addAction(arrowLinkPopup, action);
        comp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(arrowLinkPopup).setVisible(false);
            }
        });
    }

    protected JButton addAction(JComponent arrowLinkPopup, Action action) {
        JButton comp = new JButton(action);
        comp.setHorizontalAlignment(2);
        this.addPopupComponent(arrowLinkPopup, null, comp);
        return comp;
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new FollowLinkAction());
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "clone_actions", new ClonesMenuBuilder(modeController), new ChildActionEntryRemover(modeController));
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "link_actions", new LinkMenuBuilder(modeController), new ChildActionEntryRemover(modeController));
    }

    protected void createArrowLinkPopup(ConnectorModel link, JComponent arrowLinkPopup) {
        this.registerCloseActions(arrowLinkPopup);
        NodeModel source = link.getSource();
        NodeModel target = link.getTarget();
        IMapSelection selection = Controller.getCurrentModeController().getController().getSelection();
        final JButton sourceButton = this.addLinks(arrowLinkPopup, source);
        sourceButton.setEnabled(!selection.isSelected(source));
        final JButton targetButton = this.addLinks(arrowLinkPopup, target);
        targetButton.setEnabled(!selection.isSelected(target));
        sourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sourceButton.setEnabled(false);
                targetButton.setEnabled(true);
            }
        });
        targetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                targetButton.setEnabled(false);
                sourceButton.setEnabled(true);
            }
        });
    }

    private void registerCloseActions(final JComponent arrowLinkPopup) {
        arrowLinkPopup.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (arrowLinkPopup.isDisplayable()) {
                    arrowLinkPopup.removeHierarchyListener(this);
                    JRootPane rootPane = arrowLinkPopup.getRootPane();
                    InputMap inputMap = rootPane.getInputMap(1);
                    ActionMap actionMap = rootPane.getActionMap();
                    ClosePopupAction closeAction = new ClosePopupAction(LinkController.CLOSE);
                    ClosePopupAction cancelAction = new ClosePopupAction(LinkController.CANCEL);
                    inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
                    actionMap.put(cancelAction, cancelAction);
                    inputMap.put(KeyStroke.getKeyStroke(10, 512), closeAction);
                    boolean enterConfirms = ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default");
                    if (enterConfirms) {
                        inputMap.put(KeyStroke.getKeyStroke(10, 0), closeAction);
                    }
                    actionMap.put(closeAction, closeAction);
                }
            }
        });
    }

    public Color getColor(ConnectorModel model) {
        return model.getColor();
    }

    public int[] getDash(ConnectorModel model) {
        return model.getDash();
    }

    public String getLinkShortText(NodeModel node) {
        URI uri = NodeLinks.getLink(node);
        if (uri == null) {
            return null;
        }
        String adaptedText = uri.toString();
        if (adaptedText.startsWith("#")) {
            ModeController modeController = Controller.getCurrentModeController();
            NodeModel dest = modeController.getMapController().getNodeFromID(adaptedText.substring(1));
            if (dest != null) {
                return TextController.getController().getShortPlainText(dest);
            }
            return TextUtils.getText("link_not_available_any_more");
        }
        return adaptedText;
    }

    public Collection<NodeLinkModel> getLinksFrom(NodeModel node) {
        return NodeLinks.getLinks(node);
    }

    public Collection<NodeLinkModel> getLinksTo(NodeModel target) {
        if (!target.hasID()) {
            return Collections.emptySet();
        }
        MapLinks links = target.getMap().getExtension(MapLinks.class);
        if (links == null) {
            return Collections.emptySet();
        }
        Collection<NodeLinkModel> clonedLinks = null;
        for (NodeModel targetClone : target.subtreeClones()) {
            Set<NodeLinkModel> set = links.get(targetClone.createID());
            if (set == null) continue;
            if (target.subtreeClones().size() == 1) {
                return set;
            }
            if (clonedLinks == null) {
                clonedLinks = new ArrayList(10);
            }
            for (NodeLinkModel sharedLink : set) {
                Collection<NodeLinkModel> linkClones = sharedLink.clones();
                for (NodeLinkModel linkClone : linkClones) {
                    if (!target.equals(linkClone.getTarget())) continue;
                    ((ArrayList)clonedLinks).add(linkClone);
                }
            }
        }
        return clonedLinks != null ? clonedLinks : Collections.emptySet();
    }

    public Component getPopupForModel(Object obj) {
        if (obj instanceof ConnectorModel) {
            ConnectorModel link = (ConnectorModel)obj;
            Box arrowLinkPopup = Box.createVerticalBox();
            arrowLinkPopup.setName(TextUtils.getText("connector"));
            this.createArrowLinkPopup(link, arrowLinkPopup);
            return arrowLinkPopup;
        }
        return null;
    }

    public int getWidth(ConnectorModel model) {
        return model.getWidth();
    }

    public void loadLink(NodeModel node, String link) {
        NodeLinks links = NodeLinks.getLinkExtension(node);
        if (links == null) {
            links = NodeLinks.createLinkExtension(node);
        }
        if (link != null && link.startsWith("#")) {
            links.setLocalHyperlink(node, link.substring(1));
        } else {
            try {
                if (link.startsWith("\"") && link.endsWith("\"")) {
                    link = link.substring(1, link.length() - 1);
                }
                URI hyperlink = LinkController.createURI(link);
                links.setHyperLink(hyperlink);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn(e1);
                UITools.errorMessage(TextUtils.format("link_error", link));
                return;
            }
        }
    }

    void loadLinkFormat(NodeModel node, boolean enabled) {
        NodeLinks.createLinkExtension(node).setFormatNodeAsHyperlink(enabled);
    }

    public void loadURL(NodeModel node, MouseEvent e) {
        this.loadURL(node, new ActionEvent(e.getSource(), e.getID(), null));
    }

    public void loadURL(MouseEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        this.loadURL(modeController.getMapController().getSelectedNode(), e);
    }

    public void loadURI(URI uri) {
        UrlManager.getController().loadURL(uri);
    }

    public void loadMap(String map) throws URISyntaxException {
        UrlManager.getController().loadMap(map);
    }

    protected void loadURL(NodeModel selectedNode, ActionEvent e) {
        this.loadURL(selectedNode, e, NodeLinks.getValidLink(selectedNode));
    }

    public void loadURL(NodeModel selectedNode, ActionEvent e, URI link) {
        if (link != null) {
            this.onDeselect(selectedNode);
            ModeController modeController = Controller.getCurrentModeController();
            if (LinkController.isMenuItemLink(link)) {
                if (e == null) {
                    throw new IllegalArgumentException("ActionEvent is needed for menu item links");
                }
                String actionKey = LinkController.parseSpecialLink(link);
                AFreeplaneAction action = modeController.getAction(actionKey);
                if (action != null) {
                    action.actionPerformed(e);
                } else {
                    LogUtils.warn("Trying to call a menu hyperlink action with key '" + actionKey + "'that doesn't exist.");
                }
            } else if (LinkController.isSpecialLink(EXECUTE_APP_SCHEME, link)) {
                String command = LinkController.parseSpecialLink(link);
                try {
                    Controller.getCurrentController().getViewController().out(command);
                    Runtime.getRuntime().exec(command);
                }
                catch (IOException iOException) {}
            } else {
                this.loadURI(link);
            }
            this.onSelect(modeController.getController().getSelection().getSelected());
        }
    }

    public static int getLinkType() {
        return LinkController.getController().linkType();
    }

    public int linkType() {
        String linkTypeProperty = ResourceController.getResourceController().getProperty("links");
        if ("relative".equals(linkTypeProperty)) {
            return 1;
        }
        return 0;
    }

    public static URI toLinkTypeDependantURI(File map, File input) {
        int type = LinkController.getLinkType();
        if (type == 0) {
            return input.getAbsoluteFile().toURI();
        }
        return LinkController.toRelativeURI(map, input, type);
    }

    public static URI toLinkTypeDependantURI(File map, File input, int linkType) {
        return LinkController.toRelativeURI(map, input, linkType);
    }

    public static URI toRelativeURI(File map, File input, int linkType) {
        return LinkController.getController().createRelativeURI(map, input, linkType);
    }

    public static URI normalizeURI(URI uri) {
        String UNC_PREFIX = "//";
        URI normalizedUri = uri.normalize();
        String normalizedPath = normalizedUri.getPath();
        if ("file".equalsIgnoreCase(uri.getScheme()) && uri.getPath() != null && uri.getPath().startsWith("//") && (normalizedPath == null || !normalizedPath.startsWith("//"))) {
            try {
                normalizedUri = new URI(normalizedUri.getScheme(), LinkController.ensureUNCPath(normalizedUri.getSchemeSpecificPart()), normalizedUri.getFragment());
            }
            catch (URISyntaxException e) {
                LogUtils.warn(e);
            }
        }
        return normalizedUri;
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuffer result = new StringBuffer(len);
        for (int i = 0; i < 4; ++i) {
            if (i < len && result.length() <= 0 && path.charAt(i) == '/') continue;
            result.append('/');
        }
        result.append(path);
        return result.toString();
    }

    public URI createRelativeURI(File map, File input, int linkType) {
        if (linkType == 0) {
            return null;
        }
        try {
            boolean isUNCmap;
            URI fileUri;
            boolean isUNCinput;
            URI mapUri = null;
            if (map != null) {
                mapUri = map.getAbsoluteFile().toURI();
            }
            if ((isUNCinput = (fileUri = input.getAbsoluteFile().toURI()).getPath().startsWith("//")) != (isUNCmap = mapUri.getPath().startsWith("//"))) {
                return fileUri;
            }
            String filePathAsString = fileUri.getRawPath();
            String mapPathAsString = mapUri.getRawPath();
            int lastIndexOfSeparatorInMapPath = mapPathAsString.lastIndexOf("/");
            int lastIndexOfSeparatorInFilePath = filePathAsString.lastIndexOf("/");
            int lastCommonSeparatorPos = -1;
            for (int differencePos = 0; differencePos <= lastIndexOfSeparatorInMapPath && differencePos <= lastIndexOfSeparatorInFilePath && filePathAsString.charAt(differencePos) == mapPathAsString.charAt(differencePos); ++differencePos) {
                if (filePathAsString.charAt(differencePos) != '/') continue;
                lastCommonSeparatorPos = differencePos;
            }
            if (lastCommonSeparatorPos < 0) {
                return fileUri;
            }
            StringBuilder relativePath = new StringBuilder();
            for (int i = lastCommonSeparatorPos + 1; i <= lastIndexOfSeparatorInMapPath; ++i) {
                if (mapPathAsString.charAt(i) != '/') continue;
                relativePath.append("../");
            }
            relativePath.append(filePathAsString.substring(lastCommonSeparatorPos + 1));
            return new URI(relativePath.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URI createURI(String inputValue) throws URISyntaxException {
        try {
            return new URI(inputValue);
        }
        catch (URISyntaxException e) {
            Matcher mat = patSMB.matcher(inputValue);
            if (mat.matches()) {
                String scheme = "smb";
                String ssp = "//" + mat.group(1) + "/" + mat.group(2).replace('\\', '/');
                String fragment = mat.group(3);
                return new URI("smb", ssp, fragment);
            }
            mat = patFile.matcher(inputValue);
            if (mat.matches()) {
                String ssp = mat.group(1);
                if (File.separatorChar != '/') {
                    ssp = ssp.replace(File.separatorChar, '/');
                }
                String fragment = mat.group(3);
                if (mat.group(2) == null) {
                    return new URI(null, null, ssp, fragment);
                }
                String scheme = "file";
                if (ssp.startsWith("//")) {
                    ssp = "//" + ssp;
                } else if (!ssp.startsWith("/")) {
                    ssp = "/" + ssp;
                }
                return new URI("file", null, ssp, fragment);
            }
            mat = patURI.matcher(inputValue);
            if (mat.matches()) {
                String scheme = mat.group(1);
                String ssp = mat.group(2).replace('\\', '/');
                String fragment = mat.group(3);
                return new URI(scheme, ssp, fragment);
            }
            throw new URISyntaxException(inputValue, "This doesn't look like a valid link (URI, file, SMB or URL).");
        }
    }

    public static String findLink(String text) {
        Matcher urlMatcher = urlPattern.matcher(text);
        if (urlMatcher.find()) {
            String link = urlMatcher.group();
            try {
                new URL(link).toURI();
                return link;
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        Matcher mailMatcher = mailPattern.matcher(text);
        if (mailMatcher.find()) {
            String link = "mailto:" + mailMatcher.group();
            return link;
        }
        return null;
    }

    public static URI createMenuItemLink(String content) {
        return LinkController.createItemLink(MENUITEM_SCHEME, content);
    }

    public static URI createItemLink(String scheme, String content) {
        try {
            return new URI(scheme, "_" + content, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("huh? URI should have escaped illegal characters", e);
        }
    }

    public static boolean isMenuItemLink(URI uri) {
        return LinkController.isSpecialLink(MENUITEM_SCHEME, uri);
    }

    public static boolean isSpecialLink(String requiredScheme, URI uri) {
        String scheme = uri.getScheme();
        return scheme != null && scheme.equals(requiredScheme);
    }

    public static String parseSpecialLink(URI uri) {
        return LinkController.convertPre15VersionStyleKeysToCurrent(uri.getSchemeSpecificPart().substring(1));
    }

    private static String convertPre15VersionStyleKeysToCurrent(String actionKey) {
        return actionKey.startsWith("$") ? actionKey.replaceFirst("\\$(.*)\\$0", "$1") : actionKey;
    }

    public int getStandardConnectorWidth() {
        String standardWidth = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_WIDTH);
        int width = Integer.valueOf(standardWidth);
        return width;
    }

    public void setStandardConnectorWidth(int width) {
        String value = Integer.toString(width);
        ResourceController.getResourceController().setProperty(RESOURCES_CONNECTOR_WIDTH, value);
    }

    public Color getStandardConnectorColor() {
        String standardColor = ResourceController.getResourceController().getProperty(RESOURCES_LINK_COLOR);
        Color color = ColorUtils.stringToColor(standardColor);
        return color;
    }

    public void setStandardConnectorColor(Color color) {
        String value = ColorUtils.colorToString(color);
        ResourceController.getResourceController().setProperty(RESOURCES_LINK_COLOR, value);
    }

    public ConnectorModel.Shape getStandardConnectorShape() {
        String standardShape = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_SHAPE);
        ConnectorModel.Shape shape = ConnectorModel.Shape.valueOf(standardShape);
        return shape;
    }

    public void setStandardConnectorShape(ConnectorModel.Shape shape) {
        String value = shape.toString();
        ResourceController.getResourceController().setProperty(RESOURCES_CONNECTOR_SHAPE, value);
    }

    public int getStandardConnectorAlpha() {
        String standardAlpha = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_COLOR_ALPHA);
        int alpha = Integer.valueOf(standardAlpha);
        return alpha;
    }

    public void setStandardAlpha(int alpha) {
        String value = Integer.toString(alpha);
        ResourceController.getResourceController().setProperty(RESOURCES_CONNECTOR_COLOR_ALPHA, value);
    }

    public int getAlpha(ConnectorModel connectorModel) {
        return connectorModel.getAlpha();
    }

    public int getStandardLabelFontSize() {
        return ResourceController.getResourceController().getIntProperty("label_font_size", 12);
    }

    public String getStandardLabelFontFamily() {
        return ResourceController.getResourceController().getProperty("label_font_family");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getLinkIcon(URI link, NodeModel model) {
        LinkType linkType = LinkController.getLinkType(link, model);
        if (linkType == null) {
            return null;
        }
        if (linkType.equals((Object)LinkType.MENU)) {
            String menuItemKey = LinkController.parseSpecialLink(link);
            HashMap<String, Icon> hashMap = menuItemCache;
            synchronized (hashMap) {
                Icon icon = menuItemCache.get(menuItemKey);
                if (icon == null) {
                    Icon menuItemIcon = MenuUtils.getMenuItemIcon(menuItemKey);
                    icon = menuItemIcon == null ? ICON_STORE.getUIIcon(MENUITEM_ICON).getIcon() : menuItemIcon;
                    menuItemCache.put(menuItemKey, icon);
                }
                return icon;
            }
        }
        if (LinkType.DEFAULT == linkType && this.formatNodeAsHyperlink(model)) {
            return null;
        }
        return linkType.icon;
    }

    public static LinkType getLinkType(URI link, NodeModel model) {
        if (link == null) {
            return null;
        }
        String linkText = link.toString();
        if (linkText.startsWith("#")) {
            String id = linkText.substring(1);
            if (model == null || model.getMap().getNodeForID(id) == null) {
                return null;
            }
            return LinkType.LOCAL;
        }
        if (linkText.startsWith("mailto:")) {
            return LinkType.MAIL;
        }
        if (LinkController.isMenuItemLink(link)) {
            return LinkType.MENU;
        }
        if (LinkController.isSpecialLink(EXECUTE_APP_SCHEME, link) || Compat.isWindowsExecutable(link)) {
            return LinkType.EXECUTABLE;
        }
        return LinkType.DEFAULT;
    }

    public boolean formatNodeAsHyperlink(NodeModel node) {
        String text = node.getText();
        if (text.isEmpty() || HtmlUtils.isHtmlNode(text)) {
            return false;
        }
        Boolean ownFlag = this.ownFormatNodeAsHyperlink(node);
        if (ownFlag != null) {
            return ownFlag;
        }
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node);
        MapStyleModel mapStyles = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            Boolean styleFlag;
            NodeModel styleNode = mapStyles.getStyleNode(styleKey);
            if (styleNode == null || (styleFlag = this.ownFormatNodeAsHyperlink(styleNode)) == null) continue;
            return styleFlag;
        }
        return false;
    }

    private Boolean ownFormatNodeAsHyperlink(NodeModel node) {
        NodeLinks linkModel = NodeLinks.getLinkExtension(node);
        if (linkModel == null) {
            return null;
        }
        Boolean formatNodeAsHyperlink = linkModel.formatNodeAsHyperlink();
        return formatNodeAsHyperlink;
    }

    static /* synthetic */ String access$100() {
        return MAIL_ICON;
    }

    static /* synthetic */ String access$200() {
        return EXECUTABLE_ICON;
    }

    public static enum LinkType {
        LOCAL(LINK_LOCAL_ICON),
        MAIL(LinkController.access$100()),
        EXECUTABLE(LinkController.access$200()),
        MENU("icons/button.png"),
        DEFAULT(LINK_ICON);

        public final Icon icon;

        private LinkType(String iconPath) {
            UIIcon uiIcon = ICON_STORE.getUIIcon(iconPath);
            this.icon = uiIcon == null ? null : uiIcon.getIcon();
        }
    }

    public static final class ClosePopupAction
    extends AbstractAction {
        private final String reason;

        public ClosePopupAction(String reason) {
            this.reason = reason;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent src = (JComponent)e.getSource();
            src.putClientProperty(this.reason, Boolean.TRUE);
            SwingUtilities.getWindowAncestor(src).setVisible(false);
        }
    }

    private class ClonesMenuBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        public ClonesMenuBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        @Override
        public void visit(Entry target) {
            IMapSelection selection = this.modeController.getController().getSelection();
            if (selection == null) {
                return;
            }
            NodeModel node = selection.getSelected();
            boolean firstAction = true;
            NodeModel parentNode = node.getParentNode();
            if (parentNode != null) {
                for (NodeModel clone : node.allClones()) {
                    if (clone.equals(node)) continue;
                    GotoLinkNodeAction gotoLinkNodeAction = new GotoLinkNodeAction(LinkController.this, clone);
                    NodeModel subtreeRootParentNode = clone.getSubtreeRoot().getParentNode();
                    gotoLinkNodeAction.configureText("follow_clone", subtreeRootParentNode);
                    if (firstAction) {
                        target.addChild(new Entry().setBuilders("separator"));
                        firstAction = false;
                    }
                    this.modeController.addActionIfNotAlreadySet(gotoLinkNodeAction);
                    new EntryAccessor().addChildAction(target, gotoLinkNodeAction);
                }
            }
        }

        @Override
        public boolean shouldSkipChildren(Entry entry) {
            return true;
        }
    }

    final class LinkMenuBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        LinkMenuBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        @Override
        public void visit(Entry entry) {
            IMapSelection selection = this.modeController.getController().getSelection();
            if (selection == null) {
                return;
            }
            NodeModel node = selection.getSelected();
            LinkedHashSet<NodeLinkModel> links = new LinkedHashSet<NodeLinkModel>(NodeLinks.getLinks(node));
            links.addAll(LinkController.this.getLinksTo(node));
            boolean firstAction = true;
            for (NodeLinkModel link : links) {
                NodeModel target;
                String targetID = link.getTargetID();
                if (node.getID().equals(targetID)) {
                    ConnectorModel cm;
                    if (!(link instanceof ConnectorModel) || node.equals(target = (cm = (ConnectorModel)link).getSource())) {
                        continue;
                    }
                } else {
                    target = node.getMap().getNodeForID(targetID);
                }
                GotoLinkNodeAction gotoLinkNodeAction = new GotoLinkNodeAction(LinkController.this, target);
                gotoLinkNodeAction.configureText("follow_graphical_link", target);
                if (!(link instanceof ConnectorModel)) {
                    gotoLinkNodeAction.putValue("SmallIcon", ICON_STORE.getUIIcon(LINK_LOCAL_ICON).getIcon());
                }
                if (firstAction) {
                    entry.addChild(new Entry().setBuilders("separator"));
                    firstAction = false;
                }
                this.modeController.addActionIfNotAlreadySet(gotoLinkNodeAction);
                new EntryAccessor().addChildAction(entry, gotoLinkNodeAction);
            }
        }

        @Override
        public boolean shouldSkipChildren(Entry entry) {
            return true;
        }
    }
}

