/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.SmallExtensionMap;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.XmlUtils;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.NodeIconSetModel;

public class SharedNodeData {
    private final ExtensionContainer extensionContainer = new ExtensionContainer(new SmallExtensionMap());
    private HistoryInformationModel historyInformation;
    private final NodeIconSetModel icons = new NodeIconSetModel();
    private Object userObject;
    private String xmlText;
    private boolean folded = false;

    public ExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public HistoryInformationModel getHistoryInformation() {
        return this.historyInformation;
    }

    public void setHistoryInformation(HistoryInformationModel historyInformation) {
        this.historyInformation = historyInformation;
    }

    public NodeIconSetModel getIcons() {
        return this.icons;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object data) {
        if (data instanceof String) {
            this.setText(data.toString());
        } else {
            this.xmlText = null;
            this.userObject = data;
        }
    }

    public String getXmlText() {
        return this.xmlText;
    }

    public void setXmlText(String content) {
        this.xmlText = XmlUtils.makeValidXml(content);
        this.userObject = HtmlUtils.toHtml(this.xmlText);
    }

    public void setText(String text) {
        try {
            this.userObject = XmlUtils.makeValidXml(text);
            this.xmlText = HtmlUtils.toXhtml(text);
            if (this.xmlText != null && !this.xmlText.startsWith("<")) {
                this.userObject = " " + text;
                this.xmlText = null;
            }
        }
        catch (Exception e) {
            this.userObject = " " + text;
            this.xmlText = null;
        }
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    public boolean isFolded() {
        return this.folded;
    }
}

