/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;

public class SummaryLevels {
    public static final int NODE_NOT_FOUND = -1;
    private static final boolean[] BOTH_SIDES = new boolean[]{true, false};
    private static final boolean[] LEFT_SIDE = new boolean[]{true};
    private static final boolean[] RIGHT_SIDE = new boolean[]{false};
    public final int[] summaryLevels;
    public final int highestSummaryLevel;
    public final boolean[] sides;
    private final NodeModel parentNode;

    public SummaryLevels(NodeModel parentNode) {
        this.parentNode = parentNode;
        int highestSummaryLevel = 0;
        int childCount = parentNode.getChildCount();
        this.summaryLevels = new int[childCount];
        for (boolean isLeft : this.sides = SummaryLevels.sidesOf(parentNode)) {
            int level = 1;
            boolean useSummaryAsItem = true;
            for (int i = 0; i < childCount; ++i) {
                boolean isItem;
                NodeModel child = parentNode.getChildAt(i);
                if (child.isLeft() != isLeft) continue;
                boolean bl = isItem = !SummaryNode.isSummaryNode(child) || useSummaryAsItem;
                if (isItem) {
                    if (level > 0) {
                        useSummaryAsItem = true;
                    }
                    level = 0;
                    if (child.hasVisibleContent()) {
                        useSummaryAsItem = false;
                    }
                } else {
                    highestSummaryLevel = Math.max(highestSummaryLevel, ++level);
                }
                this.summaryLevels[i] = level;
            }
        }
        this.highestSummaryLevel = highestSummaryLevel;
    }

    private static boolean[] sidesOf(NodeModel parentNode) {
        return parentNode.isRoot() ? BOTH_SIDES : (parentNode.isLeft() ? LEFT_SIDE : RIGHT_SIDE);
    }

    public Collection<NodeModel> summarizedNodes(NodeModel summaryNode) {
        if (summaryNode.getParentNode() != this.parentNode) {
            return Collections.emptyList();
        }
        int summaryNodeIndex = this.parentNode.getIndex(summaryNode);
        int summaryLevel = this.summaryLevels[summaryNodeIndex];
        if (summaryLevel == 0) {
            return Collections.emptyList();
        }
        ArrayList<NodeModel> arrayList = new ArrayList<NodeModel>();
        for (int i = summaryNodeIndex - 1; i >= 0; --i) {
            int level = this.summaryLevels[i];
            if (level >= summaryLevel) {
                if (this.sides == BOTH_SIDES && this.parentNode.getChildAt(i).isLeft() != summaryNode.isLeft()) continue;
                return arrayList;
            }
            if (level != summaryLevel - 1) continue;
            NodeModel child = this.parentNode.getChildAt(i);
            if (this.sides == BOTH_SIDES && child.isLeft() != summaryNode.isLeft()) continue;
            if (SummaryNode.isFirstGroupNode(child)) {
                if (level > 0) {
                    arrayList.add(child);
                }
                return arrayList;
            }
            arrayList.add(child);
        }
        return arrayList;
    }

    public NodeModel findSummaryNode(int index) {
        int summaryNodeIndex = this.findSummaryNodeIndex(index);
        return this.parentNode.getChildAt(summaryNodeIndex);
    }

    public int findSummaryNodeIndex(int index) {
        int nodeLevel = this.summaryLevels[index];
        boolean leftSide = this.parentNode.getChildAt(index).isLeft();
        for (int i = index + 1; i < this.parentNode.getChildCount(); ++i) {
            NodeModel summaryNode;
            int level = this.summaryLevels[i];
            if (level == nodeLevel && SummaryNode.isFirstGroupNode(this.parentNode.getChildAt(i))) {
                return -1;
            }
            if (level <= nodeLevel || (summaryNode = this.parentNode.getChildAt(i)).isLeft() != leftSide) continue;
            return i;
        }
        return -1;
    }

    public NodeModel findGroupBeginNode(int index) {
        int groupBeginNodeIndex = this.findGroupBeginNodeIndex(index);
        return this.parentNode.getChildAt(groupBeginNodeIndex);
    }

    public int findGroupBeginNodeIndex(int index) {
        int i;
        if (index < 0) {
            return -1;
        }
        int nodeLevel = this.summaryLevels[index];
        boolean leftSide = this.parentNode.getChildAt(index).isLeft();
        for (i = index; i >= 0; --i) {
            int level = this.summaryLevels[i];
            NodeModel groupBeginNode = this.parentNode.getChildAt(i);
            if (groupBeginNode.isLeft() != leftSide) continue;
            if (level > nodeLevel) {
                return this.parentNode.nextNodeIndex(i, leftSide);
            }
            if (level != nodeLevel || !SummaryNode.isFirstGroupNode(groupBeginNode)) continue;
            return i;
        }
        for (i = 0; i <= index; ++i) {
            NodeModel groupBeginNode = this.parentNode.getChildAt(i);
            if (groupBeginNode.isLeft() != leftSide || this.summaryLevels[i] != nodeLevel) continue;
            return i;
        }
        return index;
    }
}

