/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.freeplane.core.ui.components.calendar.JCalendar;
import org.freeplane.features.format.FormattedDate;

public class TimeComboBoxEditor
implements ComboBoxEditor {
    private final List<ActionListener> actionListeners;
    private final JPopupMenu calendarPopupMenu;
    private final JCalendar calenderComponent;
    private FormattedDate date;
    private final JButton showEditorBtn = new JButton();

    public TimeComboBoxEditor(boolean timeVisible) {
        this.showEditorBtn.addActionListener(new ShowCalendarAction());
        this.calenderComponent = new JCalendar(new Date(), Locale.getDefault(), true, true, timeVisible);
        this.calenderComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TimeComboBoxEditor.this.calendarPopupMenu.setVisible(false);
            }
        });
        this.calendarPopupMenu = this.calenderComponent.createPopupMenu();
        this.calendarPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TimeComboBoxEditor.this.calenderComponent.setDate(TimeComboBoxEditor.this.date);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TimeComboBoxEditor.this.updateDate();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.actionListeners = new LinkedList<ActionListener>();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    @Override
    public Component getEditorComponent() {
        return this.showEditorBtn;
    }

    @Override
    public Object getItem() {
        return this.date;
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void setItem(Object date) {
        if (!(date instanceof FormattedDate)) {
            return;
        }
        this.date = (FormattedDate)date;
        this.showEditorBtn.setText(date == null ? "" : date.toString());
    }

    private void updateDate() {
        FormattedDate newDate = new FormattedDate(this.calenderComponent.getDate(), this.calenderComponent.isTimeVisible() ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd");
        String type = newDate.containsTime() ? "datetime" : "date";
        this.date = FormattedDate.createDefaultFormattedDate(newDate.getTime(), type);
        if (this.actionListeners.size() == 0) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(actionEvent);
        }
    }

    public void setItem() {
        this.updateDate();
    }

    private class ShowCalendarAction
    implements ActionListener {
        private ShowCalendarAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TimeComboBoxEditor.this.showEditorBtn.isShowing()) {
                TimeComboBoxEditor.this.calendarPopupMenu.show(TimeComboBoxEditor.this.showEditorBtn, 0, TimeComboBoxEditor.this.showEditorBtn.getHeight());
            }
        }
    }
}

