/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class FreeplaneUriConverter {
    private static final String ENCODED_SPACE = "/%20";
    private static final String ENCODED_FREEPLANE_URI_PREFIX = "freeplane:/%20";
    private static final String INTERNET_EXPLORER_FREEPLANE_URI_PREFIX = "freeplane:/ ";
    private static final String MS_OFFICE_FREEPLANE_URI_PREFIX = "freeplane:// ";
    private static final String[] MICROSOFT_URI_PREFIXES = new String[]{"freeplane:/ ", "freeplane:// "};

    public String freeplaneUriForFile(String fileBasedUri) {
        return ENCODED_FREEPLANE_URI_PREFIX + fileBasedUri.substring("file".length() + 1);
    }

    public URL freeplaneUrl(URI uri) throws MalformedURLException {
        String scheme = uri.getScheme();
        if ("freeplane".equals(scheme)) {
            return new URL("file", uri.getHost(), uri.getPath().substring(2));
        }
        return new URL(scheme, uri.getHost(), uri.getPath());
    }

    public String fixPartiallyDecodedFreeplaneUriComingFromInternetExplorer(String uriCandidate) {
        for (String microsoftPrefix : MICROSOFT_URI_PREFIXES) {
            if (!uriCandidate.startsWith(microsoftPrefix)) continue;
            int referenceStart = uriCandidate.indexOf(35);
            if (referenceStart == -1) {
                referenceStart = uriCandidate.length();
            }
            try {
                String path = uriCandidate.substring(microsoftPrefix.length(), referenceStart);
                URI uri = new URI("freeplane", path, null);
                String encodedPath = uri.getRawPath();
                return ENCODED_FREEPLANE_URI_PREFIX + encodedPath + uriCandidate.substring(referenceStart);
            }
            catch (URISyntaxException e) {
                return uriCandidate;
            }
        }
        return uriCandidate;
    }
}

