/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.headlessmode;

import java.util.Collections;
import java.util.Set;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.FreeplaneGUIStarter;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.headlessmode.HeadlessMModeControllerFactory;
import org.freeplane.main.headlessmode.HeadlessMapViewController;
import org.freeplane.main.headlessmode.HeadlessUIController;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;

public class FreeplaneHeadlessStarter
implements FreeplaneStarter {
    private ApplicationResourceController applicationResourceController = new ApplicationResourceController();

    public void setDontLoadLastMaps() {
    }

    public Controller createController() {
        try {
            Controller controller = new Controller((ResourceController)this.applicationResourceController);
            Controller.setCurrentController(controller);
            this.applicationResourceController.init();
            LogUtils.createLogger();
            FreeplaneGUIStarter.showSysInfo();
            HeadlessMapViewController mapViewController = new HeadlessMapViewController();
            controller.setMapViewManager(mapViewController);
            controller.setViewController(new HeadlessUIController(controller, mapViewController, ""));
            FilterController.install();
            FormatController.install(new FormatController());
            ScannerController scannerController = new ScannerController();
            ScannerController.install(scannerController);
            scannerController.addParsersForStandardFormats();
            ModelessAttributeController.install();
            TextController.install();
            TimeController.install();
            LinkController.install();
            IconController.install();
            HelpController.install();
            FilterController.getCurrentFilterController().getConditionFactory().addConditionController(70, new LogicalStyleFilterController());
            MapController.install();
            NodeHistory.install(controller);
            return controller;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            throw new RuntimeException(e);
        }
    }

    public void createModeControllers(Controller controller) {
        HeadlessMModeControllerFactory.createModeController();
        controller.getModeController("MindMap").getMapController().addMapChangeListener((IMapChangeListener)this.applicationResourceController.getLastOpenedList());
    }

    public void buildMenus(Controller controller, Set<String> plugins) {
    }

    public void createFrame(String[] args) {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController("MindMap");
        controller.selectModeForBuild(modeController);
    }

    public void run(String[] args) {
        try {
            if (null == System.getProperty("org.freeplane.core.dir.lib", null)) {
                System.setProperty("org.freeplane.core.dir.lib", "/lib/");
            }
            Controller controller = this.createController();
            this.createModeControllers(controller);
            FilterController.getController(controller).loadDefaultConditions();
            Set<String> emptySet = Collections.emptySet();
            this.buildMenus(controller, emptySet);
            this.createFrame(args);
        }
        catch (Exception e) {
            LogUtils.severe(e);
            System.exit(1);
        }
    }

    public void stop() {
    }

    public ResourceController getResourceController() {
        return this.applicationResourceController;
    }

    public void loadMapsLater(String[] args) {
    }
}

