/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.ui.INodeViewLifeCycleListener;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.filepreview.BitmapViewerFactory;
import org.freeplane.view.swing.features.filepreview.ExternalImagePopupMenu;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ImagePreview;
import org.freeplane.view.swing.features.filepreview.MExternalImageDropListener;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressIcons;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

@NodeHookDescriptor(hookName="ExternalObject", onceForMap=false)
public class ViewerController
extends PersistentNodeHook
implements INodeViewLifeCycleListener,
IExtension {
    private static final MExternalImageDropListener DTL = new MExternalImageDropListener();
    private static ExternalImagePopupMenu imagePopupMenu;
    private static final int BORDER_SIZE = 1;
    private static final Color BORDER_COLOR;
    static final int VIEWER_POSITION = 5;
    private final MyMouseListener mouseListener = new MyMouseListener();
    private final Set<IViewerFactory> factories = new HashSet<IViewerFactory>();

    public ViewerController() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addINodeViewLifeCycleListener(this);
        modeController.addExtension(this.getClass(), this);
        this.factories.add(new BitmapViewerFactory());
    }

    @Override
    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    public void setZoom(final ModeController modeController, final MapModel map, final ExternalResource model, final float size) {
        final float oldSize = model.getZoom();
        if (size == oldSize) {
            return;
        }
        IActor actor = new IActor(){

            @Override
            public void act() {
                model.setZoom(size);
                modeController.getMapController().setSaved(map, false);
            }

            @Override
            public String getDescription() {
                return "setModelSize";
            }

            @Override
            public void undo() {
                model.setZoom(oldSize);
                modeController.getMapController().setSaved(map, false);
            }
        };
        modeController.execute(actor, map);
    }

    @Override
    protected void add(NodeModel node, IExtension extension) {
        ExternalResource preview = (ExternalResource)extension;
        for (NodeModel nodeClone : node.allClones()) {
            for (INodeView iNodeView : nodeClone.getViewers()) {
                NodeView view = (NodeView)iNodeView;
                this.createViewer(preview, view);
            }
        }
        super.add(node, extension);
    }

    @Override
    protected IExtension createExtension(NodeModel node) {
        URI uri = this.createURI(node);
        if (uri == null) {
            return null;
        }
        File input = new File(uri.getPath());
        ExternalResource preview = new ExternalResource(uri);
        ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)input.getName());
        return preview;
    }

    protected URI createURI(NodeModel node) {
        FileFilter fileFilter;
        Controller controller = Controller.getCurrentController();
        ViewController viewController = controller.getViewController();
        MapModel map = node.getMap();
        File file = map.getFile();
        boolean useRelativeUri = ResourceController.getResourceController().getProperty("links").equals("relative");
        if (file == null && useRelativeUri) {
            JOptionPane.showMessageDialog(viewController.getCurrentRootComponent(), TextUtils.getText("not_saved_for_image_error"), "Freeplane", 2);
            return null;
        }
        UrlManager urlManager = controller.getModeController().getExtension(UrlManager.class);
        JFileChooser chooser = urlManager.getFileChooser(null, false);
        chooser.setAcceptAllFileFilterUsed(false);
        if (this.factories.size() > 1) {
            fileFilter = this.getCombiFileFilter();
            chooser.addChoosableFileFilter(fileFilter);
            for (IViewerFactory factory : this.factories) {
                chooser.addChoosableFileFilter(new FactoryFileFilter(factory));
            }
        } else {
            fileFilter = new FactoryFileFilter(this.factories.iterator().next());
        }
        chooser.setFileFilter(fileFilter);
        chooser.putClientProperty(FactoryFileFilter.class, fileFilter);
        chooser.setAccessory(new ImagePreview(chooser));
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent());
        if (returnVal != 0) {
            return null;
        }
        File input = chooser.getSelectedFile();
        if (input == null) {
            return null;
        }
        URI uri = this.uriOf(input);
        if (uri == null) {
            return null;
        }
        if (useRelativeUri && uri.getScheme().equals("file")) {
            uri = LinkController.toLinkTypeDependantURI(map.getFile(), input);
        }
        return uri;
    }

    private URI uriOf(File input) {
        String path = input.getPath();
        try {
            for (String protocol : new String[]{"http:" + File.separatorChar, "https:" + File.separatorChar}) {
                int uriStart = path.indexOf(protocol);
                if (uriStart == -1) continue;
                return new URI(protocol.substring(0, protocol.length() - 1) + "//" + path.substring(uriStart + protocol.length()).replace('\\', '/'));
            }
        }
        catch (URISyntaxException e) {
            LogUtils.warn(e);
        }
        return input.toURI();
    }

    private IViewerFactory getViewerFactory(URI uri) {
        for (IViewerFactory factory : this.factories) {
            if (!factory.accept(uri)) continue;
            return factory;
        }
        return null;
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        try {
            String attrUri = element.getAttribute("URI", null);
            if (attrUri != null) {
                URI uri = new URI(attrUri);
                ExternalResource previewUrl = new ExternalResource(uri);
                String attrSize = element.getAttribute("SIZE", null);
                if (attrSize != null) {
                    float size = Float.parseFloat(attrSize);
                    previewUrl.setZoom(size);
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
                return previewUrl;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    void createViewer(ExternalResource model, NodeView view) {
        JComponent viewer = this.createViewer(view.getMap().getModel(), model);
        if (imagePopupMenu == null) {
            imagePopupMenu = new ExternalImagePopupMenu();
        }
        viewer.setBorder(new MatteBorder(1, 1, 1, 1, BORDER_COLOR));
        Set<NodeView> viewers = model.getViewers();
        viewers.add(view);
        viewer.setBounds(viewer.getX() - 5, viewer.getY() - 5, viewer.getWidth() + 15, viewer.getHeight() + 15);
        view.addContent(viewer, 5);
        if (view.getMap().getModeController().canEdit()) {
            DropTarget dropTarget = new DropTarget(viewer, DTL);
            dropTarget.setActive(true);
        }
        if (view.isShortened()) {
            viewer.setVisible(false);
        } else {
            viewer.revalidate();
            viewer.repaint();
        }
    }

    void deleteViewer(ExternalResource model, NodeView nodeView) {
        Set<NodeView> viewers = model.getViewers();
        if (!viewers.contains(nodeView)) {
            return;
        }
        nodeView.removeContent(5);
        viewers.remove(nodeView);
    }

    protected Class<ExternalResource> getExtensionClass() {
        return ExternalResource.class;
    }

    @Override
    public void onViewCreated(Container container) {
        NodeView nodeView = (NodeView)container;
        ExternalResource previewUri = nodeView.getModel().getExtension(ExternalResource.class);
        if (previewUri == null) {
            return;
        }
        this.createViewer(previewUri, nodeView);
    }

    @Override
    public void onViewRemoved(Container container) {
        NodeView nodeView = (NodeView)container;
        ExternalResource previewUri = nodeView.getModel().getExtension(ExternalResource.class);
        if (previewUri == null) {
            return;
        }
        this.deleteViewer(previewUri, nodeView);
    }

    @Override
    protected void remove(NodeModel node, IExtension extension) {
        ExternalResource resource = (ExternalResource)extension;
        resource.removeViewers();
        super.remove(node, extension);
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        float size;
        ExternalResource previewUri = (ExternalResource)extension;
        URI uri = previewUri.getUri();
        if (uri != null) {
            element.setAttribute("URI", uri.toString());
        }
        if ((size = previewUri.getZoom()) != -1.0f) {
            element.setAttribute("SIZE", Float.toString(size));
        }
        super.saveExtension(extension, element);
    }

    private JComponent createViewer(MapModel map, ExternalResource model) {
        URI uri = model.getUri();
        if (uri == null) {
            return new JLabel("no file set");
        }
        URI absoluteUri = model.getAbsoluteUri(map);
        if (absoluteUri == null) {
            return new JLabel(uri.toString());
        }
        IViewerFactory factory = this.getViewerFactory(absoluteUri);
        if (factory == null) {
            return new JLabel(uri.toString());
        }
        JComponent viewer = null;
        try {
            int maxWidth = ResourceController.getResourceController().getIntProperty("max_image_width");
            viewer = (JComponent)((Object)factory.createViewer(model, absoluteUri, maxWidth));
        }
        catch (Exception e) {
            String info = HtmlUtils.combineTextWithExceptionInfo(uri.toString(), e);
            return new JLabel(info);
        }
        if (viewer == null) {
            return new JLabel(uri.toString());
        }
        viewer.putClientProperty(IViewerFactory.class, factory);
        viewer.putClientProperty(ExternalResource.class, model);
        viewer.addMouseListener(this.mouseListener);
        viewer.addMouseMotionListener(this.mouseListener);
        return viewer;
    }

    private FileFilter getCombiFileFilter() {
        return new FactoryFileFilter(new CombiFactory());
    }

    public void addFactory(IViewerFactory factory) {
        this.factories.add(factory);
    }

    public void removeFactory(IViewerFactory factory) {
        this.factories.remove(factory);
    }

    public boolean paste(URI uri, NodeModel node) {
        if (uri == null || this.getViewerFactory(uri) == null) {
            return false;
        }
        ExternalResource preview = new ExternalResource(uri);
        this.undoableDeactivateHook(node);
        this.undoableActivateHook(node, preview);
        ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)uri.getPath());
        return true;
    }

    public boolean paste(URI uri, NodeModel node, boolean isLeft) {
        return this.pasteImage(uri, node, PasteMode.INSIDE, isLeft);
    }

    public boolean paste(File file, NodeModel targetNode, PasteMode mode, boolean isLeft) {
        URI uri = this.uriOf(file);
        return this.pasteImage(uri, targetNode, mode, isLeft);
    }

    public boolean pasteImage(URI uri, NodeModel targetNode, PasteMode mode, boolean isLeft) {
        NodeModel node;
        if (uri == null || this.getViewerFactory(uri) == null) {
            return false;
        }
        File file = new File(uri.getPath());
        boolean isFile = uri.getScheme().equals("file");
        if (isFile) {
            if (!file.exists()) {
                return false;
            }
            File mapFile = targetNode.getMap().getFile();
            if (mapFile == null && LinkController.getLinkType() == 1) {
                JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), TextUtils.getText("not_saved_for_image_error"), "Freeplane", 2);
                return false;
            }
            if (LinkController.getLinkType() != 0) {
                uri = LinkController.toLinkTypeDependantURI(mapFile, file);
            }
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (mode.equals((Object)PasteMode.INSIDE)) {
            node = targetNode;
        } else {
            node = mapController.newNode((Object)file.getName(), targetNode.getMap());
            mapController.insertNode(node, targetNode, mode.equals((Object)PasteMode.AS_SIBLING), isLeft, isLeft);
        }
        ExternalResource preview = new ExternalResource(uri);
        this.undoableDeactivateHook(node);
        this.undoableActivateHook(node, preview);
        ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)file.getName());
        return true;
    }

    public IViewerFactory getCombiFactory() {
        return new CombiFactory();
    }

    static {
        BORDER_COLOR = Color.BLACK;
    }

    public static enum PasteMode {
        AS_SIBLING,
        AS_CHILD,
        INSIDE;


        public static PasteMode valueOf(boolean asSibling) {
            return asSibling ? AS_SIBLING : AS_CHILD;
        }
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        private boolean isActive = false;
        private boolean sizeChanged = false;

        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.resetSize(e)) {
                return;
            }
            if (this.showNext(e)) {
                return;
            }
        }

        private boolean resetSize(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return false;
            }
            JComponent viewer = (JComponent)e.getComponent();
            int x = e.getX();
            int width = viewer.getWidth();
            int y = e.getY();
            int height = viewer.getHeight();
            if (x < width - 4 || y < height - 4) {
                return false;
            }
            IViewerFactory factory = (IViewerFactory)viewer.getClientProperty(IViewerFactory.class);
            if (factory == null) {
                return true;
            }
            MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, viewer);
            ViewerController.this.setZoom(mapView.getModeController(), mapView.getModel(), (ExternalResource)viewer.getClientProperty(ExternalResource.class), 1.0f);
            this.sizeChanged = false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean showNext(MouseEvent e) {
            int i;
            String sActUri;
            NodeModel node;
            ExternalResource activeView;
            block12: {
                MapModel map;
                URI absoluteUri;
                JComponent component = (JComponent)e.getComponent();
                int cursorType = component.getCursor().getType();
                if (e.getClickCount() != 2 || e.getButton() != 1 || cursorType == 5) {
                    return false;
                }
                activeView = this.getModel(e);
                node = null;
                for (int i2 = 0; i2 < e.getComponent().getParent().getComponentCount(); ++i2) {
                    if (!(e.getComponent().getParent().getComponent(i2) instanceof MainView)) continue;
                    MainView mv = (MainView)e.getComponent().getParent().getComponent(i2);
                    node = mv.getNodeView().getModel();
                    break;
                }
                if (node == null) {
                    node = Controller.getCurrentModeController().getMapController().getSelectedNode();
                }
                if ((absoluteUri = activeView.getAbsoluteUri(map = node.getMap())) == null) {
                    return false;
                }
                sActUri = absoluteUri.toString();
                if (!sActUri.matches(".*_[0-9]{2}\\.[a-zA-Z0-9]*")) {
                    return false;
                }
                i = Integer.parseInt(sActUri.substring(sActUri.lastIndexOf("_") + 1, sActUri.lastIndexOf("_") + 3));
                if (e.isControlDown()) {
                    if (i > 0) {
                        --i;
                        break block12;
                    } else {
                        if (activeView.getUri().toString().matches(".*[Pp]rogress_(tenth|quarter)_[0-9]{2}\\.[a-zA-Z0-9]*")) {
                            ProgressIcons.removeProgressIcons((NodeModel)node);
                        }
                        ViewerController.this.remove(node, activeView);
                        Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeModel.UNKNOWN_PROPERTY, null, null);
                        return true;
                    }
                }
                ++i;
            }
            String sNextNum = i < 10 ? "0" + Integer.toString(i) : Integer.toString(i);
            URI nextUri = null;
            try {
                nextUri = new URI(sActUri.replaceFirst("_[0-9]{2}\\.", "_" + sNextNum + "."));
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            String sNextURI = nextUri.getPath();
            if (sNextURI.contains("_tenth_") && i > 10 || sNextURI.contains("_quarter_") && i > 4) {
                return false;
            }
            ExternalResource nextView = new ExternalResource(nextUri);
            nextView.setZoom(activeView.getZoom());
            ViewerController.this.remove(node, activeView);
            ViewerController.this.add(node, nextView);
            ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)sNextURI);
            return true;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.isActive) {
                return;
            }
            ExternalResource model = this.getModel(e);
            if (model == null) {
                return;
            }
            Controller.getCurrentController().getViewController().out(model.getUri().toString());
            this.setCursor(e);
        }

        private ExternalResource getModel(MouseEvent e) {
            JComponent component = (JComponent)e.getComponent();
            ExternalResource model = (ExternalResource)component.getClientProperty(ExternalResource.class);
            return model;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.isActive) {
                return;
            }
            this.setCursor(e);
        }

        private void setCursor(MouseEvent e) {
            Component component = e.getComponent();
            int x = e.getX();
            int width = component.getWidth();
            int y = e.getY();
            int height = component.getHeight();
            int cursorType = width - 6 <= x && x <= width && height - 6 <= y && y <= height ? 5 : 0;
            Cursor cursor = component.getCursor();
            if (cursor.getType() != cursorType) {
                Cursor predefinedCursor = cursorType == 0 ? null : Cursor.getPredefinedCursor(cursorType);
                component.setCursor(predefinedCursor);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JComponent component = (JComponent)e.getComponent();
            int cursorType = component.getCursor().getType();
            if (cursorType == 5) {
                IViewerFactory factory = (IViewerFactory)component.getClientProperty(IViewerFactory.class);
                if (factory == null) {
                    return;
                }
                this.isActive = true;
                return;
            }
            imagePopupMenu.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.sizeChanged) {
                JComponent component = (JComponent)e.getComponent();
                int x = component.getWidth();
                int y = component.getHeight();
                double r = Math.sqrt(x * x + y * y);
                Dimension originalSize = ((ScalableComponent)((Object)component)).getOriginalSize();
                int w = originalSize.width;
                int h = originalSize.height;
                double r0 = Math.sqrt(w * w + h * h);
                MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
                float zoom = mapView.getZoom();
                float modelSize = (float)(r / r0 / (double)zoom);
                ViewerController.this.setZoom(mapView.getModeController(), mapView.getModel(), (ExternalResource)component.getClientProperty(ExternalResource.class), modelSize);
                this.sizeChanged = false;
            } else {
                imagePopupMenu.maybeShowPopup(e);
            }
            this.isActive = false;
            this.setCursor(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.isActive) {
                return;
            }
            this.setSize(e);
        }

        private boolean setSize(MouseEvent e) {
            if (!this.isActive) {
                return false;
            }
            JComponent component = (JComponent)e.getComponent();
            int cursorType = component.getCursor().getType();
            this.sizeChanged = true;
            switch (cursorType) {
                case 5: {
                    Dimension minimumSize = new Dimension(10, 10);
                    int x = e.getX() - 4;
                    int y = e.getY() - 4;
                    if (x <= 0 || y <= 0) {
                        return true;
                    }
                    double r = Math.sqrt(x * x + y * y);
                    Dimension preferredSize = ((ScalableComponent)((Object)component)).getOriginalSize();
                    int width = preferredSize.width;
                    int height = preferredSize.height;
                    double r0 = Math.sqrt(width * width + height * height);
                    x = (int)((double)width * r / r0);
                    y = (int)((double)height * r / r0);
                    MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
                    if (x < mapView.getZoomed(minimumSize.width) || y < mapView.getZoomed(minimumSize.height)) {
                        return true;
                    }
                    Dimension size = new Dimension(x, y);
                    ((ScalableComponent)((Object)component)).setDraftViewerSize(size);
                    component.revalidate();
                    break;
                }
            }
            return true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isActive) {
                return;
            }
            this.setCursor(e);
        }
    }

    static final class FactoryFileFilter
    extends FileFilter {
        private final IViewerFactory factory;

        protected IViewerFactory getFactory() {
            return this.factory;
        }

        private FactoryFileFilter(IViewerFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.factory.accept(f.toURI());
        }

        @Override
        public String getDescription() {
            return this.factory.getDescription();
        }
    }

    private final class CombiFactory
    implements IViewerFactory {
        private IViewerFactory factory;

        private CombiFactory() {
        }

        @Override
        public ScalableComponent createViewer(URI uri, Dimension preferredSize) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(uri);
            ScalableComponent component = this.factory == null ? null : this.factory.createViewer(uri, preferredSize);
            return component;
        }

        @Override
        public ScalableComponent createViewer(ExternalResource resource, URI absoluteUri, int maximumWidth) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(absoluteUri);
            ScalableComponent component = this.factory.createViewer(resource, absoluteUri, maximumWidth);
            return component;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            for (IViewerFactory factory : ViewerController.this.factories) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(factory.getDescription());
            }
            return sb.toString();
        }

        @Override
        public boolean accept(URI uri) {
            return ViewerController.this.getViewerFactory(uri) != null;
        }

        @Override
        public ScalableComponent createViewer(URI uri, float zoom) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(uri);
            ScalableComponent component = this.factory == null ? null : this.factory.createViewer(uri, zoom);
            return component;
        }
    }
}

