/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.ColoredIconCreator;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.view.swing.map.ArrowIcon;
import org.freeplane.view.swing.map.BubbleMainView;
import org.freeplane.view.swing.map.ContentPane;
import org.freeplane.view.swing.map.DetailsView;
import org.freeplane.view.swing.map.ForkMainView;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NarrowHexagonMainView;
import org.freeplane.view.swing.map.NodeTooltipManager;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NoteViewMouseListener;
import org.freeplane.view.swing.map.OvalMainView;
import org.freeplane.view.swing.map.RectangleMainView;
import org.freeplane.view.swing.map.SelectableLayout;
import org.freeplane.view.swing.map.WideHexagonMainView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;
import org.freeplane.view.swing.ui.DetailsViewMouseListener;

class NodeViewFactory {
    private static NodeViewFactory factory;
    private final Icon coloredIcon = this.createColoredIcon();
    private static final IMouseListener DETAILS_MOUSE_LISTENER;
    private static final IMouseListener NOTE_MOUSE_LISTENER;
    static ColoredIconCreator coloredIconCreator;

    static NodeViewFactory getInstance() {
        if (factory == null) {
            factory = new NodeViewFactory();
        }
        return factory;
    }

    private NodeViewFactory() {
    }

    private void fireNodeViewCreated(NodeView newView) {
        newView.getMap().getModeController().onViewCreated(newView);
    }

    JComponent newContentPane(NodeView view) {
        return new ContentPane();
    }

    MainView newMainView(NodeView node) {
        MainView view;
        ShapeConfigurationModel shapeConfiguration = this.shapeConfiguration(node);
        MainView oldView = node.getMainView();
        if (oldView != null && oldView.getShapeConfiguration().equals(shapeConfiguration)) {
            return oldView;
        }
        ModeController modeController = node.getMap().getModeController();
        switch (shapeConfiguration.getShape()) {
            case fork: {
                view = new ForkMainView();
                break;
            }
            case bubble: {
                view = new BubbleMainView(shapeConfiguration);
                break;
            }
            case oval: {
                view = new OvalMainView(shapeConfiguration);
                break;
            }
            case rectangle: {
                view = new RectangleMainView(shapeConfiguration);
                break;
            }
            case wide_hexagon: {
                view = new WideHexagonMainView(shapeConfiguration);
                break;
            }
            case narrow_hexagon: {
                view = new NarrowHexagonMainView(shapeConfiguration);
                break;
            }
            default: {
                System.err.println("Tried to create a NodeView of unknown Style " + String.valueOf((Object)shapeConfiguration.getShape()));
                view = new ForkMainView();
            }
        }
        NodeTooltipManager toolTipManager = NodeTooltipManager.getSharedInstance(modeController);
        toolTipManager.registerComponent(view);
        return view;
    }

    private ShapeConfigurationModel shapeConfiguration(NodeView node) {
        ModeController modeController = node.getMap().getModeController();
        NodeModel model = node.getModel();
        ShapeConfigurationModel shapeConfiguration = NodeStyleController.getController(modeController).getShapeConfiguration(model);
        if (shapeConfiguration.getShape().equals((Object)NodeStyleModel.Shape.combined)) {
            shapeConfiguration = node.isFolded() ? shapeConfiguration.withShape(NodeStyleModel.Shape.bubble) : ShapeConfigurationModel.FORK;
        } else {
            while (shapeConfiguration.getShape().equals((Object)NodeStyleModel.Shape.as_parent)) {
                NodeView parent = node.getParentView();
                if (parent == null) {
                    shapeConfiguration = ShapeConfigurationModel.DEFAULT_ROOT_OVAL;
                    continue;
                }
                if (parent.getParentView() == null) {
                    shapeConfiguration = ShapeConfigurationModel.FORK;
                    continue;
                }
                shapeConfiguration = parent.getMainView().getShapeConfiguration();
            }
        }
        return shapeConfiguration;
    }

    NodeView newNodeView(NodeModel model, MapView map, Container parent, int index) {
        NodeView newView = new NodeView(model, map, parent);
        parent.add((Component)newView, index);
        newView.setMainView(this.newMainView(newView));
        if (map.isDisplayable()) {
            this.updateNewView(newView);
        } else {
            newView.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    NodeView view = (NodeView)e.getComponent();
                    if (this.displayed(view, e)) {
                        view.removeHierarchyListener(this);
                        NodeViewFactory.this.updateNewView(view);
                    } else if (this.removed(view, e)) {
                        view.removeHierarchyListener(this);
                    }
                }

                private boolean removed(NodeView view, HierarchyEvent e) {
                    return 0L != (e.getChangeFlags() & 1L) && view.getParent() == null;
                }

                private boolean displayed(NodeView view, HierarchyEvent e) {
                    return 0L != (e.getChangeFlags() & 2L) && view.isDisplayable();
                }
            });
        }
        return newView;
    }

    private void updateNewView(NodeView newView) {
        newView.getModel().addViewer(newView);
        newView.setLayout(SelectableLayout.getInstance());
        newView.update();
        this.fireNodeViewCreated(newView);
        newView.addChildViews();
    }

    public ZoomableLabel createNoteViewer() {
        ZoomableLabel label = new ZoomableLabel();
        label.addMouseListener(NOTE_MOUSE_LISTENER);
        label.addMouseMotionListener(NOTE_MOUSE_LISTENER);
        label.setIcon(this.coloredIcon);
        label.setVerticalTextPosition(1);
        return label;
    }

    private Icon createColoredIcon() {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, c);
                if (nodeView == null) {
                    return;
                }
                Color iconColor = nodeView.getEdgeColor();
                coloredIconCreator.createColoredIcon(iconColor).paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return coloredIconCreator.createColoredIcon(Color.BLACK).getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return coloredIconCreator.createColoredIcon(Color.BLACK).getIconHeight();
            }
        };
    }

    void updateNoteViewer(NodeView nodeView, int minNodeWidth, int maxNodeWidth) {
        ZoomableLabel view;
        NodeModel model;
        NoteModel extension;
        ZoomableLabel note = (ZoomableLabel)nodeView.getContent(10);
        String oldText = note != null ? note.getText() : null;
        String newText = null;
        if (nodeView.getMap().showNotes() && (extension = NoteModel.getNote(model = nodeView.getModel())) != null) {
            newText = extension.getHtml();
        }
        if (oldText == null && newText == null) {
            return;
        }
        if (oldText != null && newText != null) {
            view = (ZoomableLabel)nodeView.getContent(10);
        } else if (oldText == null && newText != null) {
            view = NodeViewFactory.getInstance().createNoteViewer();
            nodeView.addContent(view, 10);
        } else {
            assert (oldText != null && newText == null);
            nodeView.removeContent(10);
            return;
        }
        MapView map = nodeView.getMap();
        view.setFont(map.getNoteFont());
        view.setForeground(map.getNoteForeground());
        view.setBackground(map.getNoteBackground());
        view.setHorizontalAlignment(map.getNoteHorizontalAlignment());
        view.updateText(newText);
        view.setMinimumWidth(minNodeWidth);
        view.setMaximumWidth(maxNodeWidth);
        view.revalidate();
        map.repaint();
    }

    void updateDetails(NodeView nodeView, int minNodeWidth, int maxNodeWidth) {
        DetailTextModel detailText = DetailTextModel.getDetailText(nodeView.getModel());
        if (detailText == null) {
            nodeView.removeContent(2);
            return;
        }
        DetailsView detailContent = (DetailsView)nodeView.getContent(2);
        if (detailContent == null) {
            detailContent = this.createDetailView();
            nodeView.addContent(detailContent, 2);
        }
        MapView map = nodeView.getMap();
        if (detailText.isHidden()) {
            ArrowIcon icon = new ArrowIcon(nodeView, true);
            detailContent.setIcon(icon);
            detailContent.setBackground(null);
            detailContent.updateText("");
        } else {
            detailContent.setFont(map.getDetailFont());
            detailContent.setHorizontalAlignment(map.getDetailHorizontalAlignment());
            detailContent.setIcon(new ArrowIcon(nodeView, false));
            detailContent.updateText(detailText.getHtml());
            detailContent.setForeground(map.getDetailForeground());
            detailContent.setBackground(map.getDetailBackground());
        }
        detailContent.setMinimumWidth(minNodeWidth);
        detailContent.setMaximumWidth(maxNodeWidth);
        detailContent.revalidate();
        map.repaint();
    }

    private DetailsView createDetailView() {
        DetailsView detailContent = new DetailsView();
        DefaultMapMouseListener mouseListener = new DefaultMapMouseListener();
        detailContent.addMouseMotionListener(mouseListener);
        detailContent.addMouseMotionListener(DETAILS_MOUSE_LISTENER);
        detailContent.addMouseListener(DETAILS_MOUSE_LISTENER);
        return detailContent;
    }

    static {
        DETAILS_MOUSE_LISTENER = new DetailsViewMouseListener();
        NOTE_MOUSE_LISTENER = new NoteViewMouseListener();
        coloredIconCreator = new ColoredIconCreator(NoteController.bwNoteIconUrl, Color.BLACK);
    }
}

