/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

public abstract class ShapedMainView
extends MainView {
    private final ShapeConfigurationModel shapeConfiguration;

    public ShapedMainView(ShapeConfigurationModel shapeConfiguration) {
        this.shapeConfiguration = shapeConfiguration;
    }

    @Override
    public ShapeConfigurationModel getShapeConfiguration() {
        return this.shapeConfiguration;
    }

    @Override
    public Point getLeftPoint() {
        Point in = new Point(0, this.getHeight() / 2);
        return in;
    }

    @Override
    public Point getRightPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() - 1;
        return in;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        if (nodeView.getModel() == null) {
            return;
        }
        ModeController modeController = this.getNodeView().getMap().getModeController();
        Object renderingHint = modeController.getController().getMapViewManager().setEdgesRenderingHint(g);
        this.paintBackgound(g);
        this.paintDragOver(g);
        Color edgeColor = nodeView.getEdgeColor();
        g.setColor(edgeColor);
        g.setStroke(MainView.DEF_STROKE);
        this.paintNodeShape(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        super.paintComponent(g);
    }

    protected abstract void paintNodeShape(Graphics2D var1);
}

