/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CollisionDetector {
    private static final int MAXIMAL_RECTANGLE_SIZE_FOR_COLLISION_DETECTION = 16;

    public boolean detectCollision(Point p, Shape shape) {
        Rectangle2D rec = this.getControlRectangle(p);
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform(), 4.0);
        double[] lastCoords = new double[6];
        pathIterator.currentSegment(lastCoords);
        while (true) {
            double h;
            double w;
            double y;
            pathIterator.next();
            double[] nextCoords = new double[6];
            if (pathIterator.isDone() || 4 == pathIterator.currentSegment(nextCoords)) break;
            double x = Math.min(lastCoords[0], nextCoords[0]) - 1.0;
            if (rec.intersects(x, y = Math.min(lastCoords[1], nextCoords[1]) - 1.0, w = Math.abs(lastCoords[0] - nextCoords[0]) + 2.0, h = Math.abs(lastCoords[1] - nextCoords[1]) + 2.0)) {
                return true;
            }
            lastCoords = nextCoords;
        }
        return false;
    }

    private Rectangle2D getControlRectangle(Point2D p) {
        int side = 16;
        return new Rectangle2D.Double(p.getX() - 8.0, p.getY() - 8.0, 16.0, 16.0);
    }
}

