/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngineFactory;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.FreeplaneScriptBaseClass;
import org.freeplane.plugin.script.GenericScript;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;

class ScriptingConfiguration {
    private static final ExecuteScriptAction.ExecutionMode DEFAULT_EXECUTION_MODE = ExecuteScriptAction.ExecutionMode.ON_SELECTED_NODE;
    private static final String JAR_REGEX = ".+\\.jar$";
    private final TreeMap<String, String> menuTitleToPathMap = new TreeMap();
    private final TreeMap<String, ScriptMetaData> menuTitleToMetaDataMap = new TreeMap();
    private List<IScript> initScripts;
    private static Map<String, Object> staticProperties = ScriptingConfiguration.createStaticProperties();

    ScriptingConfiguration() {
        ScriptResources.setClasspath(this.buildClasspath());
        this.addPluginDefaults();
        this.initMenuTitleToPathMap();
    }

    private void addPluginDefaults() {
        URL defaults = this.getClass().getResource("defaults.properties");
        if (defaults == null) {
            throw new RuntimeException("cannot open defaults.properties");
        }
        Controller.getCurrentController().getResourceController().addDefaults(defaults);
    }

    private void initMenuTitleToPathMap() {
        Map<File, ScriptAddOnProperties.Script> addOnScriptMap = this.createAddOnScriptMap();
        this.addAddOnScripts(addOnScriptMap);
        this.addNonAddOnScripts(addOnScriptMap);
    }

    private void addAddOnScripts(Map<File, ScriptAddOnProperties.Script> addOnScriptMap) {
        for (File file : addOnScriptMap.keySet()) {
            this.addScript(file, addOnScriptMap);
        }
    }

    private void addNonAddOnScripts(Map<File, ScriptAddOnProperties.Script> addOnScriptMap) {
        FilenameFilter scriptFilenameFilter = this.createFilenameFilter(this.createScriptRegExp());
        for (File dir : this.getScriptDirs()) {
            this.addNonAddOnScripts(dir, addOnScriptMap, scriptFilenameFilter);
        }
        this.initScripts = this.findInitScripts(scriptFilenameFilter);
    }

    private List<IScript> findInitScripts(FilenameFilter scriptFilenameFilter) {
        ArrayList<IScript> initScripts = new ArrayList<IScript>(0);
        if (ScriptResources.getInitScriptsDir().isDirectory()) {
            File[] list;
            ScriptingPermissions standardPermissions = null;
            for (File file : list = ScriptResources.getInitScriptsDir().listFiles(scriptFilenameFilter)) {
                initScripts.add(ScriptingEngine.createScriptForFile(file, standardPermissions));
            }
        }
        return initScripts;
    }

    private Map<File, ScriptAddOnProperties.Script> createAddOnScriptMap() {
        LinkedHashMap<File, ScriptAddOnProperties.Script> result = new LinkedHashMap<File, ScriptAddOnProperties.Script>();
        for (ScriptAddOnProperties scriptAddOnProperties : this.getInstalledScriptAddOns()) {
            List<ScriptAddOnProperties.Script> scripts = scriptAddOnProperties.getScripts();
            for (ScriptAddOnProperties.Script script : scripts) {
                script.active = scriptAddOnProperties.isActive();
                result.put(this.findScriptFile(scriptAddOnProperties, script), script);
            }
        }
        return result;
    }

    private List<ScriptAddOnProperties> getInstalledScriptAddOns() {
        ArrayList<ScriptAddOnProperties> installedAddOns = new ArrayList<ScriptAddOnProperties>();
        for (AddOnProperties addOnProperties : AddOnsController.getController().getInstalledAddOns()) {
            if (addOnProperties.getAddOnType() != AddOnProperties.AddOnType.SCRIPT) continue;
            installedAddOns.add((ScriptAddOnProperties)addOnProperties);
        }
        return installedAddOns;
    }

    private File findScriptFile(AddOnProperties addOnProperties, ScriptAddOnProperties.Script script) {
        File dir = new File(this.getPrivateAddOnDirectory(addOnProperties), "scripts");
        File result = new File(dir, script.name);
        return result.exists() ? result : this.findScriptFile_pre_1_3_x_final(script);
    }

    private File getPrivateAddOnDirectory(AddOnProperties addOnProperties) {
        return new File(AddOnsController.getController().getAddOnsDir(), addOnProperties.getName());
    }

    @Deprecated
    private File findScriptFile_pre_1_3_x_final(ScriptAddOnProperties.Script script) {
        return new File(ScriptResources.getUserScriptsDir(), script.name);
    }

    private TreeSet<File> getScriptDirs() {
        ResourceController resourceController = ResourceController.getResourceController();
        String dirsString = resourceController.getProperty("script_directories");
        TreeSet<File> dirs = new TreeSet<File>();
        if (dirsString != null) {
            for (String dir : ConfigurationUtils.decodeListValue((String)dirsString, (boolean)false)) {
                dirs.add(this.createFile(dir));
            }
        }
        dirs.add(ScriptResources.getBuiltinScriptsDir());
        dirs.add(ScriptResources.getUserScriptsDir());
        return dirs;
    }

    private File createFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), path);
        }
        return file;
    }

    private void addNonAddOnScripts(File dir, Map<File, ScriptAddOnProperties.Script> addOnScriptMap, FilenameFilter filenameFilter) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(filenameFilter);
            if (files != null) {
                for (File file : files) {
                    if (addOnScriptMap.get(file) != null) continue;
                    this.addScript(file, addOnScriptMap);
                }
            }
        } else {
            LogUtils.warn((String)("not a (script) directory: " + dir));
        }
    }

    private String createScriptRegExp() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (ScriptEngineFactory scriptEngineFactory : GenericScript.createScriptEngineFactories()) {
            extensions.addAll(scriptEngineFactory.getExtensions());
        }
        LogUtils.info((String)("looking for scripts with the following endings: " + extensions));
        return ".+\\.(" + StringUtils.join(extensions, (String)"|") + ")$";
    }

    private FilenameFilter createFilenameFilter(final String regexp) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(regexp);
            }
        };
        return filter;
    }

    private void addScript(File file, Map<File, ScriptAddOnProperties.Script> addOnScriptMap) {
        ScriptAddOnProperties.Script scriptConfig = addOnScriptMap.get(file);
        if (scriptConfig != null && !scriptConfig.active) {
            LogUtils.info((String)("skipping deactivated " + scriptConfig));
            return;
        }
        String menuTitle = this.disambiguateMenuTitle(this.getOrCreateMenuTitle(file, scriptConfig));
        try {
            this.menuTitleToPathMap.put(menuTitle, file.getAbsolutePath());
            ScriptMetaData metaData = this.createMetaData(file, menuTitle, scriptConfig);
            this.menuTitleToMetaDataMap.put(menuTitle, metaData);
            File parentFile = file.getParentFile();
            if (parentFile.equals(ScriptResources.getBuiltinScriptsDir())) {
                metaData.setPermissions(ScriptingPermissions.getPermissiveScriptingPermissions());
            }
        }
        catch (IOException e) {
            LogUtils.warn((String)("problems with script " + file.getAbsolutePath()), (Throwable)e);
            this.menuTitleToPathMap.remove(menuTitle);
            this.menuTitleToMetaDataMap.remove(menuTitle);
        }
    }

    private String disambiguateMenuTitle(String menuTitleOrig) {
        String menuTitle = menuTitleOrig;
        int i = 2;
        while (this.menuTitleToPathMap.containsKey(menuTitle)) {
            menuTitle = menuTitleOrig + i;
            ++i;
        }
        return menuTitle;
    }

    private ScriptMetaData createMetaData(File file, String scriptName, ScriptAddOnProperties.Script scriptConfig) throws IOException {
        return scriptConfig == null ? this.analyseScriptContent(FileUtils.slurpFile((File)file), scriptName) : this.createMetaData(scriptName, scriptConfig);
    }

    ScriptMetaData analyseScriptContent(String content, String scriptName) {
        ScriptMetaData metaData = new ScriptMetaData(scriptName);
        ScriptingConfiguration.setExecutionModes(content, metaData);
        return metaData;
    }

    private ScriptMetaData createMetaData(String scriptName, ScriptAddOnProperties.Script scriptConfig) {
        ScriptMetaData metaData = new ScriptMetaData(scriptName);
        metaData.addExecutionMode(scriptConfig.executionMode, scriptConfig.menuLocation, scriptConfig.menuTitleKey);
        metaData.setPermissions(scriptConfig.permissions);
        return metaData;
    }

    public static void setExecutionModes(String content, ScriptMetaData metaData) {
        String[] locations;
        String modeName = StringUtils.join((Object[])ExecuteScriptAction.ExecutionMode.values(), (String)"|");
        String modeDef = "(?:ExecutionMode\\.)?(" + modeName + ")(?:=\"([^]\"]+)(?:\\[([^]\"]+)\\])?\")?";
        String modeDefs = "(?:" + modeDef + ",?)+";
        Pattern pOuter = ScriptingConfiguration.makeCaseInsensitivePattern("@ExecutionModes\\(\\{(" + modeDefs + ")\\}\\)");
        Matcher mOuter = pOuter.matcher(content.replaceAll("\\s+", ""));
        if (!mOuter.find()) {
            metaData.addExecutionMode(DEFAULT_EXECUTION_MODE, null, null);
            return;
        }
        Pattern pattern = ScriptingConfiguration.makeCaseInsensitivePattern(modeDef);
        for (String match : locations = mOuter.group(1).split(",")) {
            Matcher m = pattern.matcher(match);
            if (m.matches()) {
                metaData.addExecutionMode(ExecuteScriptAction.ExecutionMode.valueOf(m.group(1).toUpperCase(Locale.ENGLISH)), m.group(2), m.group(3));
                continue;
            }
            LogUtils.severe((String)("script " + metaData.getScriptName() + ": not a menu location: '" + match + "'"));
        }
    }

    private String getOrCreateMenuTitle(File file, ScriptAddOnProperties.Script scriptConfig) {
        if (scriptConfig != null) {
            return scriptConfig.menuTitleKey;
        }
        String string = file.getName().replaceFirst("\\.[^.]+", "");
        return (string = string.replaceAll("\\s+", "_")).length() < 2 ? string : string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static Pattern makeCaseInsensitivePattern(String regexp) {
        return Pattern.compile(regexp, 34);
    }

    SortedMap<String, String> getMenuTitleToPathMap() {
        return Collections.unmodifiableSortedMap(this.menuTitleToPathMap);
    }

    SortedMap<String, ScriptMetaData> getMenuTitleToMetaDataMap() {
        return Collections.unmodifiableSortedMap(this.menuTitleToMetaDataMap);
    }

    private ArrayList<String> buildClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        this.addClasspathForAddOns(classpath);
        this.addClasspathForConfiguredEntries(classpath);
        return classpath;
    }

    private void addClasspathForAddOns(ArrayList<String> classpath) {
        List<ScriptAddOnProperties> installedScriptAddOns = this.getInstalledScriptAddOns();
        for (ScriptAddOnProperties scriptAddOnProperties : installedScriptAddOns) {
            List<String> lib = scriptAddOnProperties.getLib();
            if (lib == null) continue;
            for (String libEntry : lib) {
                File dir = new File(this.getPrivateAddOnDirectory(scriptAddOnProperties), "lib");
                classpath.add(new File(dir, libEntry).getAbsolutePath());
            }
        }
    }

    private void addClasspathForConfiguredEntries(ArrayList<String> classpath) {
        for (File classpathElement : this.uniqueClassPathElements(ResourceController.getResourceController())) {
            this.addClasspathElement(classpath, classpathElement);
        }
    }

    private Set<File> uniqueClassPathElements(ResourceController resourceController) {
        String classpathString = resourceController.getProperty("script_classpath");
        TreeSet<File> classpathElements = new TreeSet<File>();
        if (classpathString != null) {
            for (String string : ConfigurationUtils.decodeListValue((String)classpathString, (boolean)false)) {
                classpathElements.add(this.createFile(string));
            }
        }
        classpathElements.add(ScriptResources.getUserLibDir());
        return classpathElements;
    }

    private void addClasspathElement(ArrayList<String> classpath, File classpathElement) {
        File file = classpathElement;
        if (!file.exists()) {
            LogUtils.warn((String)("classpath entry '" + classpathElement + "' doesn't exist. (Use " + File.pathSeparator + " to separate entries.)"));
        } else if (file.isDirectory()) {
            classpath.add(file.getAbsolutePath());
            for (File jar : file.listFiles(this.createFilenameFilter(JAR_REGEX))) {
                classpath.add(jar.getAbsolutePath());
            }
        } else {
            classpath.add(file.getAbsolutePath());
        }
    }

    List<String> getClasspath() {
        return ScriptResources.getClasspath();
    }

    public static Map<String, Object> getStaticProperties() {
        return staticProperties;
    }

    private static Map<String, Object> createStaticProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("logger", new LogUtils());
        properties.put("ui", new UITools());
        properties.put("htmlUtils", HtmlUtils.getInstance());
        properties.put("textUtils", new TextUtils());
        properties.put("menuUtils", new MenuUtils());
        properties.put("config", new FreeplaneScriptBaseClass.ConfigProperties());
        return properties;
    }

    static String getExecutionModeKey(ExecuteScriptAction.ExecutionMode executionMode) {
        switch (executionMode) {
            case ON_SINGLE_NODE: {
                return "ExecuteScriptOnSingleNode.text";
            }
            case ON_SELECTED_NODE: {
                return "ExecuteScriptOnSelectedNode.text";
            }
            case ON_SELECTED_NODE_RECURSIVELY: {
                return "ExecuteScriptOnSelectedNodeRecursively.text";
            }
        }
        throw new AssertionError((Object)("unknown ExecutionMode " + (Object)((Object)executionMode)));
    }

    public static String getScriptsLocation(String parentKey) {
        return parentKey + "/scripts";
    }

    public List<IScript> getInitScripts() {
        return this.initScripts;
    }

    static class ScriptMetaData {
        private final TreeMap<ExecuteScriptAction.ExecutionMode, String> executionModeLocationMap = new TreeMap();
        private final TreeMap<ExecuteScriptAction.ExecutionMode, String> executionModeTitleKeyMap = new TreeMap();
        private final String scriptName;
        private ScriptingPermissions permissions;

        ScriptMetaData(String scriptName) {
            this.scriptName = scriptName;
        }

        public Set<ExecuteScriptAction.ExecutionMode> getExecutionModes() {
            return this.executionModeLocationMap.keySet();
        }

        public void addExecutionMode(ExecuteScriptAction.ExecutionMode executionMode, String location, String titleKey) {
            this.executionModeLocationMap.put(executionMode, location);
            if (titleKey != null) {
                this.executionModeTitleKeyMap.put(executionMode, titleKey);
            }
        }

        protected String getMenuLocation(ExecuteScriptAction.ExecutionMode executionMode) {
            return this.executionModeLocationMap.get((Object)executionMode);
        }

        public String getTitleKey(ExecuteScriptAction.ExecutionMode executionMode) {
            String key = this.executionModeTitleKeyMap.get((Object)executionMode);
            return key == null ? ScriptingConfiguration.getExecutionModeKey(executionMode) : key;
        }

        public String getScriptName() {
            return this.scriptName;
        }

        public void setPermissions(ScriptingPermissions permissions) {
            this.permissions = permissions;
        }

        public ScriptingPermissions getPermissions() {
            return this.permissions;
        }

        public boolean hasMenuLocation() {
            for (String location : this.executionModeLocationMap.values()) {
                if (location == null) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "ScriptMetaData(" + this.scriptName + ", locations: " + this.executionModeLocationMap + ", titles: " + this.executionModeTitleKeyMap + ")";
        }
    }
}

