/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;

class ScriptingSecurityManager {
    private final Permissions permissions = new Permissions();
    private static final Permission URL_PERMISSION = new SocketPermission("*", "connect");

    public ScriptingSecurityManager(boolean pWithoutFileRestriction, boolean pWithoutWriteRestriction, boolean pWithoutNetworkRestriction, boolean pWithoutExecRestriction) {
        if (pWithoutExecRestriction && pWithoutFileRestriction && pWithoutWriteRestriction && pWithoutNetworkRestriction) {
            this.permissions.add(new AllPermission());
        } else {
            if (pWithoutNetworkRestriction) {
                this.permissions.add(new SocketPermission("*", "connect,accept,listen,resolve"));
                this.permissions.add(new RuntimePermission("setFactory"));
            }
            if (pWithoutExecRestriction) {
                this.permissions.add(new FilePermission("<<ALL FILES>>", "execute"));
                this.permissions.add(new RuntimePermission("loadLibrary.*"));
            }
            if (pWithoutFileRestriction) {
                this.permissions.add(new FilePermission("<<ALL FILES>>", "read"));
                this.permissions.add(new RuntimePermission("readFileDescriptor"));
            }
            if (pWithoutWriteRestriction) {
                this.permissions.add(new RuntimePermission("writeFileDescriptor"));
                this.permissions.add(new FilePermission("<<ALL FILES>>", "write,delete"));
                this.permissions.add(new RuntimePermission("preferences"));
            }
        }
        this.permissions.setReadOnly();
    }

    public boolean implies(Permission permission) {
        if (permission.getClass().getSimpleName().equals("URLPermission")) {
            return this.isAllowed(URL_PERMISSION);
        }
        return this.isAllowed(permission);
    }

    private boolean isAllowed(Permission permission) {
        boolean isAllowed = this.permissions.implies(permission);
        return isAllowed;
    }
}

