/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jsyntaxpane.SyntaxDocument;

public class CompoundUndoMan
extends UndoManager {
    private CompoundEdit compoundEdit;
    private boolean startCombine = false;
    private int lastLine = -1;

    public CompoundUndoMan(SyntaxDocument syntaxDocument) {
        syntaxDocument.addUndoableEditListener(this);
        this.lastLine = syntaxDocument.getStartPosition().getOffset();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            this.startCombine = false;
            return;
        }
        int n = ((SyntaxDocument)defaultDocumentEvent.getDocument()).getLineNumberAt(defaultDocumentEvent.getOffset());
        if ((this.startCombine || Math.abs(defaultDocumentEvent.getLength()) == 1) && n == this.lastLine) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.startCombine = false;
            return;
        }
        this.lastLine = n;
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(undoableEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public void startCombine() {
        this.startCombine = true;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        public boolean isInProgress() {
            return false;
        }

        public void undo() throws CannotUndoException {
            if (CompoundUndoMan.this.compoundEdit != null) {
                CompoundUndoMan.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoMan.this.compoundEdit = null;
        }
    }
}

