/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtils {
    private static ActionUtils instance = null;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String SPACES = "                ";
    public static final Pattern PTAGS_PATTERN = Pattern.compile("\\#\\{p:([^}]*)\\}");
    public static final String TEMPLATE_SELECTION = "#{selection}";

    private ActionUtils() {
    }

    public static synchronized ActionUtils getInstance() {
        if (instance == null) {
            instance = new ActionUtils();
        }
        return instance;
    }

    public static String getIndent(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "";
        }
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        return string.substring(0, n);
    }

    public static String[] getSelectedLines(JTextComponent jTextComponent) {
        String[] stringArray = null;
        try {
            PlainDocument plainDocument = (PlainDocument)jTextComponent.getDocument();
            int n = plainDocument.getParagraphElement(jTextComponent.getSelectionStart()).getStartOffset();
            int n2 = jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd() ? plainDocument.getParagraphElement(jTextComponent.getSelectionEnd()).getEndOffset() : plainDocument.getParagraphElement(jTextComponent.getSelectionEnd() - 1).getEndOffset();
            jTextComponent.select(n, n2);
            stringArray = plainDocument.getText(n, n2 - n).split("\n");
            jTextComponent.select(n, n2);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, badLocationException);
            stringArray = EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    public static String getLine(JTextComponent jTextComponent) {
        return ActionUtils.getLineAt(jTextComponent, jTextComponent.getCaretPosition());
    }

    public static String getLineAt(JTextComponent jTextComponent, int n) {
        String string = null;
        Document document = jTextComponent.getDocument();
        if (document instanceof PlainDocument) {
            PlainDocument plainDocument = (PlainDocument)document;
            int n2 = plainDocument.getParagraphElement(n).getStartOffset();
            int n3 = plainDocument.getParagraphElement(n).getEndOffset();
            try {
                string = document.getText(n2, n3 - n2);
                if (string != null && string.endsWith("\n")) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, badLocationException);
            }
        }
        return string;
    }

    public static Frame getFrameFor(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null && window instanceof Frame) {
            Frame frame = (Frame)window;
            return frame;
        }
        return null;
    }

    public static String getTokenStringAt(SyntaxDocument syntaxDocument, int n) {
        String string = "";
        Token token = syntaxDocument.getTokenAt(n);
        if (token != null) {
            try {
                string = syntaxDocument.getText(token.start, token.length);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, badLocationException);
            }
        }
        return string;
    }

    public static SyntaxDocument getSyntaxDocument(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        Document document = jTextComponent.getDocument();
        if (document instanceof SyntaxDocument) {
            return (SyntaxDocument)document;
        }
        return null;
    }

    public static int getLineNumber(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (ActionUtils.getSyntaxDocument(jTextComponent) != null) {
            SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
            return syntaxDocument.getLineNumberAt(n);
        }
        Document document = jTextComponent.getDocument();
        return document.getDefaultRootElement().getElementIndex(n);
    }

    public static int getColumnNumber(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n == 0) {
            return 0;
        }
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n2 = jTextComponent.viewToModel(new Point(0, rectangle.y));
        int n3 = n - n2;
        return n3;
    }

    public static int getDocumentPosition(JTextComponent jTextComponent, int n, int n2) {
        int n3 = jTextComponent.getFontMetrics(jTextComponent.getFont()).getHeight();
        int n4 = jTextComponent.getFontMetrics(jTextComponent.getFont()).charWidth('m');
        int n5 = n * n3;
        int n6 = n2 * n4;
        Point point = new Point(n6, n5);
        int n7 = jTextComponent.viewToModel(point);
        return n7;
    }

    public static int getLineCount(JTextComponent jTextComponent) {
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
        if (syntaxDocument != null) {
            return syntaxDocument.getLineCount();
        }
        int n = 0;
        try {
            int n2 = jTextComponent.getDocument().getLength() - 1;
            if (n2 > 0) {
                n = ActionUtils.getLineNumber(jTextComponent, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        return n;
    }

    public static void insertIntoCombo(JComboBox jComboBox, Object object) {
        if (object == null) {
            return;
        }
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)jComboBox.getModel();
        if (mutableComboBoxModel.getSize() == 0) {
            mutableComboBoxModel.insertElementAt(object, 0);
            return;
        }
        Object e = mutableComboBoxModel.getElementAt(0);
        if (e.equals(object)) {
            return;
        }
        mutableComboBoxModel.removeElement(object);
        mutableComboBoxModel.insertElementAt(object, 0);
        jComboBox.setSelectedIndex(0);
    }

    public static void insertMagicString(JTextComponent jTextComponent, String string) {
        try {
            ActionUtils.insertMagicString(jTextComponent, jTextComponent.getCaretPosition(), string);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(ActionUtils.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
    }

    public static String repeatString(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot repeat " + n + " times.");
        }
        if (n == 0 || string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static boolean isEmptyOrBlanks(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static int getTabSize(JTextComponent jTextComponent) {
        Integer n = (Integer)jTextComponent.getDocument().getProperty("tabSize");
        return null == n ? 0 : n;
    }

    public static void insertMagicString(JTextComponent jTextComponent, int n, String string) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        String[] stringArray = string.split("\n");
        if (stringArray.length > 1) {
            String string2 = ActionUtils.getTab(jTextComponent);
            String string3 = ActionUtils.getLineAt(jTextComponent, n);
            String string4 = ActionUtils.getIndent(string3);
            StringBuilder stringBuilder = new StringBuilder(string.length());
            boolean bl = true;
            for (String string5 : stringArray) {
                if (!bl) {
                    stringBuilder.append(string4);
                }
                bl = false;
                stringBuilder.append(string5.replace("\t", string2));
                stringBuilder.append("\n");
            }
            string = stringBuilder.toString();
        }
        if (string.indexOf(124) >= 0) {
            int n2 = string.indexOf(124);
            int n3 = string.indexOf(124, n2 + 1);
            string = string.replace("|", "");
            document.insertString(n, string, null);
            n = jTextComponent.getCaretPosition();
            int n4 = string.length();
            if (n3 > 0) {
                jTextComponent.select(n + n2 - n4, n + n3 - n4 - 1);
            } else {
                jTextComponent.setCaretPosition(n + n2 - n4);
            }
        } else {
            document.insertString(n, string, null);
        }
    }

    public static void insertLinesTemplate(JTextComponent jTextComponent, String[] stringArray) {
        String string = ActionUtils.getIndent(ActionUtils.getLineAt(jTextComponent, jTextComponent.getSelectionStart()));
        String[] stringArray2 = ActionUtils.getSelectedLines(jTextComponent);
        int n = -1;
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray) {
            int n3 = string2.indexOf(TEMPLATE_SELECTION);
            if (n3 >= 0) {
                for (String string3 : stringArray2) {
                    stringBuffer.append(string2.subSequence(0, n3));
                    stringBuffer.append(string3);
                    stringBuffer.append('\n');
                }
                continue;
            }
            stringBuffer.append(string);
            Matcher matcher = PTAGS_PATTERN.matcher(string2);
            int n4 = stringBuffer.length();
            while (matcher.find()) {
                n = matcher.start() + n4;
                matcher.appendReplacement(stringBuffer, matcher.group(1));
                n2 = stringBuffer.length();
            }
            matcher.appendTail(stringBuffer);
            stringBuffer.append('\n');
        }
        int n5 = jTextComponent.getSelectionStart();
        jTextComponent.replaceSelection(stringBuffer.toString());
        if (n >= 0) {
            jTextComponent.select(n5 + n, n5 + n2);
        }
    }

    public static void insertSimpleTemplate(JTextComponent jTextComponent, String string) {
        String string2 = jTextComponent.getSelectedText();
        string2 = string2 == null ? "" : string2;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Matcher matcher = PTAGS_PATTERN.matcher(string.replace(TEMPLATE_SELECTION, string2));
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (matcher.find()) {
            n = matcher.start() + n3;
            matcher.appendReplacement(stringBuffer, matcher.group(1));
            n2 = stringBuffer.length();
        }
        matcher.appendTail(stringBuffer);
        if (n >= 0) {
            n += jTextComponent.getSelectionStart();
            n2 += jTextComponent.getSelectionStart();
        }
        jTextComponent.replaceSelection(stringBuffer.toString());
        if (n >= 0) {
            jTextComponent.select(n, n2);
        }
    }

    public static boolean selectLines(JTextComponent jTextComponent) {
        Element element;
        if (jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd()) {
            return false;
        }
        PlainDocument plainDocument = (PlainDocument)jTextComponent.getDocument();
        Element element2 = plainDocument.getParagraphElement(jTextComponent.getSelectionStart());
        if (element2.equals(element = plainDocument.getParagraphElement(jTextComponent.getSelectionEnd() - 1)) && element.getEndOffset() != jTextComponent.getSelectionEnd()) {
            return false;
        }
        int n = element2.getStartOffset();
        int n2 = element.getEndOffset();
        jTextComponent.select(n, n2 - 1);
        return true;
    }

    public static void setCaretPosition(JTextComponent jTextComponent, int n, int n2) {
        int n3 = ActionUtils.getDocumentPosition(jTextComponent, n, n2);
        jTextComponent.setCaretPosition(n3);
    }

    public static String getTab(JTextComponent jTextComponent) {
        return SPACES.substring(0, ActionUtils.getTabSize(jTextComponent));
    }

    public static <T extends Action> T getAction(JTextComponent jTextComponent, Class<T> clazz) {
        for (Object object : jTextComponent.getActionMap().allKeys()) {
            Action action = jTextComponent.getActionMap().get(object);
            if (!clazz.isInstance(action)) continue;
            Action action2 = action;
            return (T)action2;
        }
        return null;
    }

    public static DefaultSyntaxKit getSyntaxKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane;
        EditorKit editorKit;
        DefaultSyntaxKit defaultSyntaxKit = null;
        if (jTextComponent instanceof JEditorPane && (editorKit = (jEditorPane = (JEditorPane)jTextComponent).getEditorKit()) instanceof DefaultSyntaxKit) {
            defaultSyntaxKit = (DefaultSyntaxKit)editorKit;
        }
        return defaultSyntaxKit;
    }

    public static void sendKeyPress(JTextComponent jTextComponent, int n, int n2) {
        KeyEvent keyEvent = new KeyEvent(jTextComponent, 401, System.currentTimeMillis(), n2, n, '\uffff');
        jTextComponent.dispatchEvent(keyEvent);
    }
}

