/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class TokenMarker
implements SyntaxComponent,
CaretListener,
PropertyChangeListener {
    public static final String DEFAULT_TOKENTYPES = "IDENTIFIER, TYPE, TYPE2, TYPE3";
    public static final String PROPERTY_COLOR = "TokenMarker.Color";
    public static final String PROPERTY_TOKENTYPES = "TokenMarker.TokenTypes";
    private static final Color DEFAULT_COLOR = new Color(0xFFEE66);
    private JEditorPane pane;
    private Set<TokenType> tokenTypes = new HashSet<TokenType>();
    private Markers.SimpleMarker marker;
    private SyntaxComponent.Status status;
    private static final Logger LOG = Logger.getLogger(TokenMarker.class.getName());

    public void caretUpdate(CaretEvent caretEvent) {
        this.markTokenAt(caretEvent.getDot());
    }

    public void markTokenAt(int n) {
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(this.pane);
        if (syntaxDocument != null) {
            Token token = syntaxDocument.getTokenAt(n);
            this.removeMarkers();
            if (token != null && this.tokenTypes.contains((Object)token.type)) {
                this.addMarkers(token);
            }
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers(this.pane, this.marker);
    }

    void addMarkers(Token token) {
        SyntaxDocument syntaxDocument = (SyntaxDocument)this.pane.getDocument();
        syntaxDocument.readLock();
        String string = token.getText(syntaxDocument).toString();
        Iterator<Token> iterator = syntaxDocument.getTokens(0, syntaxDocument.getLength());
        while (iterator.hasNext()) {
            Token token2 = iterator.next();
            String string2 = token2.getText(syntaxDocument).toString();
            if (!string.equals(string2)) continue;
            Markers.markToken(this.pane, token2, this.marker);
        }
        syntaxDocument.readUnlock();
    }

    public void config(Configuration configuration) {
        Color color = configuration.getColor(PROPERTY_COLOR, DEFAULT_COLOR);
        this.marker = new Markers.SimpleMarker(color);
        String string = configuration.getString(PROPERTY_TOKENTYPES, DEFAULT_TOKENTYPES);
        for (String string2 : string.split("\\s*,\\s*")) {
            try {
                TokenType tokenType = TokenType.valueOf(string2);
                this.tokenTypes.add(tokenType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.warning("Error in setting up TokenMarker  - Invalid TokenType: " + string2);
            }
        }
    }

    public void install(JEditorPane jEditorPane) {
        this.pane = jEditorPane;
        this.pane.addCaretListener(this);
        this.markTokenAt(jEditorPane.getCaretPosition());
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    public void deinstall(JEditorPane jEditorPane) {
        this.status = SyntaxComponent.Status.DEINSTALLING;
        this.removeMarkers();
        this.pane.removeCaretListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("document")) {
            this.pane.removeCaretListener(this);
            if (this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                this.pane.addCaretListener(this);
                this.removeMarkers();
            }
        }
    }
}

