/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtils {
    public static final List<String> DEFAULT_PACKAGES = new ArrayList<String>(3);
    private static HashMap<String, Method> SETTERS_MAP;

    public static int addMethods(Class clazz, List<Member> list) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            list.add(method);
        }
        return methodArray.length;
    }

    public static int addStaticMethods(Class clazz, List<Member> list) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            list.add(method);
        }
        return methodArray.length;
    }

    public static int addStaticFields(Class clazz, List<Member> list) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            list.add(field);
        }
        return fieldArray.length;
    }

    public static int addFields(Class clazz, List<Member> list) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getFields()) {
            list.add(field);
        }
        return fieldArray.length;
    }

    public static int addConstrcutors(Class clazz, List<Member> list) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            list.add(constructor);
        }
        return constructorArray.length;
    }

    public static String getJavaCallString(Constructor constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(constructor.getDeclaringClass().getSimpleName());
        ReflectUtils.addParamsString(stringBuilder, constructor.getParameterTypes());
        return stringBuilder.toString();
    }

    public static String getJavaCallString(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(method.getName());
        ReflectUtils.addParamsString(stringBuilder, method.getParameterTypes());
        return stringBuilder.toString();
    }

    public static StringBuilder addParamsString(StringBuilder stringBuilder, Class[] classArray) {
        stringBuilder.append("(");
        boolean bl = true;
        for (Class clazz : classArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz.getSimpleName());
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    public static String[] getMethodCalls(Class clazz) {
        String[] stringArray = new String[clazz.getMethods().length];
        int n = 0;
        for (Method method : clazz.getMethods()) {
            stringArray[n++] = ReflectUtils.getJavaCallString(method);
        }
        return stringArray;
    }

    public static String[] getConstructorCalls(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        String[] stringArray = new String[constructorArray.length];
        int n = 0;
        for (Constructor<?> constructor : constructorArray) {
            stringArray[n++] = ReflectUtils.getJavaCallString(constructor);
        }
        return stringArray;
    }

    public static String getParamsString(Class[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        ReflectUtils.addParamsString(stringBuilder, classArray);
        return stringBuilder.toString();
    }

    private static Class[] getClasses(String string) throws ClassNotFoundException, IOException {
        Serializable serializable;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        assert (classLoader != null);
        String string2 = string.replace('.', '/');
        Enumeration<URL> enumeration = classLoader.getResources(string2);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            arrayList.add(new File(((URL)serializable).getFile()));
        }
        serializable = new ArrayList();
        for (File file : arrayList) {
            ((ArrayList)serializable).addAll(ReflectUtils.findClasses(file, string));
        }
        return ((ArrayList)serializable).toArray(new Class[((ArrayList)serializable).size()]);
    }

    private static List<Class> findClasses(File file, String string) throws ClassNotFoundException {
        File[] fileArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (!file.exists()) {
            return arrayList;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                assert (!file2.getName().contains("."));
                arrayList.addAll(ReflectUtils.findClasses(file2, string + "." + file2.getName()));
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            arrayList.add(Class.forName(string + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
        }
        return arrayList;
    }

    public static Class findClass(String string, List<String> list) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (String string2 : list) {
            try {
                return Class.forName(string2 + "." + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return null;
    }

    public static boolean callSetter(Object object, String string, Object object2) {
        String string2 = String.format("%s.%s(%s)", object.getClass().getName(), string, object2.getClass().getName());
        Method method = null;
        boolean bl = false;
        if (!SETTERS_MAP.containsKey(string2)) {
            method = ReflectUtils.findMethod(object, string, object2);
            SETTERS_MAP.put(string2, method);
        } else {
            method = SETTERS_MAP.get(string2);
        }
        if (method != null) {
            try {
                method.invoke(object, object2);
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(ReflectUtils.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(ReflectUtils.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(ReflectUtils.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            }
        }
        return bl;
    }

    private static synchronized Method findMethod(Object object, String string, Object object2) {
        Method method = null;
        Class<?> clazz = object.getClass();
        String string2 = String.format("set%C%s", Character.valueOf(string.charAt(0)), string.substring(1));
        for (Class<?> clazz2 = object2.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                method = clazz.getMethod(string2, clazz2);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    try {
                        method = clazz.getMethod(string2, clazz3);
                        return method;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                    }
                }
                continue;
            }
        }
        return method;
    }

    static {
        DEFAULT_PACKAGES.add("java.lang");
        DEFAULT_PACKAGES.add("java.util");
        DEFAULT_PACKAGES.add("jsyntaxpane");
        SETTERS_MAP = new HashMap();
    }
}

