/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

class SyntaxPane
extends JEditorPane
implements CaretListener {
    private Vector patterns;
    private final Cursor waitCursor = Cursor.getPredefinedCursor(3);

    public SyntaxPane() {
        this.setEditorKit(new StyledEditorKit());
        this.setupPatterns();
    }

    private void setupPatterns() {
        this.patterns = new Vector();
        Pattern p = Pattern.compile("\\b\\w+");
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, Color.BLACK);
        StyleConstants.setBold(set, false);
        this.patterns.addElement(new RegExStyle(p, set));
        p = Pattern.compile("<[/a-zA-Z0-9\\s]+");
        set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, new Color(0, 0, 128));
        StyleConstants.setBold(set, true);
        this.patterns.addElement(new RegExStyle(p, set));
        p = Pattern.compile(">");
        this.patterns.addElement(new RegExStyle(p, set));
        p = Pattern.compile("\\s[/a-zA-Z0-9]+=");
        set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, new Color(158, 119, 0));
        StyleConstants.setBold(set, true);
        this.patterns.addElement(new RegExStyle(p, set));
        p = Pattern.compile("\"[\\x2D;:/.%#?=,\\w\\s]+\"");
        set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, Color.BLUE);
        StyleConstants.setBold(set, false);
        this.patterns.addElement(new RegExStyle(p, set));
    }

    public void setMarks(StyledDocument sDoc, int offset, int len) {
        SwingUtilities.invokeLater(new StyleUpdater(this, sDoc, offset, len));
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }

    private void cursor() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            Component gp = rootPane.getGlassPane();
            if (!gp.isVisible()) {
                gp.setCursor(this.waitCursor);
                gp.setVisible(true);
            } else {
                gp.setVisible(false);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            StyledDocument sDoc = (StyledDocument)this.getDocument();
            int cPos = e.getDot();
            int length = sDoc.getLength();
            String text = sDoc.getText(0, length);
            int lineStart = text.substring(0, cPos).lastIndexOf("\n") + 1;
            int lineEnd = text.indexOf("\n", cPos);
            if (lineEnd < 0) {
                lineEnd = length;
            }
            this.setMarks(sDoc, lineStart, lineEnd - lineStart);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setText(String t) {
        this.removeCaretListener(this);
        super.setText(t);
        StyledDocument sDoc = (StyledDocument)this.getDocument();
        this.setMarks(sDoc, 0, sDoc.getLength());
        this.setCaretPosition(0);
        this.addCaretListener(this);
    }

    class RegExStyle {
        private Pattern p;
        private AttributeSet a;

        public RegExStyle(Pattern p, AttributeSet a) {
            this.p = p;
            this.a = a;
        }

        public Pattern getPattern() {
            return this.p;
        }

        public AttributeSet getStyle() {
            return this.a;
        }

        public void setPattern(Pattern p) {
            this.p = p;
        }

        public void setStyle(AttributeSet a) {
            this.a = a;
        }
    }

    private class StyleUpdater
    implements Runnable {
        private final StyledDocument sDoc;
        private final int offset;
        private final int len;
        private final SyntaxPane sp;

        public StyleUpdater(SyntaxPane sp, StyledDocument doc, int offset, int len) {
            this.sDoc = doc;
            this.offset = offset;
            this.len = len;
            this.sp = sp;
        }

        @Override
        public void run() {
            SyntaxPane.this.cursor();
            this.sp.removeCaretListener(this.sp);
            try {
                String text;
                int length = this.sDoc.getLength();
                if (length > 0 && this.len > 0 && (text = this.sDoc.getText(this.offset, this.len)) != null && text.length() > 0) {
                    Enumeration pe = SyntaxPane.this.patterns.elements();
                    while (pe.hasMoreElements()) {
                        RegExStyle style = (RegExStyle)pe.nextElement();
                        Matcher m = style.getPattern().matcher(text);
                        while (m.find()) {
                            this.sDoc.setCharacterAttributes(this.offset + m.start(), m.end() - m.start(), style.getStyle(), true);
                        }
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("StyleUpdater ERROR: " + ex.getMessage());
            }
            this.sp.addCaretListener(this.sp);
            SyntaxPane.this.cursor();
        }
    }
}

