/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;

public class Reprojector {
    private static Reprojector instance = new Reprojector();

    private Reprojector() {
    }

    public static Reprojector instance() {
        return instance;
    }

    public boolean wouldChangeValues(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        if (coordinateSystem == CoordinateSystem.UNSPECIFIED) {
            return false;
        }
        if (coordinateSystem2 == CoordinateSystem.UNSPECIFIED) {
            return false;
        }
        return coordinateSystem != coordinateSystem2;
    }

    public void reproject(Coordinate coordinate, CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        if (!this.wouldChangeValues(coordinateSystem, coordinateSystem2)) {
            return;
        }
        Planar planar = coordinateSystem2.getProjection().asPlanar(coordinateSystem.getProjection().asGeographic(new Planar(coordinate.x, coordinate.y), new Geographic()), new Planar());
        coordinate.x = planar.x;
        coordinate.y = planar.y;
    }

    public void reproject(Geometry geometry, final CoordinateSystem coordinateSystem, final CoordinateSystem coordinateSystem2) {
        if (!this.wouldChangeValues(coordinateSystem, coordinateSystem2)) {
            return;
        }
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                Reprojector.this.reproject(coordinate, coordinateSystem, coordinateSystem2);
            }
        });
        geometry.setSRID(coordinateSystem2.getEPSGCode());
        geometry.geometryChanged();
    }
}

