/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class Layer
extends AbstractLayerable
implements LayerManagerProxy {
    public static final String FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE = Layer.class.getName() + " - FIRING APPEARANCE CHANGED ON ATTRIBUTE CHANGE";
    private String description = "";
    private boolean drawingLast = false;
    private ArrayList styles = new ArrayList();
    private boolean synchronizingLineColor = true;
    private boolean editable = false;
    private LayerListener layerListener = null;
    private boolean featureCollectionModified = false;
    private FeatureCollection featureCollection;

    public Layer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer(String string, Color color, FeatureCollection featureCollection, LayerManager layerManager) {
        super(string, layerManager);
        Assert.isTrue(featureCollection != null);
        boolean bl = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.addStyle(new BasicStyle());
            this.addStyle(new SquareVertexStyle());
            this.addStyle(new LabelStyle());
        }
        finally {
            layerManager.setFiringEvents(bl);
        }
        this.getBasicStyle().setFillColor(color);
        this.getBasicStyle().setLineColor(Layer.defaultLineColor(color));
        this.getBasicStyle().setAlpha(150);
        this.setFeatureCollection(featureCollection);
    }

    public static Color defaultLineColor(Color color) {
        return color.darker();
    }

    public void setDescription(String string) {
        Assert.isTrue(string != null, "Java2XML requires that the description be non-null. Use an empty string if necessary.");
        this.description = string;
    }

    public void setDrawingLast(boolean bl) {
        this.drawingLast = bl;
        this.fireAppearanceChanged();
    }

    public static FeatureCollection createBlankFeatureCollection() {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        return new FeatureDataset(featureSchema);
    }

    public FeatureCollection getFeatureCollection() {
        return this.featureCollection;
    }

    public void setFeatureCollection(FeatureCollection featureCollection) {
        final FeatureCollection featureCollection2 = this.featureCollection != null ? this.featureCollection : Layer.createBlankFeatureCollection();
        this.featureCollection = featureCollection;
        if (this.getLayerManager() != null && this.getLayerManager().getLayers().contains(this)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!featureCollection2.getFeatures().isEmpty()) {
                        Layer.this.getLayerManager().fireFeaturesChanged(featureCollection2.getFeatures(), FeatureEventType.DELETED, Layer.this);
                    }
                    if (Layer.this.featureCollection.size() > 0) {
                        Layer.this.getLayerManager().fireFeaturesChanged(Layer.this.featureCollection.getFeatures(), FeatureEventType.ADDED, Layer.this);
                    }
                }
            });
        }
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSynchronizingLineColor(boolean bl) {
        this.synchronizingLineColor = bl;
        this.fireAppearanceChanged();
    }

    public BasicStyle getBasicStyle() {
        return (BasicStyle)this.getStyle(BasicStyle.class);
    }

    public VertexStyle getVertexStyle() {
        return (VertexStyle)this.getStyle(VertexStyle.class);
    }

    public LabelStyle getLabelStyle() {
        return (LabelStyle)this.getStyle(LabelStyle.class);
    }

    public String getDescription() {
        return this.description;
    }

    public Style getStyle(Class clazz) {
        Iterator iterator = this.styles.iterator();
        while (iterator.hasNext()) {
            Style style = (Style)iterator.next();
            if (!clazz.isInstance(style)) continue;
            return style;
        }
        return null;
    }

    public List getStyles() {
        return Collections.unmodifiableList(this.styles);
    }

    public boolean isDrawingLast() {
        return this.drawingLast;
    }

    public boolean isSynchronizingLineColor() {
        return this.synchronizingLineColor;
    }

    public void addStyle(Style style) {
        this.styles.add(style);
        this.fireAppearanceChanged();
    }

    public void dispose() {
        this.setFeatureCollection(Layer.createBlankFeatureCollection());
    }

    public void removeStyle(Style style) {
        Assert.isTrue(this.styles.remove(style));
        this.fireAppearanceChanged();
    }

    public Collection cloneStyles() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getStyles().iterator();
        while (iterator.hasNext()) {
            Style style = (Style)iterator.next();
            arrayList.add(style.clone());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyles(Collection collection) {
        boolean bl = this.getLayerManager().isFiringEvents();
        this.getLayerManager().setFiringEvents(false);
        try {
            Style style;
            Iterator iterator = new ArrayList(this.getStyles()).iterator();
            while (iterator.hasNext()) {
                style = (Style)iterator.next();
                this.removeStyle(style);
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                style = (Style)iterator.next();
                this.addStyle(style);
            }
        }
        finally {
            this.getLayerManager().setFiringEvents(bl);
        }
        this.fireAppearanceChanged();
    }

    public void setLayerManager(LayerManager layerManager) {
        if (layerManager != null) {
            layerManager.removeLayerListener(this.getLayerListener());
        }
        super.setLayerManager(layerManager);
        layerManager.addLayerListener(this.getLayerListener());
    }

    private LayerListener getLayerListener() {
        if (this.layerListener == null) {
            this.layerListener = new LayerListener(){

                public void featuresChanged(FeatureEvent featureEvent) {
                    if (featureEvent.getLayer() == Layer.this) {
                        Layer.this.setFeatureCollectionModified(true);
                        if (featureEvent.getType() != FeatureEventType.ATTRIBUTES_MODIFIED) {
                            Layer.this.fireAppearanceChanged();
                        }
                    }
                }

                public void layerChanged(LayerEvent layerEvent) {
                }

                public void categoryChanged(CategoryEvent categoryEvent) {
                }
            };
        }
        return this.layerListener;
    }

    public static void tryToInvalidateEnvelope(Layer layer) {
        if (layer.featureCollection instanceof FeatureDataset) {
            ((FeatureDataset)layer.featureCollection).invalidateEnvelope();
        }
    }

    public boolean isFeatureCollectionModified() {
        return this.featureCollectionModified;
    }

    public Layer setFeatureCollectionModified(boolean bl) {
        if (this.featureCollectionModified == bl) {
            return this;
        }
        this.featureCollectionModified = bl;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        return this;
    }
}

