/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractSelection {
    private Map layerMap = new HashMap();
    private AbstractSelection child;
    private AbstractSelection parent;
    private SelectionManager selectionManager;

    public abstract String getRendererContentID();

    public AbstractSelection(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public abstract List items(Geometry var1);

    public Collection items(Geometry geometry, Collection collection) {
        List list = this.items(geometry);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            arrayList.add(list.get(n));
        }
        return arrayList;
    }

    public CollectionMap getFeatureToSelectedItemIndexCollectionMap(Layer layer) {
        if (!this.layerMap.containsKey(layer)) {
            this.layerMap.put(layer, new CollectionMap(HashMap.class, HashSet.class));
        }
        return (CollectionMap)this.layerMap.get(layer);
    }

    public Collection getSelectedItemIndices(Layer layer, Feature feature) {
        Collection collection = this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(feature);
        return collection == null ? new ArrayList() : collection;
    }

    public CollectionMap getFeatureToSelectedItemCollectionMap(Layer layer) {
        CollectionMap collectionMap = new CollectionMap();
        Iterator iterator = this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            collectionMap.put(feature, this.items(feature.getGeometry(), this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(feature)));
        }
        return collectionMap;
    }

    public Collection getLayersWithSelectedItems() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        Iterator iterator = this.layerMap.keySet().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (this.getFeaturesWithSelectedItems(layer).isEmpty()) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    public Collection getFeaturesWithSelectedItems() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.layerMap.keySet().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            arrayList.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return arrayList;
    }

    public Collection getFeaturesWithSelectedItems(Layer layer) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Iterator iterator = this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(feature).isEmpty()) continue;
            arrayList.add(feature);
        }
        return arrayList;
    }

    public Collection getSelectedItems() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = new ArrayList(this.layerMap.keySet()).iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            arrayList.addAll(this.getSelectedItems(layer));
        }
        return arrayList;
    }

    public Collection getSelectedItems(Layer layer) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            arrayList.addAll(this.getSelectedItems(layer, feature));
        }
        return arrayList;
    }

    public Collection getSelectedItems(Layer layer, Feature feature) {
        return this.getSelectedItems(layer, feature, feature.getGeometry());
    }

    public Collection getSelectedItems(Layer layer, Feature feature, Geometry geometry) {
        return this.items(geometry, this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(feature));
    }

    public Collection indices(Geometry geometry, Collection collection) {
        List list = this.items(geometry);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            arrayList.add(new Integer(list.indexOf(e)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, CollectionMap collectionMap) {
        boolean bl = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = collectionMap.keySet().iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.unselectItems(layer, feature, collectionMap.getItems(feature));
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, CollectionMap collectionMap) {
        boolean bl = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = collectionMap.keySet().iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.selectItems(layer, feature, collectionMap.getItems(feature));
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, Feature feature, Collection collection) {
        Collection collection2 = this.itemsNotSelectedInAncestors(layer, feature, collection);
        boolean bl = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            this.unselectInDescendants(layer, feature, collection2);
            this.getFeatureToSelectedItemIndexCollectionMap(layer).addItems(feature, this.indices(feature.getGeometry(), collection2));
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Feature feature, Collection collection) {
        boolean bl = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            this.getFeatureToSelectedItemIndexCollectionMap(layer).removeItems(feature, this.indices(feature.getGeometry(), collection));
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    public Collection itemsNotSelectedInAncestors(Layer layer, Feature feature, Collection collection) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Geometry geometry = (Geometry)iterator.next();
            if (this.selectedInAncestors(layer, feature, geometry)) continue;
            arrayList.add(geometry);
        }
        return arrayList;
    }

    protected abstract boolean selectedInAncestors(Layer var1, Feature var2, Geometry var3);

    protected abstract void unselectInDescendants(Layer var1, Feature var2, Collection var3);

    public void selectItems(Layer layer, Feature feature) {
        this.selectItems(layer, feature, this.items(feature.getGeometry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, Collection collection) {
        boolean bl = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.selectItems(layer, feature);
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection collection, Collection collection2) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Iterator iterator = collection2.iterator();
        iterator.hasNext();
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Feature feature = (Feature)iterator2.next();
            Feature feature2 = (Feature)iterator.next();
            if (this.items(feature.getGeometry()).size() == this.items(feature2.getGeometry()).size()) continue;
            arrayList.add(feature);
        }
        this.unselectItems(layer, arrayList);
    }

    public void unselectItems() {
        this.layerMap.clear();
        this.updatePanel();
    }

    public void unselectItems(Layer layer) {
        this.layerMap.remove(layer);
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Collection collection) {
        boolean bl = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.unselectItems(layer, feature);
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(bl);
        }
        this.updatePanel();
    }

    public void unselectItems(Layer layer, Feature feature) {
        this.getFeatureToSelectedItemIndexCollectionMap(layer).remove(feature);
        this.updatePanel();
    }

    public void unselectItem(Layer layer, Feature feature, int n) {
        this.getFeatureToSelectedItemIndexCollectionMap(layer).removeItem(feature, new Integer(n));
    }

    private void updatePanel() {
        this.selectionManager.updatePanel();
    }

    public void setChild(AbstractSelection abstractSelection) {
        this.child = abstractSelection;
    }

    public void setParent(AbstractSelection abstractSelection) {
        this.parent = abstractSelection;
    }

    protected AbstractSelection getChild() {
        return this.child;
    }

    protected AbstractSelection getParent() {
        return this.parent;
    }
}

