/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import com.vividsolutions.jts.geom.Coordinate;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.geo.GeoLocation;
import genj.geo.GeoModelListener;
import genj.geo.GeoService;
import genj.geo.GeoView;
import genj.util.swing.Action2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spin.Spin;

class GeoModel
implements GedcomListener {
    public static final int ALL_MATCHED = 0;
    public static final int SOME_MATCHED = 1;
    public static final int ERROR = 2;
    private List listeners = new ArrayList();
    private Gedcom gedcom;
    private Map locations = new HashMap();
    private LinkedList resolvers = new LinkedList();

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public void setGedcom(Gedcom set) {
        if (this.gedcom != null) {
            ArrayList removed = new ArrayList(this.locations.keySet());
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                GeoLocation loc = (GeoLocation)it.next();
                this.locations.remove(loc);
                this.fireLocationRemoved(loc);
            }
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)this));
        }
        this.gedcom = set;
        if (this.gedcom != null) {
            Iterator it = GeoLocation.parseEntities(this.gedcom.getEntities()).iterator();
            while (it.hasNext()) {
                GeoLocation loc = (GeoLocation)it.next();
                this.locations.put(loc, loc);
                this.fireLocationAdded(loc);
            }
            this.resolve(this.locations.keySet(), false);
            this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)this));
        }
    }

    public void setCoordinates(GeoLocation loc, Coordinate coord) {
        if ((loc = (GeoLocation)this.locations.get(loc)) != null) {
            loc.setCoordinate(coord);
            GeoService.getInstance().remember(this.gedcom, loc);
            this.fireLocationUpdated(loc);
        }
    }

    public synchronized int getNumLocations() {
        return this.locations.size();
    }

    public synchronized Collection getLocations() {
        return this.locations.keySet();
    }

    private void fireLocationAdded(GeoLocation location) {
        GeoModelListener[] ls = this.listeners.toArray(new GeoModelListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].locationAdded(location);
        }
    }

    private void fireLocationUpdated(GeoLocation location) {
        GeoModelListener[] ls = this.listeners.toArray(new GeoModelListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].locationUpdated(location);
        }
    }

    private void fireLocationRemoved(GeoLocation location) {
        GeoModelListener[] ls = this.listeners.toArray(new GeoModelListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].locationRemoved(location);
        }
    }

    private void fireAsyncResolveStart() {
        GeoModelListener[] ls = this.listeners.toArray(new GeoModelListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].asyncResolveStart();
        }
    }

    private void fireAsyncResolveEnd(int status, String msg) {
        GeoModelListener[] ls = this.listeners.toArray(new GeoModelListener[this.listeners.size()]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].asyncResolveEnd(status, msg);
        }
    }

    public void resolveAll() {
        this.resolve(this.locations.keySet(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(Collection todo, boolean matchAll) {
        LinkedList linkedList = this.resolvers;
        synchronized (linkedList) {
            Resolver resolver = new Resolver(todo, matchAll);
            if (this.resolvers.isEmpty()) {
                resolver.trigger();
            } else {
                this.resolvers.add(resolver);
            }
        }
    }

    public void addGeoModelListener(GeoModelListener l) {
        this.listeners.add(l);
    }

    public void removeGeoModelListener(GeoModelListener l) {
        this.listeners.remove(l);
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        Set added = GeoLocation.parseEntities(Collections.singletonList(entity));
        Iterator locs = added.iterator();
        while (locs.hasNext()) {
            GeoLocation loc = (GeoLocation)locs.next();
            GeoLocation old = (GeoLocation)this.locations.get(loc);
            if (old != null) {
                old.add(loc);
                this.fireLocationUpdated(old);
                continue;
            }
            this.locations.put(loc, loc);
            this.fireLocationAdded(loc);
        }
        this.resolve(added, true);
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        ArrayList current = new ArrayList(this.locations.keySet());
        Iterator locs = current.iterator();
        while (locs.hasNext()) {
            GeoLocation loc = (GeoLocation)locs.next();
            loc.removeEntity(entity);
            if (loc.getNumProperties() == 0) {
                this.locations.remove(loc);
                this.fireLocationRemoved(loc);
                continue;
            }
            this.fireLocationUpdated(loc);
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        this.gedcomPropertyChanged(gedcom, property);
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        Entity entity = property.getEntity();
        this.gedcomEntityDeleted(gedcom, entity);
        this.gedcomEntityAdded(gedcom, entity);
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        this.gedcomPropertyChanged(gedcom, property);
    }

    private class Resolver
    extends Action2 {
        private ArrayList todo;
        private boolean matchAll;
        private Throwable err = null;

        private Resolver(Collection todo, boolean matchAll) {
            this.setAsync(1);
            this.getThread().setDaemon(true);
            this.todo = new ArrayList(todo);
            this.matchAll = matchAll;
        }

        protected boolean preExecute() {
            GeoModel.this.fireAsyncResolveStart();
            return true;
        }

        protected void execute() {
            try {
                GeoService.getInstance().match(GeoModel.this.gedcom, this.todo, this.matchAll);
            }
            catch (Throwable t) {
                this.err = t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void postExecute(boolean preExecuteResult) {
            int misses = 0;
            Iterator it = this.todo.iterator();
            while (it.hasNext()) {
                GeoLocation old;
                GeoLocation loc = (GeoLocation)it.next();
                if (!loc.isValid()) {
                    ++misses;
                }
                if ((old = (GeoLocation)GeoModel.this.locations.get(loc)) == null) continue;
                GeoModel.this.fireLocationUpdated(old);
            }
            if (this.err != null) {
                GeoModel.this.fireAsyncResolveEnd(2, GeoView.RESOURCES.getString("resolve.error", (Object)this.err.getMessage()));
            } else {
                GeoModel.this.fireAsyncResolveEnd(misses > 0 ? 1 : 0, GeoView.RESOURCES.getString("resolve.matches", (Object[])new Integer[]{new Integer(this.todo.size() - misses), new Integer(this.todo.size())}));
            }
            LinkedList linkedList = GeoModel.this.resolvers;
            synchronized (linkedList) {
                if (!GeoModel.this.resolvers.isEmpty()) {
                    ((Resolver)((Object)GeoModel.this.resolvers.removeFirst())).trigger();
                }
            }
        }
    }
}

