/*
 * Decompiled with CFR 0.152.
 */
package com.nm.resedit;

import com.nm.resedit.ResourceDir;
import com.nm.resedit.ResourceLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class ResourceFile {
    static final int COMMENT = -1;
    static final int TRANSLATE = 0;
    static final int TRANSLATED = 1;
    private String path;
    private Vector content;
    private Hashtable translation;
    private int not_translated = 0;
    private ResourceDir parent;

    ResourceFile(ZipEntry zipEntry, InputStream inputStream, boolean bl) throws IOException {
        String string;
        this.path = zipEntry.getName();
        this.path = this.path.substring(0, this.path.lastIndexOf(47));
        this.content = new Vector(100);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            if (bl) {
                string = ResourceLine.decode(string);
            }
            if (string.length() == 0) continue;
            this.content.addElement(string);
            if (ResourceLine.getKey(string).length() <= 0) continue;
            ++this.not_translated;
        }
        this.translation = new Hashtable();
    }

    void writeTo(ZipOutputStream zipOutputStream, boolean bl, String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(this.getPath() + "/" + string);
        zipOutputStream.putNextEntry(zipEntry);
        PrintStream printStream = new PrintStream(zipOutputStream);
        Enumeration enumeration = this.translation.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.translation.get(string2);
            if (bl) {
                ResourceLine.encode(string2 + "  = " + string3, printStream);
                continue;
            }
            printStream.println(string2 + "  = " + string3);
        }
        zipOutputStream.closeEntry();
    }

    void setTranslation(InputStream inputStream, boolean bl) throws IOException {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((object = bufferedReader.readLine()) != null) {
            if (((String)object).length() == 0) continue;
            if (bl) {
                object = ResourceLine.decode((String)object);
            }
            hashtable.put(ResourceLine.getKey((String)object), ResourceLine.getValue((String)object));
        }
        object = this.content.elements();
        while (object.hasMoreElements()) {
            String string;
            String string2 = (String)object.nextElement();
            String string3 = ResourceLine.getKey(string2);
            if (string3.length() == 0 || (string = (String)hashtable.get(string3)) == null) continue;
            this.translation.put(string3, string);
            this.not_translated = Math.max(0, this.not_translated - 1);
        }
    }

    String getPath() {
        return this.path;
    }

    boolean isTranslated() {
        return this.not_translated == 0;
    }

    public int getLineCount() {
        return this.content.size();
    }

    public String getLine(int n) {
        return (String)this.content.elementAt(n);
    }

    public String getLineTranslation(int n) {
        String string = this.getLine(n);
        String string2 = ResourceLine.getKey(string);
        String string3 = (String)this.translation.get(string2);
        if (string3 != null) {
            return string3;
        }
        return ResourceLine.getValue(string);
    }

    public void setLineTranslation(int n, String string) {
        String string2 = this.getLine(n);
        String string3 = ResourceLine.getKey(string2);
        if (this.translation.get(string3) == null) {
            --this.not_translated;
        }
        this.translation.put(string3, string);
    }

    public int getLineState(int n) {
        String string = this.getLine(n);
        if (string.startsWith("#")) {
            return -1;
        }
        if (this.translation.containsKey(ResourceLine.getKey(string))) {
            return 1;
        }
        return 0;
    }

    void setParent(ResourceDir resourceDir) {
        this.parent = resourceDir;
    }
}

