/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.apps.FOURIResolver;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;

public class FOUserAgent {
    public static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    public static final String DEFAULT_PAGE_HEIGHT = "11in";
    public static final String DEFAULT_PAGE_WIDTH = "8.26in";
    private RendererFactory rendererFactory = new RendererFactory();
    private XMLHandlerRegistry xmlHandlers = new XMLHandlerRegistry();
    private String baseURL;
    private String fontBaseURL;
    private URIResolver uriResolver = null;
    private URIResolver foURIResolver = new FOURIResolver();
    private PDFEncryptionParams pdfEncryptionParams;
    private float sourceResolution = 72.0f;
    private float targetResolution = 72.0f;
    private String pageHeight = "11in";
    private String pageWidth = "8.26in";
    private Map rendererOptions = new HashMap();
    private File outputFile = null;
    private Renderer rendererOverride = null;
    private FOEventHandler foEventHandlerOverride = null;
    private LayoutManagerMaker lmMakerOverride = null;
    private Configuration userConfig = null;
    private Log log = LogFactory.getLog((String)"FOP");
    private boolean strictValidation = true;
    private boolean breakIndentInheritanceOnReferenceAreaBoundary = false;
    private List additionalElementMappings = null;
    protected String producer = "Apache FOP Version " + Version.getVersion();
    protected String creator = null;
    protected Date creationDate = null;
    protected String author = null;
    protected String title = null;
    protected String keywords = null;

    public void addElementMapping(ElementMapping elementMapping) {
        if (this.additionalElementMappings == null) {
            this.additionalElementMappings = new ArrayList();
        }
        this.additionalElementMappings.add(elementMapping);
    }

    public List getAdditionalElementMappings() {
        return this.additionalElementMappings;
    }

    public void setRendererOverride(Renderer renderer) {
        this.rendererOverride = renderer;
    }

    public Renderer getRendererOverride() {
        return this.rendererOverride;
    }

    public void setFOEventHandlerOverride(FOEventHandler handler) {
        this.foEventHandlerOverride = handler;
    }

    public FOEventHandler getFOEventHandlerOverride() {
        return this.foEventHandlerOverride;
    }

    public void setStrictValidation(boolean validateStrictly) {
        this.strictValidation = validateStrictly;
    }

    public boolean validateStrictly() {
        return this.strictValidation;
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.breakIndentInheritanceOnReferenceAreaBoundary;
    }

    public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
        this.breakIndentInheritanceOnReferenceAreaBoundary = value;
    }

    public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
        this.lmMakerOverride = lmMaker;
    }

    public LayoutManagerMaker getLayoutManagerMakerOverride() {
        return this.lmMakerOverride;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public Map getRendererOptions() {
        return this.rendererOptions;
    }

    public void setUserConfig(Configuration userConfig) {
        this.userConfig = userConfig;
        try {
            this.initUserConfig();
        }
        catch (ConfigurationException cfge) {
            this.log.error((Object)("Error initializing User Agent configuration: " + cfge.getMessage()));
        }
    }

    public Configuration getUserConfig() {
        return this.userConfig;
    }

    public void initUserConfig() throws ConfigurationException {
        Configuration pageConfig;
        this.log.debug((Object)"Initializing User Agent Configuration");
        this.setBaseURL(this.getBaseURLfromConfig("base"));
        this.setFontBaseURL(this.getBaseURLfromConfig("font-base"));
        if (this.userConfig.getChild("source-resolution", false) != null) {
            this.sourceResolution = this.userConfig.getChild("source-resolution").getValueAsFloat(72.0f);
            this.log.info((Object)("Source resolution set to: " + this.sourceResolution + "dpi (px2mm=" + this.getSourcePixelUnitToMillimeter() + ")"));
        }
        if (this.userConfig.getChild("target-resolution", false) != null) {
            this.targetResolution = this.userConfig.getChild("target-resolution").getValueAsFloat(72.0f);
            this.log.info((Object)("Target resolution set to: " + this.targetResolution + "dpi (px2mm=" + this.getTargetPixelUnitToMillimeter() + ")"));
        }
        if (this.userConfig.getChild("strict-validation", false) != null) {
            this.strictValidation = this.userConfig.getChild("strict-validation").getValueAsBoolean();
        }
        if (this.userConfig.getChild("break-indent-inheritance", false) != null) {
            this.breakIndentInheritanceOnReferenceAreaBoundary = this.userConfig.getChild("break-indent-inheritance").getValueAsBoolean();
        }
        if ((pageConfig = this.userConfig.getChild("default-page-settings")).getAttribute("height", null) != null) {
            this.setPageHeight(pageConfig.getAttribute("height"));
            this.log.info((Object)("Default page-height set to: " + this.pageHeight));
        }
        if (pageConfig.getAttribute("width", null) != null) {
            this.setPageWidth(pageConfig.getAttribute("width"));
            this.log.info((Object)("Default page-width set to: " + this.pageWidth));
        }
    }

    private String getBaseURLfromConfig(String name) {
        if (this.userConfig.getChild(name, false) != null) {
            try {
                String cfgBaseDir = this.userConfig.getChild(name).getValue(null);
                if (cfgBaseDir != null) {
                    File dir = new File(cfgBaseDir);
                    if (dir.isDirectory()) {
                        cfgBaseDir = "file://" + dir.getCanonicalPath() + System.getProperty("file.separator");
                        cfgBaseDir = cfgBaseDir.replace(System.getProperty("file.separator").charAt(0), '/');
                    } else {
                        new URL(cfgBaseDir);
                    }
                }
                this.log.info((Object)(name + " set to: " + cfgBaseDir));
                return cfgBaseDir;
            }
            catch (MalformedURLException mue) {
                this.log.error((Object)"Base URL in user config is malformed!");
            }
            catch (IOException ioe) {
                this.log.error((Object)"Error converting relative base directory to absolute URL.");
            }
        }
        return null;
    }

    public Configuration getUserRendererConfig(String mimeType) {
        if (this.userConfig == null || mimeType == null) {
            return null;
        }
        Configuration userRendererConfig = null;
        Configuration[] cfgs = this.userConfig.getChild("renderers").getChildren("renderer");
        for (int i = 0; i < cfgs.length; ++i) {
            Configuration cfg = cfgs[i];
            try {
                if (!cfg.getAttribute("mime").equals(mimeType)) continue;
                userRendererConfig = cfg;
                break;
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
        this.log.debug((Object)((userRendererConfig == null ? "No u" : "U") + "ser configuration found for MIME type " + mimeType));
        return userRendererConfig;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setFontBaseURL(String fontBaseURL) {
        this.fontBaseURL = fontBaseURL;
    }

    public String getFontBaseURL() {
        return this.fontBaseURL != null ? this.fontBaseURL : this.baseURL;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public PDFEncryptionParams getPDFEncryptionParams() {
        return this.pdfEncryptionParams;
    }

    public void setPDFEncryptionParams(PDFEncryptionParams pdfEncryptionParams) {
        this.pdfEncryptionParams = pdfEncryptionParams;
    }

    public Source resolveURI(String uri) {
        return this.resolveURI(uri, this.getBaseURL());
    }

    public Source resolveURI(String uri, String baseURL) {
        Source source = null;
        if (this.uriResolver != null) {
            try {
                source = this.uriResolver.resolve(uri, baseURL);
            }
            catch (TransformerException te) {
                this.log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        if (source == null) {
            try {
                source = this.foURIResolver.resolve(uri, baseURL);
            }
            catch (TransformerException te) {
                this.log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        return source;
    }

    public void setOutputFile(File f) {
        this.outputFile = f;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public float getSourcePixelUnitToMillimeter() {
        return 25.4f / this.sourceResolution;
    }

    public float getTargetPixelUnitToMillimeter() {
        return 25.4f / this.targetResolution;
    }

    public float getSourceResolution() {
        return this.sourceResolution;
    }

    public float getTargetResolution() {
        return this.targetResolution;
    }

    public void setSourceResolution(int dpi) {
        this.sourceResolution = dpi;
    }

    public void setTargetResolution(int dpi) {
        this.targetResolution = dpi;
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.xmlHandlers;
    }
}

