/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.fop.util.Service;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.Locator;

public class ElementMappingRegistry {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$fop$fo$ElementMappingRegistry == null ? (class$org$apache$fop$fo$ElementMappingRegistry = ElementMappingRegistry.class$("org.apache.fop.fo.ElementMappingRegistry")) : class$org$apache$fop$fo$ElementMappingRegistry));
    protected Map fobjTable = new HashMap();
    protected Map namespaces = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$fo$ElementMappingRegistry;
    static /* synthetic */ Class class$org$apache$fop$fo$ElementMapping;

    public ElementMappingRegistry(FOUserAgent userAgent) {
        this.setupDefaultMappings();
        List addlEMs = userAgent.getAdditionalElementMappings();
        if (addlEMs != null) {
            for (int i = 0; i < addlEMs.size(); ++i) {
                this.addElementMapping((ElementMapping)addlEMs.get(i));
            }
        }
    }

    private void setupDefaultMappings() {
        this.addElementMapping("org.apache.fop.fo.FOElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.svg.SVGElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.svg.BatikExtensionElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.ExtensionElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.xmp.XMPElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.xmp.RDFElementMapping");
        this.addElementMapping("org.apache.fop.render.ps.extensions.PSExtensionElementMapping");
        Iterator providers = Service.providers(class$org$apache$fop$fo$ElementMapping == null ? (class$org$apache$fop$fo$ElementMapping = ElementMappingRegistry.class$("org.apache.fop.fo.ElementMapping")) : class$org$apache$fop$fo$ElementMapping);
        if (providers != null) {
            while (providers.hasNext()) {
                String str = (String)providers.next();
                try {
                    this.addElementMapping(str);
                }
                catch (IllegalArgumentException e) {
                    this.log.warn((Object)"Error while adding element mapping", (Throwable)e);
                }
            }
        }
    }

    public void addElementMapping(String mappingClassName) throws IllegalArgumentException {
        try {
            ElementMapping mapping = (ElementMapping)Class.forName(mappingClassName).newInstance();
            this.addElementMapping(mapping);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + mappingClassName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + mappingClassName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + mappingClassName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(mappingClassName + " is not an ElementMapping");
        }
    }

    private void addElementMapping(ElementMapping mapping) {
        this.fobjTable.put(mapping.getNamespaceURI(), mapping.getTable());
        this.namespaces.put(mapping.getNamespaceURI().intern(), mapping);
    }

    public ElementMapping.Maker findFOMaker(String namespaceURI, String localName, Locator locator) throws FOPException {
        Map table = (Map)this.fobjTable.get(namespaceURI);
        ElementMapping.Maker fobjMaker = null;
        if (table != null && (fobjMaker = (ElementMapping.Maker)table.get(localName)) == null) {
            fobjMaker = (ElementMapping.Maker)table.get("<default>");
        }
        if (fobjMaker == null) {
            if (this.namespaces.containsKey(namespaceURI.intern())) {
                throw new FOPException(FONode.errorText(locator) + "No element mapping definition found for " + FONode.getNodeString(namespaceURI, localName), locator);
            }
            this.log.warn((Object)("Unknown formatting object " + namespaceURI + "^" + localName));
            fobjMaker = new UnknownXMLObj.Maker(namespaceURI);
        }
        return fobjMaker;
    }

    public DOMImplementation getDOMImplementationForNamespace(String namespaceURI) {
        ElementMapping mapping = (ElementMapping)this.namespaces.get(namespaceURI);
        return mapping.getDOMImplementation();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

