/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.Version;
import genj.app.Options;
import genj.app.Workbench;
import genj.app.WorkbenchAdapter;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.option.OptionProvider;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.MacAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class App {
    static Logger LOG;
    static File LOGFILE;
    private static final Resources RESOURCES;
    private static final Registry REGISTRY;
    private static Workbench workbench;
    private static JFrame frame;

    public static synchronized void main(String[] stringArray) {
        if (workbench != null) {
            return;
        }
        try {
            Object object;
            LOG = Logger.getLogger("genj");
            Logger logger = Logger.getLogger("");
            try {
                object = Level.parse(EnvironmentChecker.getProperty("genj.debug.level", "INFO", "log-level for GenJ"));
                LOG.setLevel((Level)object);
                if (Integer.MAX_VALUE != ((Level)object).intValue()) {
                    logger.setLevel(new Level("genj.debug.level+1", ((Level)object).intValue() + 1){});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = logger.getHandlers();
            for (int i = 0; i < ((Handler[])object).length; ++i) {
                logger.removeHandler((Handler)object[i]);
            }
            BufferedHandler bufferedHandler = new BufferedHandler();
            logger.addHandler(bufferedHandler);
            logger.addHandler(new FlushingHandler(new StreamHandler(System.out, new LogFormatter())));
            System.setOut(new PrintStream(new LogOutputStream(Level.INFO, "System", "out")));
            System.setErr(new PrintStream(new LogOutputStream(Level.WARNING, "System", "err")));
            LOG.info("Main");
            REGISTRY.setFile(new File(EnvironmentChecker.getProperty("user.home.genj", ".", "calculate dir for registry"), "genj.properties"));
            OptionProvider.getAllOptions();
            LOGFILE = EnvironmentChecker.getLog();
            FileHandler fileHandler = new FileHandler(LOGFILE.getAbsolutePath(), Options.getInstance().getMaxLogSizeKB() * 1024, 1, true);
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new LogFormatter());
            LOG.addHandler(fileHandler);
            logger.removeHandler(bufferedHandler);
            bufferedHandler.flush(fileHandler);
            LOG.info("version = " + Version.getInstance().getBuildString());
            LOG.info("date = " + new Date());
            EnvironmentChecker.log();
            if (MacAdapter.isMac()) {
                MacAdapter.getInstance().install("GenealogyJ");
                LOG.info("MacAdapter active");
            }
            if (!EnvironmentChecker.isJava16() && EnvironmentChecker.getProperty("genj.forcevm", null, "Check force of VM") == null) {
                LOG.severe("Need Java 1.6 to run GenJ");
                System.exit(1);
                return;
            }
            LOG.info("/Main");
            SwingUtilities.invokeAndWait(new Startup(stringArray));
        }
        catch (Throwable throwable) {
            throw new Error(throwable);
        }
    }

    static {
        RESOURCES = Resources.get(App.class);
        REGISTRY = Registry.get(App.class);
    }

    private static class LogOutputStream
    extends OutputStream {
        private char[] buffer = new char[256];
        private int size = 0;
        private Level level;
        private String sourceClass;
        private String sourceMethod;

        public LogOutputStream(Level level, String string, String string2) {
            this.level = level;
            this.sourceClass = string;
            this.sourceMethod = string2;
        }

        public void write(int n) throws IOException {
            if (n != 10) {
                this.buffer[this.size++] = (char)n;
                if (this.size < this.buffer.length) {
                    return;
                }
            }
            this.flush();
        }

        public void flush() throws IOException {
            if (this.size > 0) {
                LOG.logp(this.level, this.sourceClass, this.sourceMethod, String.valueOf(this.buffer, 0, this.size).trim());
                this.size = 0;
            }
        }
    }

    private static class LogFormatter
    extends Formatter {
        private LogFormatter() {
        }

        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append(logRecord.getLevel());
            stringBuffer.append(":");
            stringBuffer.append(logRecord.getSourceClassName());
            stringBuffer.append(".");
            stringBuffer.append(logRecord.getSourceMethodName());
            stringBuffer.append(":");
            String string = logRecord.getMessage().replace('\n', ',');
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null || objectArray.length == 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(MessageFormat.format(string, objectArray));
            }
            stringBuffer.append(System.getProperty("line.separator"));
            if (logRecord.getThrown() != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    logRecord.getThrown().printStackTrace(printWriter);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            return stringBuffer.toString();
        }
    }

    private static class FlushingHandler
    extends Handler {
        private Handler wrapped;

        private FlushingHandler(Handler handler) {
            this.wrapped = handler;
            handler.setLevel(Level.ALL);
            this.setLevel(Level.ALL);
        }

        public void publish(LogRecord logRecord) {
            this.wrapped.publish(logRecord);
            this.flush();
        }

        public void flush() {
            this.wrapped.flush();
        }

        public void close() throws SecurityException {
            this.flush();
            this.wrapped.close();
        }
    }

    private static class BufferedHandler
    extends Handler {
        private List<LogRecord> buffer = new ArrayList<LogRecord>();

        private BufferedHandler() {
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        private void flush(Handler handler) {
            for (LogRecord logRecord : this.buffer) {
                handler.publish(logRecord);
            }
            this.buffer.clear();
        }

        public void publish(LogRecord logRecord) {
            this.buffer.add(logRecord);
        }
    }

    private static class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            LOG.info("Shutdown");
            frame.dispose();
            OptionProvider.persistAll();
            Registry.persist();
            LOG.info("/Shutdown");
            System.exit(0);
        }
    }

    private static class Startup
    implements Runnable {
        private String[] args;

        Startup(String[] stringArray) {
            this.args = stringArray;
        }

        public void run() {
            LOG.info("Startup");
            UIManager.put("PopupMenu.consumeEventOnClose", new Boolean(false));
            App.workbench = new Workbench(new Shutdown());
            frame = new JFrame(){

                public void dispose() {
                    REGISTRY.put("frame", this);
                    super.dispose();
                }
            };
            frame.setTitle(RESOURCES.getString("app.title"));
            frame.setIconImage(Gedcom.getImage().getImage());
            frame.getContentPane().add(workbench);
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    workbench.exit();
                }
            });
            REGISTRY.get("frame", frame);
            frame.setVisible(true);
            String string = Version.getInstance().getVersionString();
            if (!string.equals(REGISTRY.get("disclaimer", ""))) {
                REGISTRY.put("disclaimer", string);
                DialogHelper.openDialog("Disclaimer", 1, RESOURCES.getString("app.disclaimer"), (Action[])Action2.okOnly(), (Object)frame);
            }
            workbench.addWorkbenchListener(new WorkbenchAdapter(){

                public void selectionChanged(Workbench workbench, Context context, boolean bl) {
                    if (context.getEntities().size() == 1) {
                        frame.setTitle(context.getGedcom().getName() + " - " + context.getEntity() + " - " + RESOURCES.getString("app.title"));
                    } else if (context.getGedcom() != null) {
                        frame.setTitle(context.getGedcom().getName() + " - " + RESOURCES.getString("app.title"));
                    } else {
                        frame.setTitle(RESOURCES.getString("app.title"));
                    }
                }

                public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
                    frame.setTitle(RESOURCES.getString("app.title"));
                }

                public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
                    frame.setTitle(gedcom.getName() + " - " + RESOURCES.getString("app.title"));
                }
            });
            if (this.args.length == 0) {
                workbench.restoreGedcom();
            } else {
                try {
                    workbench.openGedcom(new URL("file:" + new File(this.args[0]).getAbsolutePath()));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            LOG.info("/Startup");
        }
    }
}

