/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableModel;
import genj.common.PropertyTableModelListener;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyName;
import genj.gedcom.TagPath;
import genj.io.BasicTransferable;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.HeadlessLabel;
import genj.util.swing.LinkWidget;
import genj.util.swing.SortableTableModel;
import genj.view.ContextProvider;
import genj.view.SelectionSink;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PropertyTableWidget
extends JPanel {
    private static final Logger LOG = Logger.getLogger("genj.common");
    private JPanel panelShortcuts = new JPanel();
    private Table table;
    private boolean ignoreSelection = false;
    private int visibleRowCount = -1;
    private TransferHandler transferer;

    public PropertyTableWidget() {
        this((PropertyTableModel)null);
    }

    public PropertyTableWidget(PropertyTableModel propertyTableModel) {
        this.panelShortcuts.setMinimumSize(new Dimension());
        this.panelShortcuts.setLayout(new BoxLayout(this.panelShortcuts, 1));
        this.table = new Table();
        this.setModel(propertyTableModel);
        this.setRowSelection(2);
        this.setColSelection(2);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.table));
        this.add("East", this.panelShortcuts);
    }

    public void setColSelection(int n) {
        this.table.setColSelection(n);
    }

    public void setRowSelection(int n) {
        this.table.setRowSelection(n);
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    public void setModel(PropertyTableModel propertyTableModel) {
        this.table.setPropertyTableModel(propertyTableModel);
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
        this.revalidate();
        this.repaint();
    }

    public PropertyTableModel getModel() {
        return this.table.getPropertyTableModel();
    }

    public void setAutoResize(boolean bl) {
        this.table.setAutoResizeMode(bl ? 4 : 0);
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public Property getSelectedRow() {
        int n = this.table.getSelectedRow();
        return n < 0 ? null : this.table.getRowRoot(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void select(Context context) {
        if (this.ignoreSelection) {
            return;
        }
        if (context.getGedcom() != this.getModel().getGedcom()) {
            throw new IllegalArgumentException("select on wrong gedcom");
        }
        try {
            void var5_7;
            Object object;
            Object object3;
            this.ignoreSelection = true;
            Object object4 = context.getProperties();
            if (object4.isEmpty()) {
                object3 = new ArrayList<Property>(context.getProperties());
                for (Entity object22 : context.getEntities()) {
                    if (object3.contains(object22)) continue;
                    object3.add(object22);
                }
                object4 = object3;
            }
            object3 = this.table.getSelectionModel();
            ListSelectionModel listSelectionModel = this.table.getColumnModel().getSelectionModel();
            this.table.clearSelection();
            Point point = new Point();
            Object object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (Property)object2.next();
                Point point2 = this.table.getCell((Property)object);
                if (point2.y >= 0) {
                    object3.addSelectionInterval(point2.y, point2.y);
                    if (point2.x < 0) continue;
                    listSelectionModel.addSelectionInterval(point2.x, point2.x);
                    continue;
                }
                int n = this.table.getRow((Property)object);
                if (n < 0) continue;
                object3.addSelectionInterval(n, n);
                listSelectionModel.addSelectionInterval(0, this.table.getColumnCount() - 1);
                point2.y = n;
            }
            if (var5_7.y >= 0) {
                object2 = this.table.getVisibleRect();
                object = this.table.getCellRect(var5_7.y, var5_7.x, true);
                if (var5_7.x < 0) {
                    ((Rectangle)object).x = ((Rectangle)object2).x;
                }
                this.table.scrollRectToVisible((Rectangle)object);
            }
        }
        finally {
            this.ignoreSelection = false;
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public String getColumnLayout() {
        int n;
        SortableTableModel sortableTableModel = (SortableTableModel)this.table.getModel();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        List<SortableTableModel.Directive> list = sortableTableModel.getDirectives();
        WordBuffer wordBuffer = new WordBuffer(",");
        wordBuffer.append(tableColumnModel.getColumnCount());
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            wordBuffer.append(tableColumnModel.getColumn(n).getWidth());
        }
        for (n = 0; n < list.size(); ++n) {
            SortableTableModel.Directive directive = list.get(n);
            wordBuffer.append(directive.getColumn());
            wordBuffer.append(directive.getDirection());
        }
        return wordBuffer.toString();
    }

    public void setColumnLayout(String string) {
        SortableTableModel sortableTableModel = (SortableTableModel)this.table.getModel();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            for (n = 0; n < n2 && n < tableColumnModel.getColumnCount(); ++n) {
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                tableColumn.setWidth(n3);
                tableColumn.setPreferredWidth(n3);
            }
            sortableTableModel.cancelSorting();
            while (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                if (n >= tableColumnModel.getColumnCount()) continue;
                sortableTableModel.setSortingStatus(n, n4);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int[] getColumnDirections() {
        SortableTableModel sortableTableModel = (SortableTableModel)this.table.getModel();
        int[] nArray = new int[sortableTableModel.getColumnCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = sortableTableModel.getSortingStatus(i);
        }
        return nArray;
    }

    public void setColumnDirections(int[] nArray) {
        SortableTableModel sortableTableModel = (SortableTableModel)this.table.getModel();
        for (int i = 0; i < nArray.length && i < sortableTableModel.getColumnCount(); ++i) {
            sortableTableModel.setSortingStatus(i, nArray[i]);
        }
    }

    private class Table
    extends JTable
    implements ContextProvider {
        private PropertyTableModel propertyModel;
        private SortableTableModel sortableModel = new SortableTableModel();
        private int defaultRowHeight;

        Table() {
            this.setPropertyTableModel(null);
            this.setDefaultRenderer(Object.class, new Renderer());
            this.getTableHeader().setReorderingAllowed(false);
            this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            Renderer renderer = new Renderer();
            renderer.setFont(this.getFont());
            this.defaultRowHeight = renderer.getPreferredSize().height;
            this.setModel(this.sortableModel);
            this.sortableModel.setTableHeader(this.getTableHeader());
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = Table.this.rowAtPoint(mouseEvent.getPoint());
                    int n2 = Table.this.columnAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n2 < 0) {
                        Table.this.clearSelection();
                    } else if (!Table.this.isCellSelected(n, n2)) {
                        Table.this.getSelectionModel().setSelectionInterval(n, n);
                        Table.this.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
                    }
                }
            });
            this.sortableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        Table.this.createShortcuts();
                    }
                }
            });
            PropertyTableWidget.this.panelShortcuts.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    Table.this.createShortcuts();
                }
            });
        }

        public TransferHandler getTransferHandler() {
            if (PropertyTableWidget.this.transferer == null) {
                PropertyTableWidget.this.transferer = new Transferer();
            }
            return PropertyTableWidget.this.transferer;
        }

        public int[] getSelectedRows() {
            int[] nArray = super.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.sortableModel.modelIndex(nArray[i]);
            }
            return nArray;
        }

        void setRowSelection(int n) {
            this.getSelectionModel().setSelectionMode(n);
        }

        void setColSelection(int n) {
            this.getColumnModel().setColumnSelectionAllowed(n >= 0);
            if (n >= 0) {
                this.getColumnModel().getSelectionModel().setSelectionMode(n);
            }
        }

        Action2 createShortcut(String string, final int n) {
            return new Action2(string.toUpperCase()){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n2 = 0;
                    try {
                        n2 = ((JViewport)((PropertyTableWidget)PropertyTableWidget.this).table.getParent()).getViewPosition().x;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    PropertyTableWidget.this.table.scrollRectToVisible(new Rectangle(n2, n, 1, Table.this.getParent().getHeight()));
                }
            };
        }

        void createShortcuts(int n, JComponent jComponent) {
            Serializable serializable;
            Property property;
            if (this.propertyModel == null || jComponent.getHeight() == 0) {
                return;
            }
            TableModel tableModel = this.getModel();
            Collator collator = this.propertyModel.getGedcom().getCollator();
            ArrayList<Action2> arrayList = new ArrayList<Action2>(26);
            String string = "";
            for (int i = 0; i < tableModel.getRowCount() && !((property = (Property)tableModel.getValueAt(i, n)) instanceof PropertyDate); ++i) {
                String string2;
                if (property == null) continue;
                String string3 = string2 = property instanceof PropertyName ? ((PropertyName)property).getLastName().trim() : property.getDisplayValue().trim();
                if (string2.length() == 0 || collator.compare(string, string2 = string2.substring(0, 1).toLowerCase()) >= 0) continue;
                string = string2;
                Action2 action2 = this.createShortcut(string2, ((PropertyTableWidget)PropertyTableWidget.this).table.getCellRect((int)i, (int)n, (boolean)true).y);
                arrayList.add(action2);
                serializable = jComponent.getInputMap(2);
                ActionMap actionMap = jComponent.getActionMap();
                ((InputMap)serializable).put(KeyStroke.getKeyStroke(string2.charAt(0)), action2);
                actionMap.put(action2, action2);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            LinkWidget linkWidget = new LinkWidget("Sample", null);
            int n2 = linkWidget.getPreferredSize().height;
            int n3 = Math.min(arrayList.size(), (jComponent.getHeight() - n2) / n2);
            for (int i = 0; i < n3; ++i) {
                serializable = new LinkWidget((Action2)arrayList.get(i * arrayList.size() / n3));
                ((JComponent)serializable).setAlignmentX(0.5f);
                jComponent.add((Component)serializable);
            }
            if (n3 < arrayList.size()) {
                LinkWidget linkWidget2 = new LinkWidget((Action2)arrayList.get(arrayList.size() - 1));
                linkWidget2.setAlignmentX(0.5f);
                jComponent.add(linkWidget2);
            }
        }

        void createShortcuts() {
            PropertyTableWidget.this.panelShortcuts.removeAll();
            PropertyTableWidget.this.panelShortcuts.getInputMap(2).clear();
            PropertyTableWidget.this.panelShortcuts.getActionMap().clear();
            PropertyTableWidget.this.panelShortcuts.revalidate();
            PropertyTableWidget.this.panelShortcuts.repaint();
            if (!this.sortableModel.isSorting()) {
                return;
            }
            SortableTableModel.Directive directive = this.sortableModel.getDirectives().get(0);
            if (directive.getDirection() <= 0) {
                return;
            }
            this.createShortcuts(directive.getColumn(), PropertyTableWidget.this.panelShortcuts);
        }

        int getRow(Property property) {
            PropertyTableModel propertyTableModel = this.getPropertyTableModel();
            for (int i = 0; i < propertyTableModel.getNumRows(); ++i) {
                if (!propertyTableModel.getRowRoot(i).contains(property)) continue;
                return ((SortableTableModel)this.getModel()).viewIndex(i);
            }
            return -1;
        }

        Point getCell(Property property) {
            Point point = new Point(-1, -1);
            if (this.propertyModel == null) {
                return point;
            }
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            for (int i = 0; i < sortableTableModel.getRowCount(); ++i) {
                int n = sortableTableModel.modelIndex(i);
                for (int j = 0; j < sortableTableModel.getColumnCount(); ++j) {
                    if (sortableTableModel.getValueAt(n, j) != property) continue;
                    return new Point(j, n);
                }
            }
            return point;
        }

        Property getRowRoot(int n) {
            return this.propertyModel.getRowRoot(this.sortableModel.modelIndex(n));
        }

        void setPropertyTableModel(PropertyTableModel propertyTableModel) {
            this.propertyModel = propertyTableModel;
            this.sortableModel.setTableModel(new Model(propertyTableModel));
        }

        PropertyTableModel getPropertyTableModel() {
            return this.propertyModel;
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            List<? extends Property> list = this.getContext().getProperties();
            super.changeSelection(n, n2, bl, bl2);
            if (PropertyTableWidget.this.ignoreSelection) {
                return;
            }
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
            for (int i = listSelectionModel.getMinSelectionIndex(); i <= listSelectionModel.getMaxSelectionIndex(); ++i) {
                for (int j = listSelectionModel2.getMinSelectionIndex(); j <= listSelectionModel2.getMaxSelectionIndex(); ++j) {
                    if (!listSelectionModel.isSelectedIndex(i) || !listSelectionModel2.isSelectedIndex(j)) continue;
                    SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
                    if (i < 0 || i >= sortableTableModel.getRowCount() || j < 0 || j >= sortableTableModel.getColumnCount()) continue;
                    Property property = (Property)this.getValueAt(i, j);
                    if (property == null) {
                        property = this.propertyModel.getRowRoot(sortableTableModel.modelIndex(i));
                    }
                    if (list.contains(property)) {
                        arrayList.add(property);
                        continue;
                    }
                    arrayList.add(0, property);
                }
            }
            if (!arrayList.isEmpty()) {
                PropertyTableWidget.this.ignoreSelection = true;
                SelectionSink.Dispatcher.fireSelection(PropertyTableWidget.this, new Context(((Property)arrayList.get(0)).getGedcom(), new ArrayList(), arrayList), false);
                PropertyTableWidget.this.ignoreSelection = false;
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            if (PropertyTableWidget.this.visibleRowCount > 0) {
                dimension.height = 0;
                for (int i = 0; i < PropertyTableWidget.this.visibleRowCount; ++i) {
                    if (i < this.getModel().getRowCount()) {
                        dimension.height += this.getRowHeight(i);
                        continue;
                    }
                    dimension.height += this.defaultRowHeight;
                }
            }
            return dimension;
        }

        public ViewContext getContext() {
            Gedcom gedcom = this.propertyModel.getGedcom();
            if (gedcom == null) {
                return null;
            }
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            int[] nArray = super.getSelectedRows();
            if (nArray.length > 0) {
                int[] nArray2 = this.getSelectedColumns();
                for (int i = 0; i < nArray.length; ++i) {
                    boolean bl = false;
                    for (int j = 0; j < nArray2.length; ++j) {
                        Property property = (Property)this.getValueAt(nArray[i], nArray2[j]);
                        if (property == null) continue;
                        arrayList.add(property);
                        bl = true;
                    }
                    if (bl) continue;
                    arrayList.add(this.propertyModel.getRowRoot(sortableTableModel.modelIndex(nArray[i])));
                }
            }
            return new ViewContext(gedcom, (List<Entity>)new ArrayList<Entity>(), (List<Property>)arrayList);
        }

        private class Transferer
        extends TransferHandler {
            private Transferer() {
            }

            protected Transferable createTransferable(JComponent jComponent) {
                if (jComponent != Table.this) {
                    return null;
                }
                int[] nArray = PropertyTableWidget.this.table.getSelectedColumns();
                int[] nArray2 = PropertyTableWidget.this.table.getSelectedRows();
                if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                for (int i = 0; i < nArray2.length; ++i) {
                    stringBuffer2.append("<tr>\n");
                    for (int j = 0; j < nArray.length; ++j) {
                        Property property = (Property)PropertyTableWidget.this.table.getValueAt(Table.this.sortableModel.viewIndex(nArray2[i]), nArray[j]);
                        String string = AbstractPropertyTableModel.getDefaultCellValue(property, i, j);
                        stringBuffer.append(string + "\t");
                        stringBuffer2.append("  <td>" + string + "</td>\n");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }

            public int getSourceActions(JComponent jComponent) {
                return jComponent == Table.this ? 1 : 0;
            }
        }

        private class Renderer
        extends HeadlessLabel
        implements TableCellRenderer {
            Renderer() {
                this.setPadding(2);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setFont(jTable.getFont());
                if (Table.this.getRowHeight() != this.getPreferredSize().height) {
                    Table.this.setRowHeight(this.getPreferredSize().height);
                }
                if (Table.this.propertyModel instanceof AbstractPropertyTableModel) {
                    AbstractPropertyTableModel abstractPropertyTableModel = (AbstractPropertyTableModel)Table.this.propertyModel;
                    this.setText(abstractPropertyTableModel.getCellValue((Property)object, n, n2));
                    this.setHorizontalAlignment(abstractPropertyTableModel.getCellAlignment((Property)object, n, n2));
                } else {
                    this.setText(AbstractPropertyTableModel.getDefaultCellValue((Property)object, n, n2));
                    this.setHorizontalAlignment(AbstractPropertyTableModel.getDefaultCellAlignment((Property)object, n, n2));
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                    this.setOpaque(true);
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setOpaque(false);
                }
                return this;
            }
        }

        private class Model
        extends AbstractTableModel
        implements PropertyTableModelListener,
        SortableTableModel.RowComparator {
            private PropertyTableModel model;
            private Property[][] cells;

            private Model(PropertyTableModel propertyTableModel) {
                this.model = propertyTableModel;
            }

            private Gedcom getGedcom() {
                return this.model != null ? this.model.getGedcom() : null;
            }

            public void handleRowsAdded(PropertyTableModel propertyTableModel, int n, int n2) {
                int n3 = propertyTableModel.getNumRows();
                int n4 = propertyTableModel.getNumCols();
                this.cells = new Property[n3][n4];
                this.fireTableRowsInserted(n, n2);
            }

            public void handleRowsDeleted(PropertyTableModel propertyTableModel, int n, int n2) {
                int n3 = propertyTableModel.getNumRows();
                int n4 = propertyTableModel.getNumCols();
                this.cells = new Property[n3][n4];
                this.fireTableRowsDeleted(n, n2);
            }

            public void handleRowsChanged(PropertyTableModel propertyTableModel, int n, int n2, int n3) {
                for (int i = n; i <= n2; ++i) {
                    this.cells[i][n3] = null;
                }
                this.fireTableChanged(new TableModelEvent(this, n, n2, n3));
            }

            public void addTableModelListener(TableModelListener tableModelListener) {
                super.addTableModelListener(tableModelListener);
                if (this.model != null && ((TableModelListener[])this.getListeners(TableModelListener.class)).length == 1) {
                    this.model.addListener(this);
                }
            }

            public void removeTableModelListener(TableModelListener tableModelListener) {
                super.removeTableModelListener(tableModelListener);
                if (this.model != null && ((TableModelListener[])this.getListeners(TableModelListener.class)).length == 0) {
                    this.model.removeListener(this);
                }
            }

            public int compare(Object object, Object object2, int n) {
                if (Table.this.propertyModel instanceof AbstractPropertyTableModel) {
                    return ((AbstractPropertyTableModel)Table.this.propertyModel).compare((Property)object, (Property)object2, n);
                }
                return AbstractPropertyTableModel.defaultCompare((Property)object, (Property)object2, n);
            }

            public String getColumnName(int n) {
                return this.model != null ? this.model.getColName(n) : "";
            }

            public int getColumnCount() {
                return this.model != null ? this.model.getNumCols() : 0;
            }

            public int getRowCount() {
                return this.model != null ? this.model.getNumRows() : 0;
            }

            private TagPath getPath(int n) {
                return this.model != null ? this.model.getColPath(n) : null;
            }

            private Context getContextAt(int n, int n2) {
                if (this.model == null) {
                    return null;
                }
                Property property = this.getPropertyAt(n, n2);
                if (property != null) {
                    return new Context(property);
                }
                Property property2 = this.model.getRowRoot(n);
                if (property2 != null) {
                    return new Context(property2.getEntity());
                }
                return new Context(this.model.getGedcom());
            }

            private Property getPropertyAt(int n, int n2) {
                Property property;
                if (this.cells == null) {
                    this.cells = new Property[this.model.getNumRows()][this.model.getNumCols()];
                }
                if ((property = this.cells[n][n2]) == null) {
                    this.cells[n][n2] = property = this.model.getRowRoot(n).getProperty(this.model.getColPath(n2));
                }
                return property;
            }

            public Object getValueAt(int n, int n2) {
                return this.getPropertyAt(n, n2);
            }

            private Property getProperty(int n) {
                return this.model.getRowRoot(n);
            }
        }
    }
}

