/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.common.SelectEntityWidget;
import genj.edit.ChoosePropertyBean;
import genj.edit.EditView;
import genj.edit.Editor;
import genj.edit.Images;
import genj.edit.PropertyTreeWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextAreaWidget;
import genj.view.ActionProvider;
import genj.view.SelectionSink;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

class AdvancedEditor
extends Editor {
    private static final String ACC_CUT = "ctrl X";
    private static final String ACC_COPY = "ctrl C";
    private static final String ACC_PASTE = "ctrl V";
    private static final Clipboard clipboard = AdvancedEditor.initClipboard();
    private static final Registry REGISTRY = Registry.get(AdvancedEditor.class);
    private Set<TagPath> expands = new HashSet<TagPath>();
    private boolean ignoreTreeSelection = false;
    private static Resources resources = Resources.get(AdvancedEditor.class);
    private Gedcom gedcom;
    private PropertyTreeWidget tree = null;
    private JPanel editPane;
    private PropertyBean bean = null;
    private JSplitPane splitPane = null;
    private EditView view;
    private Callback callback;

    private static Clipboard initClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable throwable) {
            return new Clipboard("GenJ");
        }
    }

    public AdvancedEditor(Gedcom gedcom, EditView editView) {
        this.gedcom = gedcom;
        this.view = editView;
        this.tree = new Tree();
        this.callback = new Callback();
        this.tree.addTreeSelectionListener(this.callback);
        this.tree.addTreeWillExpandListener(this.callback);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setMinimumSize(new Dimension(160, 128));
        jScrollPane.setPreferredSize(new Dimension(160, 128));
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        this.editPane = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.editPane);
        jScrollPane2.getVerticalScrollBar().setFocusable(false);
        jScrollPane2.getHorizontalScrollBar().setFocusable(false);
        this.splitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        this.splitPane.setDividerLocation(REGISTRY.get("divider", -1));
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("dividerLocation".equals(propertyChangeEvent.getPropertyName())) {
                    REGISTRY.put("divider", AdvancedEditor.this.splitPane.getDividerLocation());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
        String string = REGISTRY.get("expand", "INDI:BIRT,INDI:RESI,INDI:OBJE,FAM:MARR");
        for (String string2 : string.split(",")) {
            try {
                this.expands.add(new TagPath(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void removeNotify() {
        WordBuffer wordBuffer = new WordBuffer(",");
        for (TagPath tagPath : this.expands) {
            wordBuffer.append(tagPath);
        }
        REGISTRY.put("expand", wordBuffer.toString());
        super.removeNotify();
    }

    public ViewContext getContext() {
        return this.tree.getContext();
    }

    public void setContext(Context context) {
        if (!this.ignoreTreeSelection) {
            this.setContextImpl(context, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContextImpl(Context context, boolean bl) {
        List<Property> list;
        Object object;
        if (this.bean != null) {
            this.bean.removeChangeListener(this.changes);
        }
        this.bean = null;
        this.editPane.removeAll();
        this.editPane.revalidate();
        this.editPane.repaint();
        this.changes.setChanged(false);
        if (context.getGedcom() == null || context.getEntities().isEmpty()) {
            try {
                this.ignoreTreeSelection = true;
                this.tree.setRoot(null);
            }
            finally {
                this.ignoreTreeSelection = false;
            }
            return;
        }
        this.ignoreTreeSelection = true;
        this.tree.clearSelection();
        Entity entity = context.getEntity();
        if (entity != this.tree.getRoot()) {
            this.tree.setRoot(entity);
            object = this.expands.iterator();
            while (object.hasNext()) {
                list = (TagPath)object.next();
                this.expand((TagPath)((Object)list));
            }
        }
        if ((object = this.tree.getRoot()) != null) {
            list = ((Property)object).getGedcom();
            this.view.commit();
        }
        if ((list = context.getProperties()).isEmpty()) {
            list = bl && entity.getNoOfProperties() > 0 ? Collections.singletonList(entity.getProperty(0)) : Collections.singletonList(entity);
        }
        this.tree.setSelection((List<? extends Property>)list);
        this.ignoreTreeSelection = false;
        if (list.size() == 0) {
            return;
        }
        Property property = list.get(list.size() - 1);
        try {
            this.bean = PropertyBean.getBean(property.getClass()).setContext(property);
            this.editPane.add((Component)this.bean, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            if (property instanceof PropertyXRef) {
                JButton jButton = new JButton(new Follow((PropertyXRef)property));
                jToolBar.add(jButton);
            } else {
                JLabel jLabel = new JLabel(Gedcom.getName(property.getTag()), property.getImage(false), 2);
                jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                jToolBar.add(jLabel);
            }
            this.editPane.add((Component)jToolBar, "North");
            this.changes.setChanged(false);
            this.bean.addChangeListener(this.changes);
        }
        catch (Throwable throwable) {
            EditView.LOG.log(Level.WARNING, "Property bean " + this.bean, throwable);
        }
    }

    public void expand(TagPath tagPath) {
        this.tree.expand(tagPath);
    }

    public void commit() throws GedcomException {
        Property property = this.tree.getRoot();
        if (property == null) {
            return;
        }
        Gedcom gedcom = property.getGedcom();
        if (this.bean != null) {
            this.bean.commit();
        }
    }

    private class Tree
    extends PropertyTreeWidget {
        private Tree() {
            super(AdvancedEditor.this.gedcom);
            this.setRequestFocusEnabled(false);
            new Cut().install(this, AdvancedEditor.ACC_CUT, 0);
            new Copy().install(this, AdvancedEditor.ACC_COPY, 0);
            new Paste().install(this, AdvancedEditor.ACC_PASTE, 0);
        }

        public ViewContext getContext() {
            ViewContext viewContext = super.getContext();
            List<? extends Property> list = viewContext.getProperties();
            List<Property> list2 = AdvancedEditor.this.tree.getSelection();
            if (!list.isEmpty()) {
                viewContext.addAction(new Cut(list2));
                viewContext.addAction(new Copy(list2));
            }
            if (list2.size() == 1) {
                viewContext.addAction(new Paste(list2.get(0)));
                viewContext.addAction(new ActionProvider.SeparatorAction());
                Property property = list2.get(0);
                if (!property.isTransient()) {
                    viewContext.addAction(new Add(property));
                    Action2.Group group = new Action2.Group(resources.getString("action.add"));
                    Object[] objectArray = property.getNestedMetaProperties(5);
                    Arrays.sort(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!((MetaProperty)objectArray[i]).isInstantiated()) continue;
                        group.add(new Add(property, (MetaProperty)objectArray[i]));
                    }
                    viewContext.addActions(group);
                }
            }
            if (!list2.isEmpty() && !list2.contains(AdvancedEditor.this.tree.getRoot())) {
                viewContext.addAction(new Propagate(list2));
            }
            return viewContext;
        }
    }

    private class FocusPolicy
    extends LayoutFocusTraversalPolicy {
        private FocusPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            int[] nArray;
            Component component2 = super.getComponentAfter(container, component);
            if (component2 == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(component2, AdvancedEditor.this.bean) && (nArray = AdvancedEditor.this.tree.getSelectionRows()) != null && nArray.length > 0) {
                AdvancedEditor.this.tree.setSelectionRow((nArray[0] + 1) % AdvancedEditor.this.tree.getRowCount());
            }
            return component2;
        }

        public Component getComponentBefore(Container container, Component component) {
            Component component2 = super.getComponentBefore(container, component);
            if (component2 == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(component2, AdvancedEditor.this.bean)) {
                AdvancedEditor.this.tree.setSelectionRow((AdvancedEditor.this.tree.getSelectionRows()[0] - 1) % AdvancedEditor.this.tree.getRowCount());
            }
            return component2;
        }
    }

    private class Callback
    implements TreeSelectionListener,
    TreeWillExpandListener {
        private Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (AdvancedEditor.this.ignoreTreeSelection || AdvancedEditor.this.tree.getRoot() == null) {
                return;
            }
            List<Property> list = AdvancedEditor.this.tree.getSelection();
            Context context = new Context(AdvancedEditor.this.gedcom, Collections.singletonList((Entity)AdvancedEditor.this.tree.getRoot()), list);
            if (!list.isEmpty()) {
                try {
                    AdvancedEditor.this.ignoreTreeSelection = true;
                    SelectionSink.Dispatcher.fireSelection(AdvancedEditor.this, context, false);
                }
                finally {
                    AdvancedEditor.this.ignoreTreeSelection = false;
                }
            }
            AdvancedEditor.this.setContextImpl(context, false);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount();
            if (n == 1) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Property)treePath.getPathComponent(i)).getTag();
            }
            AdvancedEditor.this.expands.remove(new TagPath(stringArray, null));
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount();
            if (n == 1) {
                return;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Property)treePath.getPathComponent(i)).getTag();
            }
            AdvancedEditor.this.expands.add(new TagPath(stringArray, null));
        }
    }

    private class Add
    extends Action2 {
        private Property parent;
        private String[] tags;
        private boolean addDefaults = true;

        protected Add(Property property, MetaProperty metaProperty) {
            this.parent = property;
            String string = metaProperty.getName();
            if (!string.equals(metaProperty.getTag())) {
                string = string + " (" + metaProperty.getTag() + ")";
            }
            this.setText(string);
            this.setImage(metaProperty.getImage());
            this.tags = new String[]{metaProperty.getTag()};
        }

        protected Add(Property property) {
            this.parent = property;
            this.setText(resources.getString("action.add") + " ...");
            this.setImage(Images.imgAdd);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Serializable serializable;
            if (this.tags == null) {
                serializable = new JLabel(resources.getString("add.choose"));
                object2 = new ChoosePropertyBean(this.parent);
                object = new JCheckBox(resources.getString("add.default_too"), this.addDefaults);
                final DialogHelper.Dialog dialog = new DialogHelper.Dialog(resources.getString("add.title"), 3, new JComponent[]{serializable, object2, object}, (Action[])Action2.okCancel(), (Object)AdvancedEditor.this);
                ((ChoosePropertyBean)object2).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        dialog.close(0);
                    }
                });
                if (dialog.show() != 0) {
                    return;
                }
                this.tags = ((ChoosePropertyBean)object2).getSelectedTags();
                this.addDefaults = ((AbstractButton)object).isSelected();
                if (this.tags.length == 0) {
                    DialogHelper.openDialog(null, 0, resources.getString("add.must_enter"), (Action[])Action2.okOnly(), (Object)AdvancedEditor.this);
                    return;
                }
            }
            AdvancedEditor.this.tree.clearSelection();
            serializable = new ArrayList();
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork((List)((Object)serializable)){
                final /* synthetic */ List val$newProps;
                {
                    this.val$newProps = list;
                }

                public void perform(Gedcom gedcom) {
                    for (int i = 0; i < Add.this.tags.length; ++i) {
                        Property property = Add.this.parent.addProperty(Add.this.tags[i], "");
                        this.val$newProps.add(property);
                        if (!Add.this.addDefaults) continue;
                        property.addDefaultProperties();
                    }
                }
            });
            Object object3 = object2 = serializable.isEmpty() ? null : (Property)serializable.get(0);
            if (object2 instanceof PropertyEvent && (object = ((PropertyEvent)object2).getDate(false)) != null) {
                object2 = object;
            }
            AdvancedEditor.this.tree.setSelectionPath(new TreePath(AdvancedEditor.this.tree.getPathFor((Property)object2)));
        }
    }

    private class Follow
    extends Action2 {
        private PropertyXRef xref;

        public Follow(PropertyXRef propertyXRef) {
            this.xref = propertyXRef;
            this.setText(Gedcom.getName(propertyXRef.getTag()));
            this.setImage(propertyXRef.getImage(false));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectionSink.Dispatcher.fireSelection(AdvancedEditor.this, new Context(this.xref), true);
        }
    }

    private class Paste
    extends Action2 {
        private Property presetParent;

        protected Paste(Property property) {
            this.presetParent = property;
            this.setText(resources.getString("action.paste"));
            this.setImage(Images.imgPaste);
        }

        protected Paste() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Property property;
            String string;
            try {
                string = clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
            }
            catch (Throwable throwable) {
                EditView.LOG.log(Level.INFO, "Accessing system clipboard as stringFlavor failed (" + throwable.getMessage() + ")");
                return;
            }
            if (this.presetParent != null) {
                property = this.presetParent;
            } else if (AdvancedEditor.this.tree.getSelectionCount() == 1) {
                property = AdvancedEditor.this.tree.getSelection().get(0);
            } else {
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    PropertyReader propertyReader = new PropertyReader(new StringReader(string), null, true);
                    propertyReader.setMerge(true);
                    try {
                        propertyReader.read(property);
                    }
                    catch (IOException iOException) {
                        throw new GedcomException("IO during read()");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Copy
    extends Action2 {
        protected List<Property> presetSelection;

        protected Copy(List<Property> list) {
            this.presetSelection = Property.normalize(list);
            this.setText(resources.getString("action.copy"));
            this.setImage(Images.imgCopy);
        }

        protected Copy() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Property> list = this.presetSelection;
            if (list == null) {
                list = Property.normalize(AdvancedEditor.this.tree.getSelection());
            }
            if (list.contains(AdvancedEditor.this.tree.getRoot())) {
                list = Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties());
            }
            try {
                clipboard.setContents(new PropertyTransferable(list).getStringTransferable(), null);
            }
            catch (Throwable throwable) {
                EditView.LOG.log(Level.WARNING, "Couldn't copy properties", throwable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cut
    extends Action2 {
        protected List<Property> presetSelection;

        private Cut(List<Property> list) {
            this.presetSelection = Property.normalize(list);
            super.setImage(Images.imgCut);
            super.setText(resources.getString("action.cut"));
        }

        private Cut() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string;
            List<Property> list;
            List<Property> list2 = list = this.presetSelection != null ? this.presetSelection : Property.normalize(AdvancedEditor.this.tree.getSelection());
            if (list.isEmpty()) {
                return;
            }
            if (list.contains(AdvancedEditor.this.tree.getRoot())) {
                list.clear();
                list.addAll(Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties()));
            }
            if ((string = this.getVeto(list)).length() > 0 && (n = DialogHelper.openDialog(resources.getString("action.cut"), 2, string, new Action[]{new Action2(resources.getString("action.cut")), Action2.cancel()}, (Object)AdvancedEditor.this)) != 0) {
                return;
            }
            try {
                clipboard.setContents(new PropertyTransferable(list).getStringTransferable(), null);
            }
            catch (Throwable throwable) {
                EditView.LOG.log(Level.WARNING, "Couldn't copy properties", throwable);
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    for (Property property : list) {
                        property.getParent().delProperty(property);
                    }
                }
            });
        }

        private String getVeto(List<Property> list) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Property property : list) {
                String string = property.getDeleteVeto();
                if (string == null) continue;
                stringBuffer.append(resources.getString("del.warning", property.getPropertyName(), property.getParent().getPropertyName(), string));
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Propagate
    extends Action2 {
        private Entity entity;
        private List<Property> properties;
        private String what;

        private Propagate(List<Property> list) {
            this.entity = (Entity)AdvancedEditor.this.tree.getRoot();
            this.properties = Property.normalize(list);
            if (this.properties.isEmpty()) {
                this.setText(resources.getString("action.propagate", ""));
                this.setEnabled(false);
                return;
            }
            this.what = "'" + Property.getPropertyNames(this.properties, 5) + "' (" + this.properties.size() + ")";
            this.setText(resources.getString("action.propagate", this.what) + " ...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            final TextAreaWidget textAreaWidget = new TextAreaWidget("", 4, 10, false, true);
            final SelectEntityWidget selectEntityWidget = new SelectEntityWidget(AdvancedEditor.this.gedcom, this.entity.getTag(), resources.getString("action.propagate.toall"));
            selectEntityWidget.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Entity entity = selectEntityWidget.getSelection();
                    String string = entity == null ? resources.getString("action.propagate.all", Propagate.this.what, "" + selectEntityWidget.getEntityCount(), Gedcom.getName(Propagate.this.entity.getTag())) : resources.getString("action.propagate.one", Propagate.this.what, entity.getId(), Gedcom.getName(entity.getTag()));
                    textAreaWidget.setText(string);
                }
            });
            final JCheckBox jCheckBox = new JCheckBox(resources.getString("action.propagate.value"));
            JPanel jPanel = new JPanel(new NestedBlockLayout("<col><select wx=\"1\"/><note wx=\"1\" wy=\"1\"/><check wx=\"1\"/></col>"));
            jPanel.add(selectEntityWidget);
            jPanel.add(new JScrollPane(textAreaWidget));
            jPanel.add(jCheckBox);
            selectEntityWidget.setSelection(AdvancedEditor.this.gedcom.getEntity(REGISTRY.get("select." + this.entity.getTag(), (String)null)));
            boolean bl2 = bl = 0 != DialogHelper.openDialog(this.getText(), 2, jPanel, (Action[])Action2.okCancel(), (Object)AdvancedEditor.this);
            if (bl) {
                return;
            }
            final Entity entity = selectEntityWidget.getSelection();
            REGISTRY.put("select." + this.entity.getTag(), entity != null ? entity.getId() : null);
            try {
                AdvancedEditor.this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        for (Entity entity2 : entity != null ? Collections.singletonList(entity) : gedcom.getEntities(Propagate.this.entity.getTag())) {
                            Propagate.this.copy(Propagate.this.properties, Propagate.this.entity, entity2, jCheckBox.isSelected());
                        }
                    }
                });
            }
            catch (GedcomException gedcomException) {
                DialogHelper.openDialog(null, 0, gedcomException.getMessage(), (Action[])Action2.okOnly(), (Object)AdvancedEditor.this);
            }
        }

        private void copy(List<Property> list, Entity entity, Entity entity2, boolean bl) throws GedcomException {
            if (entity == entity2) {
                return;
            }
            for (Property property : list) {
                TagPath tagPath = property.getParent().getPath();
                Property property2 = entity2.getProperty(tagPath);
                if (property2 == null) {
                    property2 = entity2.setValue(tagPath, "");
                }
                property2.copyProperties(property, bl);
            }
        }
    }
}

