/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.EditView;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.swing.HeadlessLabel;
import genj.util.swing.ImageIcon;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import spin.Spin;
import swingx.dnd.tree.DnDTree;
import swingx.dnd.tree.DnDTreeModel;
import swingx.tree.AbstractTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTreeWidget
extends DnDTree
implements ContextProvider {
    private static final String UNIX_DND_FILE_PREFIX = "file:";
    private DefaultTreeCellRenderer defaultRenderer;
    private Gedcom gedcom;
    private static Gedcom draggingFrom = null;

    public PropertyTreeWidget(Gedcom gedcom) {
        super.setModel(new Model(gedcom));
        this.gedcom = gedcom;
        this.setCellRenderer(new Renderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setToggleClickCount(Integer.MAX_VALUE);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    return;
                }
                TreePath treePath = PropertyTreeWidget.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (!PropertyTreeWidget.this.getSelection().contains(treePath.getLastPathComponent())) {
                    PropertyTreeWidget.this.setSelection(Collections.singletonList((Property)treePath.getLastPathComponent()));
                }
            }
        });
        this.setExpandsSelectedPaths(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public ViewContext getContext() {
        Entity entity = (Entity)this.getRoot();
        if (entity == null) {
            return new ViewContext(this.gedcom);
        }
        List<Property> list = this.getSelection();
        if (list.isEmpty()) {
            return new ViewContext(entity);
        }
        return new ViewContext(this.gedcom, (List<Entity>)new ArrayList<Entity>(), list);
    }

    public void setModel() {
        throw new IllegalArgumentException();
    }

    private Model getPropertyModel() {
        return (Model)this.getModel();
    }

    public Object[] getPathFor(Property property) {
        return this.getPropertyModel().getPathToRoot(property);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)this.getPropertyModel()));
    }

    @Override
    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)this.getPropertyModel()));
        super.removeNotify();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(256, 128);
    }

    public void setRoot(Property property) {
        if (this.getPropertyModel().getRoot() == property) {
            return;
        }
        this.getPropertyModel().setRoot(property);
    }

    public void expandAllRows() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expand(TagPath tagPath) {
        block0: for (int i = this.getRowCount() - 1; i >= 0; --i) {
            TreePath treePath = this.getPathForRow(i);
            if (tagPath.length() != treePath.getPathCount()) continue;
            for (int j = 0; j < tagPath.length(); ++j) {
                if (!tagPath.get(j).equals(((Property)treePath.getPathComponent(j)).getTag())) continue block0;
            }
            this.expandRow(i);
        }
    }

    public Property getRoot() {
        return this.getPropertyModel().getPropertyRoot();
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(0);
    }

    public void setSelection(List<? extends Property> list) {
        this.clearSelection();
        Property property = (Property)this.getPropertyModel().getRoot();
        if (property == null) {
            return;
        }
        TreePath treePath = null;
        for (Property property2 : list) {
            try {
                TreePath treePath2 = new TreePath(this.getPropertyModel().getPathToRoot(property2));
                this.addSelectionPath(treePath2);
                if (treePath != null) continue;
                treePath = treePath2;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (treePath != null) {
            this.scrollPathToVisible(treePath);
        }
    }

    public List<Property> getSelection() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        TreePath[] treePathArray = this.getSelectionPaths();
        for (int i = 0; treePathArray != null && i < treePathArray.length; ++i) {
            arrayList.add((Property)treePathArray[i].getLastPathComponent());
        }
        return arrayList;
    }

    public Property getPropertyAt(int n, int n2) {
        TreePath treePath = super.getPathForLocation(n, n2);
        if (treePath == null || treePath.getPathCount() == 0) {
            return null;
        }
        return (Property)treePath.getLastPathComponent();
    }

    public Property getPropertyAt(Point point) {
        return this.getPropertyAt(point.x, point.y);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Property property = this.getPropertyAt(mouseEvent.getX(), mouseEvent.getY());
        if (property == null) {
            return null;
        }
        if (property.isTransient()) {
            return null;
        }
        if (property.getEntity() == null) {
            return null;
        }
        String string = property.getPropertyInfo();
        if (string == null) {
            return null;
        }
        return "<html><table width=200><tr><td>" + string + "</td></tr></table></html";
    }

    @Override
    public void setUI(TreeUI treeUI) {
        super.setUI(treeUI);
        this.defaultRenderer = new DefaultTreeCellRenderer();
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof Property) {
            return ((Property)object).getTag();
        }
        return "";
    }

    private abstract class IOUnitOfWork
    implements UnitOfWork {
        private IOUnitOfWork() {
        }

        public final void perform(Gedcom gedcom) throws GedcomException {
            try {
                this.performIO(gedcom);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        protected abstract void performIO(Gedcom var1) throws IOException, UnsupportedFlavorException;
    }

    private class Renderer
    extends HeadlessLabel
    implements TreeCellRenderer {
        private Renderer() {
            this.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (!(object instanceof Property)) {
                return this;
            }
            Property property = (Property)object;
            if (PropertyTreeWidget.this.defaultRenderer != null) {
                if (bl) {
                    this.setForeground(PropertyTreeWidget.this.defaultRenderer.getTextSelectionColor());
                    this.setBackground(PropertyTreeWidget.this.defaultRenderer.getBackgroundSelectionColor());
                } else {
                    this.setForeground(PropertyTreeWidget.this.defaultRenderer.getTextNonSelectionColor());
                    this.setBackground(PropertyTreeWidget.this.defaultRenderer.getBackgroundNonSelectionColor());
                }
            }
            ImageIcon imageIcon = property.getImage(true);
            this.setIcon(imageIcon);
            this.setText(property instanceof Entity ? this.calcText((Entity)property) : this.calcText(property));
            return this;
        }

        private String calcText(Entity entity) {
            return "@" + entity.getId() + "@ " + entity.getTag();
        }

        private String calcText(Property property) {
            String string;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            if (!property.isTransient()) {
                stringBuffer.append(property.getTag());
                stringBuffer.append(' ');
            }
            if ((n = (string = property.getDisplayValue()).indexOf(10)) >= 0) {
                string = string.substring(0, n) + "...";
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
    }

    private class Model
    extends AbstractTreeModel
    implements DnDTreeModel,
    GedcomListener {
        private Property root = null;
        private Gedcom ged;

        protected Model(Gedcom gedcom) {
            this.ged = gedcom;
        }

        protected void setRoot(Property property) {
            this.root = property;
            this.rootExchanged();
            PropertyTreeWidget.this.setRootVisible(this.root != null);
        }

        public Property getPropertyRoot() {
            return this.root;
        }

        public Transferable createTransferable(Object[] objectArray) {
            draggingFrom = this.ged;
            ArrayList<Property> arrayList = new ArrayList<Property>(objectArray.length);
            for (Object object : objectArray) {
                arrayList.add((Property)object);
            }
            List<Property> list = Property.normalize(arrayList);
            return new PropertyTransferable(list);
        }

        public int getDragActions(Transferable transferable) {
            return 3;
        }

        public int getDropActions(Transferable transferable, Object object, int n) {
            try {
                if (transferable.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                    List list = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                    for (Property property = (Property)object; property != null; property = property.getParent()) {
                        if (!list.contains(property)) continue;
                        return 0;
                    }
                    return 3;
                }
                if (transferable.isDataFlavorSupported(PropertyTransferable.STRING_FLAVOR)) {
                    return 3;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return 3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void drop(final Transferable transferable, Object object, final int n, final int n2) throws IOException, UnsupportedFlavorException {
            final Property property = (Property)object;
            if (transferable.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                final List list = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                if (n2 == 2 && property.hasProperties(list)) {
                    this.ged.doMuteUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            property.moveProperties(list, n);
                        }
                    });
                    return;
                }
                this.ged.doMuteUnitOfWork(new IOUnitOfWork(){

                    protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                        ArrayList arrayList = new ArrayList();
                        String string = transferable.getTransferData(PropertyTransferable.STRING_FLAVOR).toString();
                        new PropertyReader(new StringReader(string), arrayList, true).read(property, n);
                        if (n2 == 2 && draggingFrom == gedcom) {
                            for (Property property22 : list) {
                                property22.getParent().delProperty(property22);
                            }
                        }
                        for (Property property22 : arrayList) {
                            try {
                                ((PropertyXRef)property22).link();
                            }
                            catch (Throwable throwable) {
                                EditView.LOG.log(Level.WARNING, "caught exception during dnd trying to link xrefs", throwable);
                            }
                        }
                    }
                });
                return;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.ged.doMuteUnitOfWork(new IOUnitOfWork(){

                    protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                        for (File file : (List)transferable.getTransferData(DataFlavor.javaFileListFlavor)) {
                            property.addFile(file);
                        }
                    }
                });
                return;
            }
            if (!transferable.isDataFlavorSupported(PropertyTransferable.STRING_FLAVOR)) {
                return;
            }
            final String string = transferable.getTransferData(PropertyTransferable.STRING_FLAVOR).toString();
            if (string.length() < 4) {
                return;
            }
            if (string.startsWith(PropertyTreeWidget.UNIX_DND_FILE_PREFIX)) {
                this.ged.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken().trim();
                            if (!string2.startsWith(PropertyTreeWidget.UNIX_DND_FILE_PREFIX)) continue;
                            property.addFile(new File(string2.substring(PropertyTreeWidget.UNIX_DND_FILE_PREFIX.length())));
                        }
                    }
                });
                return;
            }
            EditView.LOG.fine("reading dropped text '" + string + "'");
            this.ged.doMuteUnitOfWork(new IOUnitOfWork(){

                protected void performIO(Gedcom gedcom) throws IOException, UnsupportedFlavorException {
                    new PropertyReader(new StringReader(string), null, true).read(property, n);
                }
            });
        }

        public void drag(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
            final List list = (List)transferable.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
            if (list.isEmpty()) {
                return;
            }
            if (n == 2 && draggingFrom != this.ged) {
                this.ged.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) {
                        for (int i = 0; i < list.size(); ++i) {
                            Property property = (Property)list.get(i);
                            property.getParent().delProperty(property);
                        }
                    }
                });
            }
        }

        public void releaseTransferable(Transferable transferable) {
            draggingFrom = null;
        }

        protected Object getParent(Object object) {
            if (object == this.root) {
                return null;
            }
            return ((Property)object).getParent();
        }

        public Object getChild(Object object, int n) {
            return ((Property)object).getProperty(n);
        }

        public int getChildCount(Object object) {
            return ((Property)object).getNoOfProperties();
        }

        public int getIndexOfChild(Object object, Object object2) {
            try {
                return ((Property)object).getPropertyPosition((Property)object2);
            }
            catch (Throwable throwable) {
                return -1;
            }
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            return ((Property)object).getNoOfProperties() == 0;
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (this.root == entity) {
                this.setRoot(null);
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
            if (this.root != property.getEntity()) {
                return;
            }
            Object[] objectArray = PropertyTreeWidget.this.getPathFor(property);
            this.fireTreeNodesInserted(this, objectArray, new int[]{n}, new Property[]{property2});
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (this.root != property.getEntity()) {
                return;
            }
            this.fireTreeNodesChanged(this, PropertyTreeWidget.this.getPathFor(property), null, null);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            if (this.root != property.getEntity()) {
                return;
            }
            if (property instanceof PropertyChange) {
                return;
            }
            this.fireTreeNodesRemoved(this, PropertyTreeWidget.this.getPathFor(property), new int[]{n}, new Property[]{property2});
        }
    }
}

