/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.Images;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextAreaWidget;
import genj.view.SelectionSink;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractChange
extends Action2 {
    static final Resources resources = Resources.get(AbstractChange.class);
    protected Gedcom gedcom;
    private Context selection;
    protected static final ImageIcon imgNew = Images.imgNew;
    private JTextArea confirm;

    public AbstractChange(Gedcom gedcom, ImageIcon imageIcon, String string) {
        this.gedcom = gedcom;
        super.setImage(imageIcon);
        super.setText(string);
        super.setTip(string);
    }

    protected String getConfirmMessage() {
        return null;
    }

    protected JPanel getDialogContent() {
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><text wx=\"1\" wy=\"1\"/></col>"));
        jPanel.add(this.getConfirmComponent());
        return jPanel;
    }

    protected JComponent getConfirmComponent() {
        if (this.confirm == null) {
            this.confirm = new TextAreaWidget(this.getConfirmMessage(), 6, 40);
            this.confirm.setWrapStyleWord(true);
            this.confirm.setLineWrap(true);
            this.confirm.setEditable(false);
        }
        return new JScrollPane(this.confirm);
    }

    protected void refresh() {
        if (this.confirm != null) {
            this.confirm.setText(this.getConfirmMessage());
        }
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        SelectionSink selectionSink = SelectionSink.Dispatcher.getSink(actionEvent);
        this.confirm = null;
        String string = this.getConfirmMessage();
        if (string != null) {
            Action[] actionArray = new Action[]{new Action2(resources.getString("confirm.proceed", this.getText())), Action2.cancel()};
            int n = DialogHelper.openDialog(this.getText(), 3, this.getDialogContent(), actionArray, (Object)actionEvent);
            if (n != 0) {
                return;
            }
        }
        try {
            this.gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    AbstractChange.this.selection = AbstractChange.this.execute(gedcom, actionEvent);
                }
            });
        }
        catch (Throwable throwable) {
            DialogHelper.openDialog(null, 0, throwable.getMessage(), (Action[])Action2.okOnly(), (Object)actionEvent);
        }
        if (this.selection != null && selectionSink != null) {
            selectionSink.fireSelection(this.selection, true);
        }
    }

    protected abstract Context execute(Gedcom var1, ActionEvent var2) throws GedcomException;
}

